/*
 * Decompiled with CFR 0.152.
 */
package spire.macros;

import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.api.Exprs;
import scala.reflect.api.Internals;
import scala.reflect.api.Mirror;
import scala.reflect.api.Names;
import scala.reflect.api.Symbols;
import scala.reflect.api.TreeCreator;
import scala.reflect.api.Trees;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.macros.whitebox.Context;
import scala.runtime.Nothing$;
import spire.macros.ArithmeticOverflowException;
import spire.macros.Checked$;
import spire.macros.CheckedRewriter;

public final class Checked$ {
    public static final Checked$ MODULE$;

    static {
        new Checked$();
    }

    public <A> Exprs.Expr<A> checkedImpl(Context c, Exprs.Expr<A> n) {
        Trees.TreeApi tree = new CheckedRewriter<Context>(c).apply(n.tree());
        Trees.TreeApi resetTree = c.resetLocalAttrs(tree);
        scala.reflect.macros.Universe $u = c.universe();
        Mirror $m = c.universe().rootMirror();
        public final class Spire_macros_Checked$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Internals.FreeTypeSymbolApi free$A1 = $u.internal().reificationSupport().newFreeType("A", $u.internal().reificationSupport().FlagsRepr().apply(8208L), "defined by checkedImpl in Checked.scala:18:19");
                $u.internal().reificationSupport().setInfo((Symbols.SymbolApi)free$A1, (Types.TypeApi)$u.internal().reificationSupport().TypeBounds($m$untyped.staticClass("scala.Nothing").asType().toTypeConstructor(), $m$untyped.staticClass("scala.Any").asType().toTypeConstructor()));
                return $u.internal().reificationSupport().TypeRef($u.NoPrefix(), (Symbols.SymbolApi)free$A1, (List)Nil$.MODULE$);
            }

            public Spire_macros_Checked$$typecreator1$1() {
            }
        }
        return c.Expr(resetTree, $u.WeakTypeTag().apply($m, (TypeCreator)new Spire_macros_Checked$$typecreator1$1()));
    }

    public <A> Exprs.Expr<Option<A>> optionImpl(Context c, Exprs.Expr<A> n) {
        Exprs.Expr<A> checkedExpr = this.checkedImpl(c, n);
        scala.reflect.macros.Universe $u = c.universe();
        Mirror $m = c.universe().rootMirror();
        public final class Spire_macros_Checked$$treecreator1$1
        extends TreeCreator {
            private final Exprs.Expr checkedExpr$1;

            public <U extends Universe> Trees.TreeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                return $u.Try().apply((Trees.TreeApi)$u.Apply().apply((Trees.TreeApi)$u.Select().apply((Trees.TreeApi)$u.internal().reificationSupport().mkIdent((Symbols.SymbolApi)$m$untyped.staticModule("scala.Some")), (Names.NameApi)$u.TermName().apply("apply")), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.TreeApi[]{this.checkedExpr$1.in($m$untyped).tree()}))), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Trees.CaseDefApi[]{$u.CaseDef().apply((Trees.TreeApi)$u.Bind().apply((Names.NameApi)$u.TermName().apply("ex"), (Trees.TreeApi)$u.Typed().apply((Trees.TreeApi)$u.Ident().apply((Names.NameApi)$u.TermName().apply("_")), (Trees.TreeApi)$u.internal().reificationSupport().mkIdent((Symbols.SymbolApi)$m$untyped.staticClass("spire.macros.ArithmeticOverflowException")))), $u.EmptyTree(), (Trees.TreeApi)$u.internal().reificationSupport().mkIdent((Symbols.SymbolApi)$m$untyped.staticModule("scala.None")))})), $u.EmptyTree());
            }

            public Spire_macros_Checked$$treecreator1$1(Exprs.Expr checkedExpr$1) {
                this.checkedExpr$1 = checkedExpr$1;
            }
        }
        public final class Spire_macros_Checked$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Internals.FreeTypeSymbolApi free$A2 = $u.internal().reificationSupport().newFreeType("A", $u.internal().reificationSupport().FlagsRepr().apply(8208L), "defined by optionImpl in Checked.scala:31:18");
                $u.internal().reificationSupport().setInfo((Symbols.SymbolApi)free$A2, (Types.TypeApi)$u.internal().reificationSupport().TypeBounds($m$untyped.staticClass("scala.Nothing").asType().toTypeConstructor(), $m$untyped.staticClass("scala.Any").asType().toTypeConstructor()));
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m$untyped.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m$untyped.staticClass("scala.Option"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.NoPrefix(), (Symbols.SymbolApi)free$A2, (List)Nil$.MODULE$)})));
            }

            public Spire_macros_Checked$$typecreator3$1() {
            }
        }
        return $u.Expr().apply($m, (TreeCreator)new Spire_macros_Checked$$treecreator1$1(checkedExpr), $u.WeakTypeTag().apply($m, (TypeCreator)new Spire_macros_Checked$$typecreator3$1()));
    }

    private final Nothing$ overflowLong() {
        throw new ArithmeticOverflowException("Long arithmetic overflow");
    }

    private final Nothing$ overflowInt() {
        throw new ArithmeticOverflowException("Int arithmetic overflow");
    }

    public final long negate(long x) {
        if (x != Long.MIN_VALUE) {
            return -x;
        }
        throw new ArithmeticOverflowException("Long arithmetic overflow");
    }

    public final long plus(long x, long y) {
        long z = x + y;
        if (((x ^ y ^ 0xFFFFFFFFFFFFFFFFL) & (x ^ z)) >= 0L) {
            return z;
        }
        throw new ArithmeticOverflowException("Long arithmetic overflow");
    }

    public final long minus(long x, long y) {
        long z = x - y;
        if (((x ^ y) & (x ^ z)) >= 0L) {
            return z;
        }
        throw new ArithmeticOverflowException("Long arithmetic overflow");
    }

    public final long times(long x, long y) {
        long z = x * y;
        if (x == 0L || y == z / x && (x != -1L || y != Long.MIN_VALUE)) {
            return z;
        }
        throw new ArithmeticOverflowException("Long arithmetic overflow");
    }

    public final long div(long x, long y) {
        long z = x / y;
        if (y != -1L || x != Long.MIN_VALUE) {
            return z;
        }
        throw new ArithmeticOverflowException("Long arithmetic overflow");
    }

    public final int negate(int x) {
        if (x != Integer.MIN_VALUE) {
            return -x;
        }
        throw new ArithmeticOverflowException("Int arithmetic overflow");
    }

    public final int plus(int x, int y) {
        int z = x + y;
        if ((long)(~(x ^ y) & (x ^ z)) >= 0L) {
            return z;
        }
        throw new ArithmeticOverflowException("Int arithmetic overflow");
    }

    public final int minus(int x, int y) {
        int z = x - y;
        if ((long)((x ^ y) & (x ^ z)) >= 0L) {
            return z;
        }
        throw new ArithmeticOverflowException("Int arithmetic overflow");
    }

    public final int times(int x, int y) {
        int z = x * y;
        if ((long)x == 0L || y == z / x && ((long)x != -1L || y != Integer.MIN_VALUE)) {
            return z;
        }
        throw new ArithmeticOverflowException("Int arithmetic overflow");
    }

    public final int div(int x, int y) {
        int z = x / y;
        if ((long)y != -1L || x != Integer.MIN_VALUE) {
            return z;
        }
        throw new ArithmeticOverflowException("Int arithmetic overflow");
    }

    private Checked$() {
        MODULE$ = this;
    }
}

