/*
 * Decompiled with CFR 0.152.
 */
package spire.math.poly;

import java.util.Arrays;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.runtime.BoxesRunTime;
import spire.algebra.Eq;
import spire.algebra.Field;
import spire.algebra.Rig;
import spire.algebra.Ring;
import spire.algebra.Rng;
import spire.algebra.Semiring;
import spire.implicits$;
import spire.math.Polynomial;
import spire.math.Polynomial$;
import spire.math.Polynomial$mcD$sp;
import spire.math.Polynomial$mcD$sp$class;
import spire.math.poly.PolyDense;
import spire.math.poly.PolySparse;
import spire.math.poly.PolySparse$;
import spire.math.poly.Term;
import spire.syntax.LiteralIntMultiplicativeSemigroupOps$;

public class PolySparse$mcD$sp
extends PolySparse<Object>
implements Polynomial$mcD$sp {
    public final double[] coeff$mcD$sp;

    @Override
    public List<Term<Object>> terms(Semiring<Object> ring, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.terms(this, ring, eq);
    }

    @Override
    public List<Term<Object>> terms$mcD$sp(Semiring<Object> ring, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.terms$mcD$sp(this, ring, eq);
    }

    @Override
    public Map<Object, Object> data(Semiring<Object> ring, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.data(this, ring, eq);
    }

    @Override
    public Map<Object, Object> data$mcD$sp(Semiring<Object> ring, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.data$mcD$sp(this, ring, eq);
    }

    @Override
    public Term<Object> maxTerm(Semiring<Object> ring) {
        return Polynomial$mcD$sp$class.maxTerm(this, ring);
    }

    @Override
    public Term<Object> maxTerm$mcD$sp(Semiring<Object> ring) {
        return Polynomial$mcD$sp$class.maxTerm$mcD$sp(this, ring);
    }

    @Override
    public Polynomial<Object> compose(Polynomial<Object> y, Rig<Object> ring, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.compose(this, y, ring, eq);
    }

    @Override
    public Polynomial<Object> compose$mcD$sp(Polynomial<Object> y, Rig<Object> ring, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.compose$mcD$sp(this, y, ring, eq);
    }

    @Override
    public Polynomial<Object> monic(Field<Object> f, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.monic(this, f, eq);
    }

    @Override
    public Polynomial<Object> monic$mcD$sp(Field<Object> f, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.monic$mcD$sp(this, f, eq);
    }

    @Override
    public Polynomial<Object> $minus(Polynomial<Object> rhs, Rng<Object> ring, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.$minus(this, rhs, ring, eq);
    }

    @Override
    public Polynomial<Object> $minus$mcD$sp(Polynomial<Object> rhs, Rng<Object> ring, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.$minus$mcD$sp(this, rhs, ring, eq);
    }

    @Override
    public Polynomial<Object> $div$tilde(Polynomial<Object> rhs, Field<Object> field, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.$div$tilde(this, rhs, field, eq);
    }

    @Override
    public Polynomial<Object> $div$tilde$mcD$sp(Polynomial<Object> rhs, Field<Object> field, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.$div$tilde$mcD$sp(this, rhs, field, eq);
    }

    @Override
    public Polynomial<Object> $percent(Polynomial<Object> rhs, Field<Object> field, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.$percent(this, rhs, field, eq);
    }

    @Override
    public Polynomial<Object> $percent$mcD$sp(Polynomial<Object> rhs, Field<Object> field, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.$percent$mcD$sp(this, rhs, field, eq);
    }

    @Override
    public Polynomial<Object> $times$times(int k, Rig<Object> ring, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.$times$times(this, k, ring, eq);
    }

    @Override
    public Polynomial<Object> $times$times$mcD$sp(int k, Rig<Object> ring, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.$times$times$mcD$sp(this, k, ring, eq);
    }

    @Override
    public Polynomial<Object> pow(int k, Rig<Object> ring, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.pow(this, k, ring, eq);
    }

    @Override
    public Polynomial<Object> pow$mcD$sp(int k, Rig<Object> ring, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.pow$mcD$sp(this, k, ring, eq);
    }

    @Override
    public Polynomial<Object> $colon$times(double k, Semiring<Object> ring, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.$colon$times(this, k, ring, eq);
    }

    @Override
    public Polynomial<Object> $colon$times$mcD$sp(double k, Semiring<Object> ring, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.$colon$times$mcD$sp(this, k, ring, eq);
    }

    @Override
    public Polynomial<Object> $colon$div(double k, Field<Object> field, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.$colon$div(this, k, field, eq);
    }

    @Override
    public Polynomial<Object> $colon$div$mcD$sp(double k, Field<Object> field, Eq<Object> eq) {
        return Polynomial$mcD$sp$class.$colon$div$mcD$sp(this, k, field, eq);
    }

    @Override
    public double[] coeff$mcD$sp() {
        return this.coeff$mcD$sp;
    }

    public double[] coeff() {
        return this.coeff$mcD$sp();
    }

    @Override
    public PolyDense<Object> toDense(Semiring<Object> ring, Eq<Object> eq) {
        return this.toDense$mcD$sp(ring, eq);
    }

    @Override
    public PolyDense<Object> toDense$mcD$sp(Semiring<Object> ring, Eq<Object> eq) {
        return Polynomial$.MODULE$.dense$mDc$sp(this.coeffsArray$mcD$sp(ring), ring, eq, this.ct());
    }

    @Override
    public PolySparse<Object> toSparse(Semiring<Object> ring, Eq<Object> eq) {
        return this.toSparse$mcD$sp(ring, eq);
    }

    @Override
    public PolySparse<Object> toSparse$mcD$sp(Semiring<Object> ring, Eq<Object> eq) {
        return this;
    }

    @Override
    public <U> void foreach(Function2<Object, Object, U> f) {
        this.foreach$mcD$sp(f);
    }

    @Override
    public <U> void foreach$mcD$sp(Function2<Object, Object, U> f) {
        for (int index$macro$24 = 0; index$macro$24 < this.exp().length; ++index$macro$24) {
            f.apply((Object)BoxesRunTime.boxToInteger((int)this.exp()[index$macro$24]), (Object)BoxesRunTime.boxToDouble((double)this.coeff()[index$macro$24]));
        }
    }

    @Override
    public <U> void foreachNonZero(Function2<Object, Object, U> f, Semiring<Object> ring, Eq<Object> eq) {
        this.foreachNonZero$mcD$sp(f, ring, eq);
    }

    @Override
    public <U> void foreachNonZero$mcD$sp(Function2<Object, Object, U> f, Semiring<Object> ring, Eq<Object> eq) {
        this.foreach$mcD$sp(f);
    }

    @Override
    public double[] coeffsArray(Semiring<Object> ring) {
        return this.coeffsArray$mcD$sp(ring);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] coeffsArray$mcD$sp(Semiring<Object> ring) {
        double[] dArray;
        if (this.isZero()) {
            dArray = (double[])this.ct().newArray(0);
        } else {
            void var2_2;
            double[] cs = (double[])this.ct().newArray(this.degree() + 1);
            for (int index$macro$25 = 0; index$macro$25 < cs.length; ++index$macro$25) {
                cs[index$macro$25] = ring.zero$mcD$sp();
            }
            for (int index$macro$26 = 0; index$macro$26 < this.exp().length; ++index$macro$26) {
                cs[this.exp()[index$macro$26]] = this.coeff()[index$macro$26];
            }
            dArray = var2_2;
        }
        return dArray;
    }

    @Override
    public double nth(int n, Semiring<Object> ring) {
        return this.nth$mcD$sp(n, ring);
    }

    @Override
    public double nth$mcD$sp(int n, Semiring<Object> ring) {
        int i = Arrays.binarySearch(this.exp(), n);
        return i >= 0 ? this.coeff()[i] : ring.zero$mcD$sp();
    }

    @Override
    public double maxOrderTermCoeff(Semiring<Object> ring) {
        return this.maxOrderTermCoeff$mcD$sp(ring);
    }

    @Override
    public double maxOrderTermCoeff$mcD$sp(Semiring<Object> ring) {
        return this.isZero() ? ring.zero$mcD$sp() : this.coeff()[this.coeff().length - 1];
    }

    public final double[] expBits(double x, Semiring<Object> ring) {
        return this.expBits$mcD$sp(x, ring);
    }

    @Override
    public final double[] expBits$mcD$sp(double x, Semiring<Object> ring) {
        double[] bits = (double[])this.ct().newArray(package$.MODULE$.max(2, 32 - Integer.numberOfLeadingZeros(this.degree())));
        bits[0] = x;
        if (bits.length > 1) {
            bits[1] = ring.pow$mcD$sp(x, 2);
        }
        for (int index$macro$27 = 2; index$macro$27 < bits.length; ++index$macro$27) {
            double prev = bits[index$macro$27 - 1];
            bits[index$macro$27] = ring.times$mcD$sp(prev, prev);
        }
        return bits;
    }

    public final double fastExp(double[] bits, int e, int i, double acc, Semiring<Object> ring) {
        return this.fastExp$mcD$sp(bits, e, i, acc, ring);
    }

    @Override
    public final double fastExp$mcD$sp(double[] bits, int e, int i, double acc, Semiring<Object> ring) {
        while (e != 0) {
            int lb = Integer.numberOfTrailingZeros(e) + 1;
            int j = i + lb;
            acc = ring.times$mcD$sp(acc, bits[j - 1]);
            i = j;
            e >>>= lb;
        }
        return acc;
    }

    public final double fastExp(double[] bits, int e, Semiring<Object> ring) {
        return this.fastExp$mcD$sp(bits, e, ring);
    }

    @Override
    public final double fastExp$mcD$sp(double[] bits, int e, Semiring<Object> ring) {
        int lb = Integer.numberOfTrailingZeros(e) + 1;
        return this.fastExp$mcD$sp(bits, e >>> lb, lb, bits[lb - 1], ring);
    }

    @Override
    public double apply(double x, Semiring<Object> ring) {
        return this.apply$mcD$sp(x, ring);
    }

    @Override
    public double apply$mcD$sp(double x, Semiring<Object> ring) {
        double d;
        if (this.isZero()) {
            d = ring.zero$mcD$sp();
        } else if (this.exp().length == 1) {
            d = this.exp()[0] != 0 ? ring.times$mcD$sp(this.coeff()[0], ring.pow$mcD$sp(x, this.exp()[0])) : this.coeff()[0];
        } else {
            double[] bits = this.expBits$mcD$sp(x, ring);
            int e0 = this.exp()[0];
            double c0 = this.coeff()[0];
            double sum2 = e0 == 0 ? c0 : ring.times$mcD$sp(c0, this.fastExp$mcD$sp(bits, e0, ring));
            for (int index$macro$28 = 1; index$macro$28 < this.exp().length; ++index$macro$28) {
                sum2 = ring.plus$mcD$sp(sum2, ring.times$mcD$sp(this.coeff()[index$macro$28], this.fastExp$mcD$sp(bits, this.exp()[index$macro$28], ring)));
            }
            d = sum2;
        }
        return d;
    }

    @Override
    public Polynomial<Object> derivative(Ring<Object> ring, Eq<Object> eq) {
        return this.derivative$mcD$sp(ring, eq);
    }

    @Override
    public Polynomial<Object> derivative$mcD$sp(Ring<Object> ring, Eq<Object> eq) {
        int i0 = this.exp()[0] == 0 ? 1 : 0;
        int[] es = new int[this.exp().length - i0];
        double[] cs = (double[])this.ct().newArray(es.length);
        this.loop$9(i0, 0, ring, es, cs);
        return PolySparse$.MODULE$.safe$mDc$sp(es, cs, ring, eq, this.ct());
    }

    @Override
    public Polynomial<Object> integral(Field<Object> field, Eq<Object> eq) {
        return this.integral$mcD$sp(field, eq);
    }

    @Override
    public Polynomial<Object> integral$mcD$sp(Field<Object> field, Eq<Object> eq) {
        int[] es = new int[this.exp().length];
        double[] cs = (double[])this.ct().newArray(es.length);
        for (int index$macro$29 = 0; index$macro$29 < es.length; ++index$macro$29) {
            int e;
            es[index$macro$29] = e = this.exp()[index$macro$29] + 1;
            cs[index$macro$29] = field.div$mcD$sp(this.coeff()[index$macro$29], field.fromInt$mcD$sp(e));
        }
        return PolySparse$.MODULE$.safe$mDc$sp(es, cs, field, eq, this.ct());
    }

    @Override
    public Polynomial<Object> unary_$minus(Rng<Object> ring) {
        return this.unary_$minus$mcD$sp(ring);
    }

    @Override
    public Polynomial<Object> unary_$minus$mcD$sp(Rng<Object> ring) {
        double[] cs = (double[])this.ct().newArray(this.coeff().length);
        for (int index$macro$30 = 0; index$macro$30 < cs.length; ++index$macro$30) {
            cs[index$macro$30] = ring.negate$mcD$sp(this.coeff()[index$macro$30]);
        }
        return new PolySparse$mcD$sp(this.exp(), cs, this.ct());
    }

    @Override
    public Polynomial<Object> $plus(Polynomial<Object> rhs0, Semiring<Object> ring, Eq<Object> eq) {
        return this.$plus$mcD$sp(rhs0, ring, eq);
    }

    @Override
    public Polynomial<Object> $plus$mcD$sp(Polynomial<Object> rhs0, Semiring<Object> ring, Eq<Object> eq) {
        PolySparse<Object> rhs = PolySparse$.MODULE$.apply$mDc$sp(rhs0, ring, eq, this.ct());
        return PolySparse$.MODULE$.spire$math$poly$PolySparse$$addSparse(this, rhs, eq, ring, this.ct());
    }

    @Override
    public Polynomial<Object> $times(Polynomial<Object> rhs0, Semiring<Object> ring, Eq<Object> eq) {
        return this.$times$mcD$sp(rhs0, ring, eq);
    }

    @Override
    public Polynomial<Object> $times$mcD$sp(Polynomial<Object> rhs0, Semiring<Object> ring, Eq<Object> eq) {
        PolySparse<Object> rhs = PolySparse$.MODULE$.apply$mDc$sp(rhs0, ring, eq, this.ct());
        return PolySparse$.MODULE$.spire$math$poly$PolySparse$$multiplySparse(this, rhs, ring, eq, this.ct());
    }

    @Override
    public Tuple2<Polynomial<Object>, Polynomial<Object>> $div$percent(Polynomial<Object> rhs, Field<Object> field, Eq<Object> eq) {
        return this.$div$percent$mcD$sp(rhs, field, eq);
    }

    @Override
    public Tuple2<Polynomial<Object>, Polynomial<Object>> $div$percent$mcD$sp(Polynomial<Object> rhs, Field<Object> field, Eq<Object> eq) {
        boolean bl = !rhs.isZero();
        Predef$ predef$ = Predef$.MODULE$;
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"requirement failed: ").append((Object)"Can't divide by polynomial of zero!").toString());
        }
        return PolySparse$.MODULE$.spire$math$poly$PolySparse$$quotmodSparse(this, PolySparse$.MODULE$.apply$mDc$sp(rhs, field, eq, this.ct()), field, eq, this.ct());
    }

    @Override
    public Polynomial<Object> $times$colon(double k, Semiring<Object> ring, Eq<Object> eq) {
        return this.$times$colon$mcD$sp(k, ring, eq);
    }

    @Override
    public Polynomial<Object> $times$colon$mcD$sp(double k, Semiring<Object> ring, Eq<Object> eq) {
        PolySparse$mcD$sp polySparse$mcD$sp;
        if (eq.eqv$mcD$sp(k, ring.zero$mcD$sp())) {
            polySparse$mcD$sp = PolySparse$.MODULE$.zero$mDc$sp(ring, eq, this.ct());
        } else {
            double[] cs = (double[])this.ct().newArray(this.coeff().length);
            for (int index$macro$31 = 0; index$macro$31 < cs.length; ++index$macro$31) {
                cs[index$macro$31] = ring.times$mcD$sp(k, this.coeff()[index$macro$31]);
            }
            polySparse$mcD$sp = new PolySparse$mcD$sp(this.exp(), cs, this.ct());
        }
        return polySparse$mcD$sp;
    }

    public <C> double[] copy$default$2() {
        return this.copy$default$2$mcD$sp();
    }

    @Override
    public <C> double[] copy$default$2$mcD$sp() {
        return this.coeff();
    }

    @Override
    public boolean specInstance$() {
        return true;
    }

    private final void loop$9(int i, int j, Ring ring$2, int[] es$8, double[] cs$8) {
        while (j < es$8.length) {
            int e = this.exp()[i];
            es$8[j] = e - 1;
            cs$8[j] = BoxesRunTime.unboxToDouble((Object)LiteralIntMultiplicativeSemigroupOps$.MODULE$.$times$extension(implicits$.MODULE$.literalIntMultiplicativeSemigroupOps(e), BoxesRunTime.boxToDouble((double)this.coeff()[i]), ring$2));
            ++j;
            ++i;
        }
    }

    public PolySparse$mcD$sp(int[] exp, double[] coeff$mcD$sp, ClassTag<Object> ct) {
        this.coeff$mcD$sp = coeff$mcD$sp;
        super(exp, null, ct);
        Polynomial$mcD$sp$class.$init$(this);
    }
}

