/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.command;

import java.io.IOException;
import java.util.List;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.server.BaseCommand;
import org.subethamail.smtp.server.Session;
import org.subethamail.smtp.util.TextUtils;

public class EhloCommand
extends BaseCommand {
    public EhloCommand() {
        super("EHLO", "Introduce yourself.", "<hostname>");
    }

    public void execute(String commandString, Session sess) throws IOException {
        List<String> supportedMechanisms;
        AuthenticationHandlerFactory authFact;
        String[] args = this.getArgs(commandString);
        if (args.length < 2) {
            sess.sendResponse("501 Syntax: EHLO hostname");
            return;
        }
        sess.resetMessageState();
        sess.setHelo(args[1]);
        StringBuilder response = new StringBuilder();
        response.append("250-");
        response.append(sess.getServer().getHostName());
        response.append("\r\n250-8BITMIME");
        int maxSize = sess.getServer().getMaxMessageSize();
        if (maxSize > 0) {
            response.append("\r\n250-SIZE ");
            response.append(maxSize);
        }
        if (sess.getServer().getEnableTLS() && !sess.getServer().getHideTLS()) {
            response.append("\r\n250-STARTTLS");
        }
        if ((authFact = sess.getServer().getAuthenticationHandlerFactory()) != null && !(supportedMechanisms = authFact.getAuthenticationMechanisms()).isEmpty()) {
            response.append("\r\n250-AUTH ");
            response.append(TextUtils.joinTogether(supportedMechanisms, " "));
        }
        response.append("\r\n250 Ok");
        sess.sendResponse(response.toString());
    }
}

