/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.file;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.Cancelable;
import tachyon.client.ClientContext;
import tachyon.client.FileSystemMasterClient;
import tachyon.client.TachyonStorageType;
import tachyon.client.UnderStorageType;
import tachyon.client.block.BlockStoreContext;
import tachyon.client.block.BufferedBlockOutStream;
import tachyon.client.file.FileSystemContext;
import tachyon.client.file.options.OutStreamOptions;
import tachyon.exception.TachyonException;
import tachyon.thrift.FileInfo;
import tachyon.underfs.UnderFileSystem;
import tachyon.util.io.PathUtils;
import tachyon.worker.WorkerClient;

public class FileOutStream
extends OutputStream
implements Cancelable {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private static final String ERR_BLOCK_REMAINING = "The current block still has space left, no need to get new block.";
    private static final String ERR_BUFFER_NULL = "Cannot write a null input buffer.";
    private static final String ERR_BUFFER_STATE = "Buffer length: %s, offset: %s, len: %s";
    private final long mBlockSize;
    protected final TachyonStorageType mTachyonStorageType;
    private final UnderStorageType mUnderStorageType;
    private final FileSystemContext mContext;
    private final OutputStream mUnderStorageOutputStream;
    private final long mNonce;
    private String mUfsPath;
    protected boolean mCanceled;
    protected boolean mClosed;
    private String mHostname;
    private boolean mShouldCacheCurrentBlock;
    protected BufferedBlockOutStream mCurrentBlockOutStream;
    protected List<BufferedBlockOutStream> mPreviousBlockOutStreams;
    protected final long mFileId;

    public FileOutStream(long fileId, OutStreamOptions options) throws IOException {
        this.mFileId = fileId;
        this.mNonce = ClientContext.getRandomNonNegativeLong();
        this.mBlockSize = options.getBlockSizeBytes();
        this.mTachyonStorageType = options.getTachyonStorageType();
        this.mUnderStorageType = options.getUnderStorageType();
        this.mContext = FileSystemContext.INSTANCE;
        this.mPreviousBlockOutStreams = new LinkedList<BufferedBlockOutStream>();
        if (this.mUnderStorageType.isSyncPersist()) {
            FileInfo fileInfo = this.getFileInfo();
            this.mUfsPath = fileInfo.getUfsPath();
            String fileName = PathUtils.temporaryFileName(fileId, this.mNonce, this.mUfsPath);
            UnderFileSystem ufs = UnderFileSystem.get(fileName, ClientContext.getConf());
            this.mUnderStorageOutputStream = ufs.create(fileName, (int)this.mBlockSize);
        } else {
            this.mUfsPath = null;
            this.mUnderStorageOutputStream = null;
        }
        this.mClosed = false;
        this.mCanceled = false;
        this.mHostname = options.getHostname();
        this.mShouldCacheCurrentBlock = this.mTachyonStorageType.isStore();
    }

    @Override
    public void cancel() throws IOException {
        this.mCanceled = true;
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        if (this.mCurrentBlockOutStream != null) {
            this.mPreviousBlockOutStreams.add(this.mCurrentBlockOutStream);
        }
        Boolean canComplete = false;
        if (this.mUnderStorageType.isSyncPersist()) {
            if (this.mCanceled) {
                this.mUnderStorageOutputStream.close();
                String tmpPath = PathUtils.temporaryFileName(this.mFileId, this.mNonce, this.mUfsPath);
                UnderFileSystem ufs = UnderFileSystem.get(tmpPath, ClientContext.getConf());
                if (!ufs.exists(tmpPath)) {
                    FileInfo fileInfo = this.getFileInfo();
                    this.mUfsPath = fileInfo.getUfsPath();
                    tmpPath = PathUtils.temporaryFileName(this.mFileId, this.mNonce, this.mUfsPath);
                }
                ufs.delete(tmpPath, false);
            } else {
                this.mUnderStorageOutputStream.flush();
                this.mUnderStorageOutputStream.close();
                WorkerClient workerClient = BlockStoreContext.INSTANCE.acquireWorkerClient();
                try {
                    workerClient.persistFile(this.mFileId, this.mNonce, this.mUfsPath);
                }
                finally {
                    BlockStoreContext.INSTANCE.releaseWorkerClient(workerClient);
                }
                canComplete = true;
            }
        }
        if (this.mTachyonStorageType.isStore()) {
            try {
                if (this.mCanceled) {
                    for (BufferedBlockOutStream bos : this.mPreviousBlockOutStreams) {
                        bos.cancel();
                    }
                } else {
                    for (BufferedBlockOutStream bos : this.mPreviousBlockOutStreams) {
                        bos.close();
                    }
                    canComplete = true;
                }
            }
            catch (IOException ioe) {
                this.handleCacheWriteException(ioe);
            }
        }
        if (canComplete.booleanValue()) {
            FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
            try {
                masterClient.completeFile(this.mFileId);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            finally {
                this.mContext.releaseMasterClient(masterClient);
            }
        }
        this.mClosed = true;
    }

    @Override
    public void flush() throws IOException {
        if (this.mUnderStorageType.isSyncPersist()) {
            this.mUnderStorageOutputStream.flush();
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.mShouldCacheCurrentBlock) {
            try {
                if (this.mCurrentBlockOutStream == null || this.mCurrentBlockOutStream.remaining() == 0L) {
                    this.getNextBlock();
                }
                this.mCurrentBlockOutStream.write(b);
            }
            catch (IOException ioe) {
                this.handleCacheWriteException(ioe);
            }
        }
        if (this.mUnderStorageType.isSyncPersist()) {
            this.mUnderStorageOutputStream.write(b);
            ClientContext.getClientMetrics().incBytesWrittenUfs(1L);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Preconditions.checkArgument((b != null ? 1 : 0) != 0, (Object)ERR_BUFFER_NULL);
        Preconditions.checkArgument((off >= 0 && len >= 0 && len + off <= b.length ? 1 : 0) != 0, (String)ERR_BUFFER_STATE, (Object[])new Object[]{b.length, off, len});
        if (this.mShouldCacheCurrentBlock) {
            try {
                int tLen = len;
                int tOff = off;
                while (tLen > 0) {
                    long currentBlockLeftBytes;
                    if (this.mCurrentBlockOutStream == null || this.mCurrentBlockOutStream.remaining() == 0L) {
                        this.getNextBlock();
                    }
                    if ((currentBlockLeftBytes = this.mCurrentBlockOutStream.remaining()) >= (long)tLen) {
                        this.mCurrentBlockOutStream.write(b, tOff, tLen);
                        tLen = 0;
                        continue;
                    }
                    this.mCurrentBlockOutStream.write(b, tOff, (int)currentBlockLeftBytes);
                    tOff = (int)((long)tOff + currentBlockLeftBytes);
                    tLen = (int)((long)tLen - currentBlockLeftBytes);
                }
            }
            catch (IOException ioe) {
                this.handleCacheWriteException(ioe);
            }
        }
        if (this.mUnderStorageType.isSyncPersist()) {
            this.mUnderStorageOutputStream.write(b, off, len);
            ClientContext.getClientMetrics().incBytesWrittenUfs(len);
        }
    }

    private void getNextBlock() throws IOException {
        if (this.mCurrentBlockOutStream != null) {
            Preconditions.checkState((this.mCurrentBlockOutStream.remaining() <= 0L ? 1 : 0) != 0, (Object)ERR_BLOCK_REMAINING);
            this.mPreviousBlockOutStreams.add(this.mCurrentBlockOutStream);
        }
        if (this.mTachyonStorageType.isStore()) {
            this.mCurrentBlockOutStream = this.mContext.getTachyonBlockStore().getOutStream(this.getNextBlockId(), this.mBlockSize, this.mHostname);
            this.mShouldCacheCurrentBlock = true;
        }
    }

    private long getNextBlockId() throws IOException {
        FileSystemMasterClient masterClient = this.mContext.acquireMasterClient();
        try {
            long l = masterClient.getNewBlockIdForFile(this.mFileId);
            return l;
        }
        catch (TachyonException e) {
            throw new IOException(e);
        }
        finally {
            this.mContext.releaseMasterClient(masterClient);
        }
    }

    protected void handleCacheWriteException(IOException ioe) throws IOException {
        if (!this.mUnderStorageType.isSyncPersist()) {
            throw new IOException("Fail to cache: " + ioe.getMessage(), ioe);
        }
        LOG.warn("Failed to write into TachyonStore, canceling write attempt.", (Throwable)ioe);
        if (this.mCurrentBlockOutStream != null) {
            this.mShouldCacheCurrentBlock = false;
            this.mCurrentBlockOutStream.cancel();
        }
    }

    private FileInfo getFileInfo() throws IOException {
        FileSystemMasterClient client = this.mContext.acquireMasterClient();
        try {
            FileInfo fileInfo = client.getFileInfo(this.mFileId);
            return fileInfo;
        }
        catch (TachyonException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            this.mContext.releaseMasterClient(client);
        }
    }
}

