/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.file.options;

import tachyon.client.ClientContext;
import tachyon.client.TachyonStorageType;
import tachyon.client.UnderStorageType;
import tachyon.client.WriteType;
import tachyon.conf.TachyonConf;

public final class OutStreamOptions {
    private final long mBlockSizeBytes;
    private final String mHostname;
    private final TachyonStorageType mTachyonStorageType;
    private final UnderStorageType mUnderStorageType;
    private final long mTTL;

    public static OutStreamOptions defaults() {
        return new Builder(ClientContext.getConf()).build();
    }

    private OutStreamOptions(Builder builder) {
        this.mBlockSizeBytes = builder.mBlockSizeBytes;
        this.mHostname = builder.mHostname;
        this.mTachyonStorageType = builder.mTachyonStorageType;
        this.mTTL = builder.mTTL;
        this.mUnderStorageType = builder.mUnderStorageType;
    }

    public long getBlockSizeBytes() {
        return this.mBlockSizeBytes;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public TachyonStorageType getTachyonStorageType() {
        return this.mTachyonStorageType;
    }

    public long getTTL() {
        return this.mTTL;
    }

    public UnderStorageType getUnderStorageType() {
        return this.mUnderStorageType;
    }

    public static class Builder {
        private long mBlockSizeBytes;
        private String mHostname;
        private TachyonStorageType mTachyonStorageType;
        private long mTTL;
        private UnderStorageType mUnderStorageType;

        public Builder(TachyonConf conf) {
            this.mBlockSizeBytes = conf.getBytes("tachyon.user.block.size.bytes.default");
            this.mHostname = null;
            WriteType defaultWriteType = conf.getEnum("tachyon.user.file.writetype.default", WriteType.class);
            this.mTachyonStorageType = defaultWriteType.getTachyonStorageType();
            this.mUnderStorageType = defaultWriteType.getUnderStorageType();
            this.mTTL = -1L;
        }

        public Builder setBlockSizeBytes(long blockSizeBytes) {
            this.mBlockSizeBytes = blockSizeBytes;
            return this;
        }

        public Builder setHostname(String hostname) {
            this.mHostname = hostname;
            return this;
        }

        public Builder setTachyonStorageType(TachyonStorageType tachyonStorageType) {
            this.mTachyonStorageType = tachyonStorageType;
            return this;
        }

        public Builder setUnderStorageType(UnderStorageType underStorageType) {
            this.mUnderStorageType = underStorageType;
            return this;
        }

        public Builder setTTL(long ttl) {
            this.mTTL = ttl;
            return this;
        }

        public Builder setWriteType(WriteType writeType) {
            this.mTachyonStorageType = writeType.getTachyonStorageType();
            this.mUnderStorageType = writeType.getUnderStorageType();
            return this;
        }

        public OutStreamOptions build() {
            return new OutStreamOptions(this);
        }
    }
}

