/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.lineage;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.ClientContext;
import tachyon.client.UnderStorageType;
import tachyon.client.block.BufferedBlockOutStream;
import tachyon.client.file.FileOutStream;
import tachyon.client.file.options.OutStreamOptions;
import tachyon.client.lineage.LineageContext;
import tachyon.client.lineage.LineageMasterClient;

public class LineageFileOutStream
extends FileOutStream {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private LineageContext mContext = LineageContext.INSTANCE;

    public LineageFileOutStream(long fileId, OutStreamOptions options) throws IOException {
        super(fileId, LineageFileOutStream.updateOutStreamOptions(options));
    }

    private static OutStreamOptions updateOutStreamOptions(OutStreamOptions options) {
        OutStreamOptions.Builder builder = new OutStreamOptions.Builder(ClientContext.getConf());
        builder.setBlockSizeBytes(options.getBlockSizeBytes());
        builder.setHostname(options.getHostname());
        builder.setTachyonStorageType(options.getTachyonStorageType());
        builder.setTTL(options.getTTL());
        builder.setUnderStorageType(UnderStorageType.ASYNC_PERSIST);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        if (this.mCurrentBlockOutStream != null) {
            this.mPreviousBlockOutStreams.add(this.mCurrentBlockOutStream);
        }
        boolean canComplete = false;
        if (this.mTachyonStorageType.isStore()) {
            try {
                if (this.mCanceled) {
                    for (BufferedBlockOutStream bos : this.mPreviousBlockOutStreams) {
                        bos.cancel();
                    }
                } else {
                    for (BufferedBlockOutStream bos : this.mPreviousBlockOutStreams) {
                        bos.close();
                    }
                    canComplete = true;
                }
            }
            catch (IOException ioe) {
                this.handleCacheWriteException(ioe);
            }
        }
        if (canComplete) {
            LineageMasterClient masterClient = this.mContext.acquireMasterClient();
            try {
                LOG.info("async complete file" + this.mFileId);
                masterClient.asyncCompleteFile(this.mFileId);
            }
            finally {
                this.mContext.releaseMasterClient(masterClient);
            }
        } else {
            LOG.warn("Failed to store file " + this.mFileId + " in Tachyon Storage");
        }
    }
}

