/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.table;

import java.io.IOException;
import tachyon.TachyonURI;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.table.RawTable;
import tachyon.util.io.PathUtils;

public class RawColumn {
    private final TachyonFS mTachyonFS;
    private final RawTable mRawTable;
    private final int mColumnIndex;

    RawColumn(TachyonFS tachyonClient, RawTable rawTable, int columnIndex) {
        this.mTachyonFS = tachyonClient;
        this.mRawTable = rawTable;
        this.mColumnIndex = columnIndex;
    }

    public static String getColumnPath(String tablePath, int columnIndex) {
        return PathUtils.concatPath(tablePath, "COL_" + columnIndex);
    }

    public boolean createPartition(int pId) throws IOException {
        TachyonURI tUri = new TachyonURI(PathUtils.concatPath(RawColumn.getColumnPath(this.mRawTable.getPath(), this.mColumnIndex), pId));
        return this.mTachyonFS.createFile(tUri) > 0L;
    }

    public TachyonFile getPartition(int pId) throws IOException {
        return this.getPartition(pId, false);
    }

    public TachyonFile getPartition(int pId, boolean cachedMetadata) throws IOException {
        TachyonURI tUri = new TachyonURI(PathUtils.concatPath(this.mRawTable.getPath(), "COL_" + this.mColumnIndex, pId));
        return this.mTachyonFS.getFile(tUri, cachedMetadata);
    }

    public int partitions() throws IOException {
        TachyonURI tUri = new TachyonURI(PathUtils.concatPath(this.mRawTable.getPath(), "COL_" + this.mColumnIndex));
        return this.mTachyonFS.listStatus(tUri).size();
    }
}

