/*
 * Decompiled with CFR 0.152.
 */
package tachyon.org.jets3t.service.impl.rest.httpclient;

import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import tachyon.org.jets3t.service.Constants;
import tachyon.org.jets3t.service.Jets3tProperties;
import tachyon.org.jets3t.service.ServiceException;
import tachyon.org.jets3t.service.acl.gs.GSAccessControlList;
import tachyon.org.jets3t.service.impl.rest.httpclient.RestStorageService;
import tachyon.org.jets3t.service.model.GSBucket;
import tachyon.org.jets3t.service.model.GSObject;
import tachyon.org.jets3t.service.security.ProviderCredentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GoogleStorageService
extends RestStorageService {
    private static final String GOOGLE_SIGNATURE_IDENTIFIER = "GOOG1";
    private static final String GOOGLE_REST_HEADER_PREFIX = "x-goog-";
    private static final String GOOGLE_REST_METADATA_PREFIX = "x-goog-meta-";

    public GoogleStorageService(ProviderCredentials credentials) throws ServiceException {
        this(credentials, (String)null, (CredentialsProvider)null);
    }

    public GoogleStorageService(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider) throws ServiceException {
        this(credentials, invokingApplicationDescription, credentialsProvider, Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME));
    }

    public GoogleStorageService(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties) throws ServiceException {
        this(credentials, invokingApplicationDescription, credentialsProvider, jets3tProperties, new HostConfiguration());
    }

    public GoogleStorageService(ProviderCredentials credentials, String invokingApplicationDescription, CredentialsProvider credentialsProvider, Jets3tProperties jets3tProperties, HostConfiguration hostConfig) throws ServiceException {
        super(credentials, invokingApplicationDescription, credentialsProvider, jets3tProperties, hostConfig);
    }

    @Override
    protected boolean isTargettingGoogleStorageService() {
        return true;
    }

    @Override
    public String getEndpoint() {
        return this.jets3tProperties.getStringProperty("gsservice.gs-endpoint", Constants.GS_DEFAULT_HOSTNAME);
    }

    @Override
    protected String getVirtualPath() {
        return this.jets3tProperties.getStringProperty("gsservice.gs-endpoint-virtual-path", "");
    }

    @Override
    protected String getSignatureIdentifier() {
        return GOOGLE_SIGNATURE_IDENTIFIER;
    }

    @Override
    public String getRestHeaderPrefix() {
        return GOOGLE_REST_HEADER_PREFIX;
    }

    @Override
    public String getRestMetadataPrefix() {
        return GOOGLE_REST_METADATA_PREFIX;
    }

    @Override
    public List<String> getResourceParameterNames() {
        return Arrays.asList("acl");
    }

    @Override
    protected int getHttpPort() {
        return this.jets3tProperties.getIntProperty("gsservice.gs-endpoint-http-port", 80);
    }

    @Override
    protected int getHttpsPort() {
        return this.jets3tProperties.getIntProperty("gsservice.gs-endpoint-https-port", 443);
    }

    @Override
    protected boolean getHttpsOnly() {
        return this.jets3tProperties.getBoolProperty("gsservice.https-only", true);
    }

    @Override
    protected boolean getDisableDnsBuckets() {
        return this.jets3tProperties.getBoolProperty("gsservice.disable-dns-buckets", false);
    }

    @Override
    protected boolean getEnableStorageClasses() {
        return false;
    }

    public GSBucket[] listAllBuckets() throws ServiceException {
        return GSBucket.cast(super.listAllBuckets());
    }

    public GSObject[] listObjects(String bucketName) throws ServiceException {
        return GSObject.cast(super.listObjects(bucketName));
    }

    public GSObject[] listObjects(String bucketName, String prefix, String delimiter) throws ServiceException {
        return GSObject.cast(super.listObjects(bucketName, prefix, delimiter));
    }

    @Override
    public GSBucket createBucket(String bucketName) throws ServiceException {
        return (GSBucket)super.createBucket(bucketName);
    }

    @Override
    public GSAccessControlList getBucketAcl(String bucketName) throws ServiceException {
        return (GSAccessControlList)super.getBucketAcl(bucketName);
    }

    public void putBucketAcl(String bucketName, GSAccessControlList acl) throws ServiceException {
        if (acl == null) {
            throw new ServiceException("The bucket '" + bucketName + "' does not include ACL information");
        }
        this.putBucketAclImpl(bucketName, acl);
    }

    public void putBucketAcl(GSBucket bucket) throws ServiceException {
        this.assertValidBucket(bucket, "Put Bucket Access Control List");
        this.putBucketAcl(bucket.getName(), bucket.getAcl());
    }

    @Override
    public GSObject getObject(String bucketName, String objectKey) throws ServiceException {
        return (GSObject)super.getObject(bucketName, objectKey);
    }

    public GSObject putObject(String bucketName, GSObject object) throws ServiceException {
        return (GSObject)super.putObject(bucketName, object);
    }

    @Override
    public GSObject getObject(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws ServiceException {
        return (GSObject)super.getObject(bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd);
    }

    @Override
    public GSObject getObjectDetails(String bucketName, String objectKey) throws ServiceException {
        return (GSObject)super.getObjectDetails(bucketName, objectKey);
    }
}

