/*
 * Decompiled with CFR 0.152.
 */
package tachyon.org.jets3t.service.model;

import com.jamesmurty.utils.XMLBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import tachyon.org.jets3t.service.S3ServiceException;
import tachyon.org.jets3t.service.acl.GrantAndPermission;

public class S3BucketLoggingStatus {
    private String targetBucketName = null;
    private String logfilePrefix = null;
    private final List<GrantAndPermission> targetGrantsList = new ArrayList<GrantAndPermission>();

    public S3BucketLoggingStatus() {
    }

    public S3BucketLoggingStatus(String targetBucketName, String logfilePrefix) {
        this.targetBucketName = targetBucketName;
        this.logfilePrefix = logfilePrefix;
    }

    public boolean isLoggingEnabled() {
        return this.targetBucketName != null && this.logfilePrefix != null;
    }

    public String getLogfilePrefix() {
        return this.logfilePrefix;
    }

    public void setLogfilePrefix(String logfilePrefix) {
        this.logfilePrefix = logfilePrefix;
    }

    public String getTargetBucketName() {
        return this.targetBucketName;
    }

    public void setTargetBucketName(String targetBucketName) {
        this.targetBucketName = targetBucketName;
    }

    public GrantAndPermission[] getTargetGrants() {
        return this.targetGrantsList.toArray(new GrantAndPermission[this.targetGrantsList.size()]);
    }

    public void setTargetGrants(GrantAndPermission[] targetGrants) {
        this.targetGrantsList.clear();
        this.targetGrantsList.addAll(Arrays.asList(targetGrants));
    }

    public void addTargetGrant(GrantAndPermission targetGrant) {
        this.targetGrantsList.add(targetGrant);
    }

    public String toString() {
        String result = "LoggingStatus enabled=" + this.isLoggingEnabled();
        if (this.isLoggingEnabled()) {
            result = result + ", targetBucketName=" + this.getTargetBucketName() + ", logfilePrefix=" + this.getLogfilePrefix();
        }
        result = result + ", targetGrants=[" + this.targetGrantsList + "]";
        return result;
    }

    public String toXml() throws S3ServiceException {
        try {
            return this.toXMLBuilder().asString();
        }
        catch (Exception e) {
            throw new S3ServiceException("Failed to build XML document for ACL", e);
        }
    }

    public XMLBuilder toXMLBuilder() throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        XMLBuilder builder = XMLBuilder.create((String)"BucketLoggingStatus").attr("xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
        if (this.isLoggingEnabled()) {
            XMLBuilder enabledBuilder = builder.elem("LoggingEnabled").elem("TargetBucket").text(this.getTargetBucketName()).up().elem("TargetPrefix").text(this.getLogfilePrefix()).up();
            if (this.targetGrantsList.size() > 0) {
                Iterator<GrantAndPermission> targetGrantsIter = this.targetGrantsList.iterator();
                XMLBuilder grantsBuilder = enabledBuilder.elem("TargetGrants");
                while (targetGrantsIter.hasNext()) {
                    GrantAndPermission gap = targetGrantsIter.next();
                    grantsBuilder.elem("Grant").importXMLBuilder(gap.getGrantee().toXMLBuilder()).elem("Permission").text(gap.getPermission().toString());
                }
            }
        }
        return builder;
    }
}

