/*
 * Decompiled with CFR 0.152.
 */
package tachyon.org.jets3t.service.model.cloudfront;

import tachyon.org.jets3t.service.model.cloudfront.Origin;

public class S3Origin
extends Origin {
    public static final String ORIGIN_ACCESS_IDENTITY_PREFIX = "origin-access-identity/cloudfront/";
    private String originAccessIdentity = null;

    public S3Origin(String dnsName, String originAccessIdentity) {
        super(dnsName);
        this.originAccessIdentity = originAccessIdentity != null && !originAccessIdentity.startsWith(ORIGIN_ACCESS_IDENTITY_PREFIX) ? ORIGIN_ACCESS_IDENTITY_PREFIX + originAccessIdentity : originAccessIdentity;
    }

    public S3Origin(String dnsName) {
        this(dnsName, null);
    }

    public String getOriginAccessIdentity() {
        return this.originAccessIdentity;
    }

    public String getOriginAsBucketName() {
        String bucketName = this.getDnsName();
        if (bucketName.endsWith(".s3.amazonaws.com")) {
            return bucketName.substring(0, bucketName.length() - ".s3.amazonaws.com".length());
        }
        return bucketName;
    }

    public String toString() {
        return "S3Origin: dnsName=" + this.getDnsName() + (this.getOriginAccessIdentity() != null ? ", originAccessIdentity=" + this.getOriginAccessIdentity() : "");
    }
}

