/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client.table;

import java.io.IOException;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.table.RawTable;

public class RawColumn {
    private final TachyonFS TFS;
    private final RawTable RAW_TABLE;
    private final int COLUMN_INDEX;

    RawColumn(TachyonFS tachyonClient, RawTable rawTable, int columnIndex) {
        this.TFS = tachyonClient;
        this.RAW_TABLE = rawTable;
        this.COLUMN_INDEX = columnIndex;
    }

    public boolean createPartition(int pId) throws IOException {
        return this.TFS.createFile(this.RAW_TABLE.getPath() + "/" + "COL_" + this.COLUMN_INDEX + "/" + pId) > 0;
    }

    public TachyonFile getPartition(int pId) throws IOException {
        return this.getPartition(pId, false);
    }

    public TachyonFile getPartition(int pId, boolean cachedMetadata) throws IOException {
        return this.TFS.getFile(this.RAW_TABLE.getPath() + "/" + "COL_" + this.COLUMN_INDEX + "/" + pId, cachedMetadata);
    }

    public int partitions() throws IOException {
        return this.TFS.getNumberOfFiles(this.RAW_TABLE.getPath() + "/" + "COL_" + this.COLUMN_INDEX);
    }
}

