/*
 * Decompiled with CFR 0.152.
 */
package tachyon.examples;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.Version;
import tachyon.client.OutStream;
import tachyon.client.TachyonByteBuffer;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.examples.Utils;
import tachyon.util.CommonUtils;

public class BasicOperations {
    private static Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private static TachyonFS sTachyonClient;
    private static String sFilePath;
    private static WriteType sWriteType;
    private static int sNumbers;
    private static boolean sPass;

    public static void createFile() throws IOException {
        long startTimeMs = CommonUtils.getCurrentMs();
        int fileId = sTachyonClient.createFile(sFilePath);
        CommonUtils.printTimeTakenMs(startTimeMs, LOG, "createFile with fileId " + fileId);
    }

    public static void writeFile() throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(sNumbers * 4);
        buf.order(ByteOrder.nativeOrder());
        for (int k = 0; k < sNumbers; ++k) {
            buf.putInt(k);
        }
        buf.flip();
        LOG.debug((Object)"Writing data...");
        buf.flip();
        TachyonFile file = sTachyonClient.getFile(sFilePath);
        OutStream os = file.getOutStream(sWriteType);
        os.write(buf.array());
        os.close();
    }

    public static void readFile() throws IOException {
        LOG.debug((Object)"Reading data...");
        TachyonFile file = sTachyonClient.getFile(sFilePath);
        TachyonByteBuffer buf = file.readByteBuffer();
        if (buf == null) {
            file.recache();
            buf = file.readByteBuffer();
        }
        buf.DATA.order(ByteOrder.nativeOrder());
        for (int k = 0; k < sNumbers; ++k) {
            sPass = sPass && buf.DATA.getInt() == k;
        }
        buf.close();
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.out.println("java -cp target/tachyon-" + Version.VERSION + "-jar-with-dependencies.jar " + "tachyon.examples.BasicOperations <TachyonMasterAddress> <FilePath> <WriteType>");
            System.exit(-1);
        }
        sTachyonClient = TachyonFS.get(args[0]);
        sFilePath = args[1];
        sWriteType = WriteType.getOpType(args[2]);
        BasicOperations.createFile();
        BasicOperations.writeFile();
        BasicOperations.readFile();
        Utils.printPassInfo(sPass);
        System.exit(0);
    }

    static {
        sFilePath = null;
        sWriteType = null;
        sNumbers = 20;
        sPass = true;
    }
}

