/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.Pair;
import tachyon.UnderFileSystem;
import tachyon.io.Utils;
import tachyon.master.DependencyType;
import tachyon.master.MasterInfo;
import tachyon.thrift.BlockInfoException;
import tachyon.thrift.FileAlreadyExistException;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.InvalidPathException;
import tachyon.thrift.SuspectedFileSizeException;
import tachyon.thrift.TableDoesNotExistException;
import tachyon.thrift.TachyonException;
import tachyon.util.CommonUtils;

public class EditLog {
    static final byte OP_INVALID = -1;
    static final byte OP_ADD_CHECKPOINT = 0;
    static final byte OP_ADD_BLOCK = 1;
    static final byte OP_CREATE_FILE = 2;
    static final byte OP_DELETE = 3;
    static final byte OP_RENAME = 4;
    static final byte OP_UNPIN_FILE = 5;
    static final byte OP_UPDATE_RAW_TABLE_METADATA = 6;
    static final byte OP_COMPLETE_FILE = 7;
    static final byte OP_CREATE_DEPENDENCY = 8;
    private static final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private final boolean INACTIVE;
    private final String PATH;
    private static int mBackUpLogStartNum = -1;
    private static long mCurrentTId = 0L;
    private UnderFileSystem UFS;
    private DataOutputStream DOS;
    private OutputStream OS;
    private long mFlushedTransactionId = 0L;
    private long mTransactionId = 0L;
    private int mCurrentLogFileNum = 0;
    private int mMaxLogSize = 0x100000;

    public static long load(MasterInfo info, String path, int currentLogFileNum) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(path);
        if (!ufs.exists(path)) {
            LOG.info((Object)("Edit Log " + path + " does not exist."));
            return 0L;
        }
        LOG.info((Object)("currentLogNum passed in was " + currentLogFileNum));
        int completedLogs = currentLogFileNum;
        mBackUpLogStartNum = currentLogFileNum;
        int numFiles = 1;
        String completedPath = path.substring(0, path.lastIndexOf("/")) + "/completed";
        if (!ufs.exists(completedPath)) {
            LOG.info((Object)"No completed edit logs to be parsed");
        } else {
            while (ufs.exists(completedPath + "/" + completedLogs++ + ".editLog")) {
                ++numFiles;
            }
        }
        String[] editLogs = new String[numFiles];
        for (int i = 0; i < numFiles; ++i) {
            editLogs[i] = i != numFiles - 1 ? completedPath + "/" + (i + currentLogFileNum) + ".editLog" : path;
        }
        for (String currentPath : editLogs) {
            LOG.info((Object)("Loading Edit Log " + currentPath));
            EditLog.loadSingleLog(info, currentPath);
        }
        ufs.close();
        return mCurrentTId;
    }

    public static void loadSingleLog(MasterInfo info, String path) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(path);
        DataInputStream is = new DataInputStream(ufs.open(path));
        while (true) {
            long tId;
            try {
                tId = is.readLong();
            }
            catch (EOFException e) {
                break;
            }
            mCurrentTId = tId;
            byte op = is.readByte();
            try {
                switch (op) {
                    case 0: {
                        info.addCheckpoint(-1L, is.readInt(), is.readLong(), Utils.readString(is));
                        break;
                    }
                    case 1: {
                        info.opAddBlock(is.readInt(), is.readInt(), is.readLong());
                        break;
                    }
                    case 2: {
                        info._createFile(is.readBoolean(), Utils.readString(is), is.readBoolean(), is.readInt(), Utils.readByteBuffer(is), is.readLong(), is.readLong());
                        break;
                    }
                    case 3: {
                        info.delete(is.readInt(), is.readBoolean());
                        break;
                    }
                    case 4: {
                        info.rename(is.readInt(), Utils.readString(is));
                        break;
                    }
                    case 5: {
                        info.unpinFile(is.readInt());
                        break;
                    }
                    case 6: {
                        info.updateRawTableMetadata(is.readInt(), Utils.readByteBuffer(is));
                        break;
                    }
                    case 7: {
                        info.completeFile(is.readInt());
                        break;
                    }
                    case 8: {
                        info._createDependency(Utils.readIntegerList(is), Utils.readIntegerList(is), Utils.readString(is), Utils.readByteBufferList(is), Utils.readString(is), Utils.readString(is), Utils.readString(is), DependencyType.getDependencyType(is.readInt()), is.readInt(), is.readLong());
                        break;
                    }
                    default: {
                        throw new IOException("Invalid op type " + op);
                    }
                }
            }
            catch (SuspectedFileSizeException e) {
                throw new IOException(e);
            }
            catch (BlockInfoException e) {
                throw new IOException(e);
            }
            catch (FileDoesNotExistException e) {
                throw new IOException(e);
            }
            catch (FileAlreadyExistException e) {
                throw new IOException(e);
            }
            catch (InvalidPathException e) {
                throw new IOException(e);
            }
            catch (TachyonException e) {
                throw new IOException(e);
            }
            catch (TableDoesNotExistException e) {
                throw new IOException(e);
            }
        }
        is.close();
        ufs.close();
    }

    public EditLog(String path, boolean inactive, long transactionId) throws IOException {
        this.INACTIVE = inactive;
        if (!this.INACTIVE) {
            LOG.info((Object)("Creating edit log file " + path));
            this.PATH = path;
            this.UFS = UnderFileSystem.get(path);
            if (mBackUpLogStartNum != -1) {
                String folder = path.substring(0, path.lastIndexOf("/")) + "/completed";
                LOG.info((Object)"Deleting completed editlogs that are part of the image.");
                EditLog.deleteCompletedLogs(path, mBackUpLogStartNum);
                LOG.info((Object)("Backing up logs from " + mBackUpLogStartNum + " since image is not updated."));
                this.UFS.mkdirs(folder, true);
                String toRename = folder + "/" + mBackUpLogStartNum + ".editLog";
                int mCurrentLogFileNum = 0;
                while (this.UFS.exists(toRename)) {
                    LOG.info((Object)("Rename " + toRename + " to " + folder + "/" + mCurrentLogFileNum + ".editLog"));
                    ++mCurrentLogFileNum;
                    toRename = folder + "/" + ++mBackUpLogStartNum + ".editLog";
                }
                if (this.UFS.exists(path)) {
                    this.UFS.rename(path, folder + "/" + mCurrentLogFileNum + ".editLog");
                    LOG.info((Object)("Rename " + path + " to " + folder + "/" + mCurrentLogFileNum + ".editLog"));
                    ++mCurrentLogFileNum;
                }
                mBackUpLogStartNum = -1;
            }
            this.OS = this.UFS.create(path);
            this.DOS = new DataOutputStream(this.OS);
            LOG.info((Object)("Created file " + path));
            this.mFlushedTransactionId = transactionId;
            this.mTransactionId = transactionId;
        } else {
            this.PATH = null;
            this.UFS = null;
            this.OS = null;
            this.DOS = null;
        }
    }

    public static void deleteCompletedLogs(String path, int upTo) {
        UnderFileSystem ufs = UnderFileSystem.get(path);
        String folder = path.substring(0, path.lastIndexOf("/")) + "/completed";
        try {
            for (int i = 0; i < upTo; ++i) {
                String toDelete = folder + "/" + i + ".editLog";
                LOG.info((Object)("Deleting editlog " + toDelete));
                ufs.delete(toDelete, true);
            }
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public static void markUpToDate(String path) {
        UnderFileSystem ufs = UnderFileSystem.get(path);
        String folder = path.substring(0, path.lastIndexOf("/")) + "/completed";
        try {
            String toDelete = folder + "/" + mBackUpLogStartNum + ".editLog";
            while (ufs.exists(toDelete)) {
                LOG.info((Object)("Deleting editlog " + toDelete));
                ufs.delete(toDelete, true);
                toDelete = folder + "/" + ++mBackUpLogStartNum + ".editLog";
            }
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
        mBackUpLogStartNum = -1;
    }

    public void rotateEditLog(String path) {
        if (this.INACTIVE) {
            return;
        }
        this._close();
        LOG.info((Object)"Edit log max size reached, rotating edit log");
        String pathPrefix = path.substring(0, path.lastIndexOf("/")) + "/completed";
        LOG.info((Object)("path: " + path + " prefix: " + pathPrefix));
        try {
            if (!this.UFS.exists(pathPrefix)) {
                this.UFS.mkdirs(pathPrefix, true);
            }
            String newPath = pathPrefix + "/" + this.mCurrentLogFileNum++ + ".editLog";
            this.UFS.rename(path, newPath);
            LOG.info((Object)("Renamed " + path + " to " + newPath));
            this.OS = this.UFS.create(path);
            this.DOS = new DataOutputStream(this.OS);
            LOG.info((Object)("Created new log file " + path));
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public synchronized void addCheckpoint(int fileId, long length, String checkpointPath) {
        if (this.INACTIVE) {
            return;
        }
        try {
            this.DOS.writeLong(++this.mTransactionId);
            this.DOS.writeByte(0);
            this.DOS.writeInt(fileId);
            this.DOS.writeLong(length);
            Utils.writeString(checkpointPath, this.DOS);
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public synchronized void addBlock(int fileId, int blockIndex, long blockLength) {
        if (this.INACTIVE) {
            return;
        }
        try {
            this.DOS.writeLong(++this.mTransactionId);
            this.DOS.writeByte(1);
            this.DOS.writeInt(fileId);
            this.DOS.writeInt(blockIndex);
            this.DOS.writeLong(blockLength);
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public synchronized void createFile(boolean recursive, String path, boolean directory, int columns, ByteBuffer metadata, long blockSizeByte, long creationTimeMs) {
        if (this.INACTIVE) {
            return;
        }
        try {
            this.DOS.writeLong(++this.mTransactionId);
            this.DOS.writeByte(2);
            this.DOS.writeBoolean(recursive);
            Utils.writeString(path, this.DOS);
            this.DOS.writeBoolean(directory);
            this.DOS.writeInt(columns);
            Utils.writeByteBuffer(metadata, this.DOS);
            this.DOS.writeLong(blockSizeByte);
            this.DOS.writeLong(creationTimeMs);
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public synchronized void createDependency(List<Integer> parents, List<Integer> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, DependencyType dependencyType, int depId, long creationTimeMs) {
        if (this.INACTIVE) {
            return;
        }
        try {
            this.DOS.writeLong(++this.mTransactionId);
            this.DOS.writeByte(8);
            Utils.writeIntegerList(parents, this.DOS);
            Utils.writeIntegerList(children, this.DOS);
            Utils.writeString(commandPrefix, this.DOS);
            Utils.writeByteBufferList(data, this.DOS);
            Utils.writeString(comment, this.DOS);
            Utils.writeString(framework, this.DOS);
            Utils.writeString(frameworkVersion, this.DOS);
            this.DOS.writeInt(dependencyType.getValue());
            this.DOS.writeInt(depId);
            this.DOS.writeLong(creationTimeMs);
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public synchronized void delete(int fileId, boolean recursive) {
        if (this.INACTIVE) {
            return;
        }
        try {
            this.DOS.writeLong(++this.mTransactionId);
            this.DOS.writeByte(3);
            this.DOS.writeInt(fileId);
            this.DOS.writeBoolean(recursive);
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public synchronized void rename(int fileId, String dstPath) {
        if (this.INACTIVE) {
            return;
        }
        try {
            this.DOS.writeLong(++this.mTransactionId);
            this.DOS.writeByte(4);
            this.DOS.writeInt(fileId);
            Utils.writeString(dstPath, this.DOS);
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public synchronized void unpinFile(int fileId) {
        if (this.INACTIVE) {
            return;
        }
        try {
            this.DOS.writeLong(++this.mTransactionId);
            this.DOS.writeByte(5);
            this.DOS.writeInt(fileId);
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public synchronized void updateRawTableMetadata(int tableId, ByteBuffer metadata) {
        if (this.INACTIVE) {
            return;
        }
        try {
            this.DOS.writeLong(++this.mTransactionId);
            this.DOS.writeByte(6);
            this.DOS.writeInt(tableId);
            Utils.writeByteBuffer(metadata, this.DOS);
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public synchronized void completeFile(int fileId) {
        if (this.INACTIVE) {
            return;
        }
        try {
            this.DOS.writeLong(++this.mTransactionId);
            this.DOS.writeByte(7);
            this.DOS.writeInt(fileId);
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public synchronized Pair<Long, Long> getTransactionIds() {
        return new Pair<Long, Long>(this.mTransactionId, this.mFlushedTransactionId);
    }

    public synchronized void flush() {
        if (this.INACTIVE) {
            return;
        }
        try {
            this.DOS.flush();
            if (this.OS instanceof FSDataOutputStream) {
                ((FSDataOutputStream)this.OS).sync();
            }
            if (this.DOS.size() > this.mMaxLogSize) {
                this.rotateEditLog(this.PATH);
            }
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
        this.mFlushedTransactionId = this.mTransactionId;
    }

    private synchronized void _close() {
        try {
            if (this.DOS != null) {
                this.DOS.close();
            }
            if (this.OS != null) {
                this.OS.close();
            }
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public synchronized void close() {
        if (this.INACTIVE) {
            return;
        }
        try {
            this._close();
            this.UFS.close();
        }
        catch (IOException e) {
            CommonUtils.runtimeException(e);
        }
    }

    public void setMaxLogSize(int size) {
        this.mMaxLogSize = size;
    }
}

