/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import tachyon.master.InodeType;
import tachyon.thrift.ClientFileInfo;

public abstract class Inode
implements Comparable<Inode> {
    private final long CREATION_TIME_MS;
    protected final InodeType TYPE;
    private int mId;
    private String mName;
    private int mParentId;

    protected Inode(String name, int id, int parentId, InodeType type, long creationTimeMs) {
        this.TYPE = type;
        this.mId = id;
        this.mName = name;
        this.mParentId = parentId;
        this.CREATION_TIME_MS = creationTimeMs;
    }

    @Override
    public synchronized int compareTo(Inode o) {
        return this.mId - o.mId;
    }

    public synchronized boolean equals(Object o) {
        if (!(o instanceof Inode)) {
            return false;
        }
        return this.mId == ((Inode)o).mId;
    }

    public synchronized int hashCode() {
        return this.mId;
    }

    public boolean isDirectory() {
        return this.TYPE != InodeType.File;
    }

    public boolean isFile() {
        return this.TYPE == InodeType.File;
    }

    public long getCreationTimeMs() {
        return this.CREATION_TIME_MS;
    }

    public InodeType getInodeType() {
        return this.TYPE;
    }

    public synchronized int getId() {
        return this.mId;
    }

    public abstract ClientFileInfo generateClientFileInfo(String var1);

    public synchronized void reverseId() {
        this.mId = -this.mId;
    }

    public synchronized String getName() {
        return this.mName;
    }

    public synchronized void setName(String name) {
        this.mName = name;
    }

    public synchronized int getParentId() {
        return this.mParentId;
    }

    public synchronized void setParentId(int parentId) {
        this.mParentId = parentId;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("INode(");
        sb.append("ID:").append(this.mId).append(", NAME:").append(this.mName);
        sb.append(", PARENT_ID:").append(this.mParentId);
        sb.append(", CREATION_TIME_MS:").append(this.CREATION_TIME_MS).append(")");
        return sb.toString();
    }
}

