/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.LeaderSelectorClient;
import tachyon.UnderFileSystem;
import tachyon.Version;
import tachyon.conf.CommonConf;
import tachyon.conf.MasterConf;
import tachyon.master.EditLogProcessor;
import tachyon.master.Journal;
import tachyon.master.MasterInfo;
import tachyon.master.MasterServiceHandler;
import tachyon.org.apache.thrift.server.THsHaServer;
import tachyon.org.apache.thrift.server.TServer;
import tachyon.org.apache.thrift.transport.TNonblockingServerSocket;
import tachyon.org.apache.thrift.transport.TTransportException;
import tachyon.thrift.MasterService;
import tachyon.util.CommonUtils;
import tachyon.web.UIWebServer;

public class Master {
    private static final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private boolean mIsStarted;
    private MasterInfo mMasterInfo;
    private InetSocketAddress mMasterAddress;
    private UIWebServer mWebServer;
    private TServer mMasterServiceServer;
    private MasterServiceHandler mMasterServiceHandler;
    private Journal mJournal;
    private EditLogProcessor mEditLogProcessor;
    private int mWebPort;
    private int mWorkerThreads;
    private boolean mZookeeperMode = false;
    private LeaderSelectorClient mLeaderSelectorClient = null;

    public Master(InetSocketAddress address, int webPort, int selectorThreads, int acceptQueueSizePerThreads, int workerThreads) {
        if (CommonConf.get().USE_ZOOKEEPER) {
            this.mZookeeperMode = true;
        }
        this.mIsStarted = false;
        this.mWebPort = webPort;
        this.mWorkerThreads = workerThreads;
        try {
            this.mMasterAddress = address;
            String journalFolder = MasterConf.get().JOURNAL_FOLDER;
            if (!this.isFormatted(MasterConf.get().JOURNAL_FOLDER, MasterConf.get().FORMAT_FILE_PREFIX)) {
                LOG.error((Object)"Tachyon was not formatted!");
                System.exit(-1);
            }
            this.mJournal = new Journal(journalFolder, "image.data", "log.data");
            this.mMasterInfo = new MasterInfo(this.mMasterAddress, this.mJournal);
            if (this.mZookeeperMode) {
                CommonConf conf = CommonConf.get();
                this.mLeaderSelectorClient = new LeaderSelectorClient(conf.ZOOKEEPER_ADDRESS, conf.ZOOKEEPER_ELECTION_PATH, conf.ZOOKEEPER_LEADER_PATH, address.getHostName() + ":" + address.getPort());
                this.mEditLogProcessor = new EditLogProcessor(this.mJournal, journalFolder, this.mMasterInfo);
                Thread logProcessor = new Thread(this.mEditLogProcessor);
                logProcessor.start();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            System.exit(-1);
        }
    }

    private boolean isFormatted(String folder, String path) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(folder);
        String[] files = ufs.list(folder);
        if (files == null) {
            return false;
        }
        for (String file : files) {
            if (!file.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    private void setup() throws IOException, TTransportException {
        if (this.mZookeeperMode) {
            this.mEditLogProcessor.stop();
        }
        this.mMasterInfo.init();
        this.mWebServer = new UIWebServer("Tachyon Master Server", new InetSocketAddress(this.mMasterAddress.getHostName(), this.mWebPort), this.mMasterInfo);
        this.mMasterServiceHandler = new MasterServiceHandler(this.mMasterInfo);
        MasterService.Processor<MasterServiceHandler> masterServiceProcessor = new MasterService.Processor<MasterServiceHandler>(this.mMasterServiceHandler);
        this.mMasterServiceServer = new THsHaServer(((THsHaServer.Args)new THsHaServer.Args(new TNonblockingServerSocket(this.mMasterAddress)).processor(masterServiceProcessor)).workerThreads(this.mWorkerThreads));
        this.mIsStarted = true;
    }

    public void start() {
        if (this.mZookeeperMode) {
            try {
                this.mLeaderSelectorClient.start();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                System.exit(-1);
            }
            Thread currentThread = Thread.currentThread();
            this.mLeaderSelectorClient.setCurrentMasterThread(currentThread);
            boolean running = false;
            while (true) {
                if (this.mLeaderSelectorClient.isLeader()) {
                    if (!running) {
                        running = true;
                        try {
                            this.setup();
                        }
                        catch (IOException e) {
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                            System.exit(-1);
                        }
                        catch (TTransportException e) {
                            LOG.error((Object)e.getMessage(), (Throwable)e);
                            System.exit(-1);
                        }
                        this.mWebServer.startWebServer();
                        LOG.info((Object)("The master (leader) server started @ " + this.mMasterAddress));
                        this.mMasterServiceServer.serve();
                        LOG.info((Object)("The master (previous leader) server ended @ " + this.mMasterAddress));
                        this.mJournal.close();
                    }
                } else if (running) {
                    this.mMasterServiceServer.stop();
                    running = false;
                }
                CommonUtils.sleepMs(LOG, 100L);
            }
        }
        try {
            this.setup();
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            System.exit(-1);
        }
        catch (TTransportException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            System.exit(-1);
        }
        this.mWebServer.startWebServer();
        LOG.info((Object)("The master server started @ " + this.mMasterAddress));
        this.mMasterServiceServer.serve();
        LOG.info((Object)("The master server ended @ " + this.mMasterAddress));
    }

    public void stop() throws Exception {
        if (this.mIsStarted) {
            this.mWebServer.shutdownWebServer();
            this.mMasterInfo.stop();
            this.mMasterServiceServer.stop();
            if (this.mZookeeperMode) {
                this.mLeaderSelectorClient.close();
            }
            this.mIsStarted = false;
        }
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            LOG.info((Object)("java -cp target/tachyon-" + Version.VERSION + "-jar-with-dependencies.jar " + "tachyon.Master"));
            System.exit(-1);
        }
        MasterConf mConf = MasterConf.get();
        Master master = new Master(new InetSocketAddress(mConf.HOSTNAME, mConf.PORT), mConf.WEB_PORT, mConf.SELECTOR_THREADS, mConf.QUEUE_SIZE_PER_SELECTOR, mConf.SERVER_THREADS);
        master.start();
    }

    MasterInfo getMasterInfo() {
        return this.mMasterInfo;
    }

    boolean isZookeeperMode() {
        return this.mZookeeperMode;
    }

    boolean isStarted() {
        return this.mIsStarted;
    }
}

