/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import java.io.Serializable;

public class Counters
implements Serializable,
Comparable<Counters> {
    private static final long serialVersionUID = -8873733429025713755L;
    private int mInodeCounter;
    private long mEditTransactionId;
    private int mDependencyCounter;

    public Counters(int inodeCounter, long editTransactionId, int dependencyCounter) {
        this.mInodeCounter = inodeCounter;
        this.mEditTransactionId = editTransactionId;
        this.mDependencyCounter = dependencyCounter;
    }

    @Override
    public synchronized int compareTo(Counters o) {
        if (this.mInodeCounter != o.mInodeCounter) {
            return this.mInodeCounter - o.mInodeCounter;
        }
        if (this.mEditTransactionId != o.mEditTransactionId) {
            return this.mEditTransactionId > o.mEditTransactionId ? 1 : -1;
        }
        if (this.mDependencyCounter == o.mDependencyCounter) {
            return 0;
        }
        return this.mDependencyCounter > o.mDependencyCounter ? 1 : -1;
    }

    public synchronized boolean equals(Object o) {
        if (!(o instanceof Counters)) {
            return false;
        }
        return this.compareTo((Counters)o) == 0;
    }

    public synchronized int getDependencyCounter() {
        return this.mDependencyCounter;
    }

    public synchronized long getEditTransactionCounter() {
        return this.mEditTransactionId;
    }

    public synchronized int getInodeCounter() {
        return this.mInodeCounter;
    }

    public synchronized int hashCode() {
        return (int)((long)this.mInodeCounter + this.mEditTransactionId + (long)this.mDependencyCounter);
    }

    public synchronized void updateDependencyCounter(int dependencyCounter) {
        this.mDependencyCounter = Math.max(this.mDependencyCounter, dependencyCounter);
    }

    public synchronized void updateEditTransactionCounter(long id) {
        this.mEditTransactionId = Math.max(this.mEditTransactionId, id);
    }

    public synchronized void updateInodeCounter(int inodeCounter) {
        this.mInodeCounter = Math.max(this.mInodeCounter, inodeCounter);
    }

    public String toString() {
        return "Counter(" + this.mInodeCounter + "," + this.mEditTransactionId + "," + this.mDependencyCounter + ")";
    }
}

