/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.UnderFileSystem;
import tachyon.master.JsonObject;
import tachyon.master.MasterInfo;

public class Image {
    private static final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);

    public static void create(MasterInfo info, String path) throws IOException {
        String tPath = path + ".tmp";
        String parentFolder = path.substring(0, path.lastIndexOf("/"));
        LOG.info((Object)("Creating the image file: " + tPath));
        UnderFileSystem ufs = UnderFileSystem.get(path);
        if (!ufs.exists(parentFolder)) {
            LOG.info((Object)("Creating parent folder " + parentFolder));
            ufs.mkdirs(parentFolder, true);
        }
        OutputStream os = ufs.create(tPath);
        DataOutputStream imageOs = new DataOutputStream(os);
        ObjectWriter writer = JsonObject.createObjectMapper().writer();
        info.writeImage(writer, imageOs);
        imageOs.flush();
        imageOs.close();
        LOG.info((Object)("Succefully created the image file: " + tPath));
        ufs.delete(path, false);
        ufs.rename(tPath, path);
        ufs.delete(tPath, false);
        LOG.info((Object)("Renamed " + tPath + " to " + path));
        ufs.close();
    }

    public static void load(MasterInfo info, String path) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(path);
        if (!ufs.exists(path)) {
            LOG.info((Object)("Image " + path + " does not exist."));
            return;
        }
        LOG.info((Object)("Loading image " + path));
        DataInputStream imageIs = new DataInputStream(ufs.open(path));
        JsonParser parser = JsonObject.createObjectMapper().getJsonFactory().createJsonParser((InputStream)imageIs);
        info.loadImage(parser, path);
        imageIs.close();
        ufs.close();
    }

    public static void rename(String src, String dst) throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(src);
        ufs.rename(src, dst);
        LOG.info((Object)("Renamed " + src + " to " + dst));
    }
}

