/*
 * Decompiled with CFR 0.152.
 */
package tachyon.web;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.client.InStream;
import tachyon.client.ReadType;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.master.BlockInfo;
import tachyon.master.MasterInfo;
import tachyon.org.apache.thrift.TException;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.InvalidPathException;
import tachyon.util.CommonUtils;
import tachyon.web.UiFileInfo;

public class WebInterfaceBrowseServlet
extends HttpServlet {
    private static final long serialVersionUID = 6121623049981468871L;
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private MasterInfo mMasterInfo;

    public WebInterfaceBrowseServlet(MasterInfo masterInfo) {
        this.mMasterInfo = masterInfo;
    }

    private void displayFile(String path, HttpServletRequest request, long offset) throws FileDoesNotExistException, InvalidPathException, IOException {
        String masterAddress = "tachyon://" + this.mMasterInfo.getMasterAddress().getHostName() + ":" + this.mMasterInfo.getMasterAddress().getPort();
        TachyonFS tachyonClient = TachyonFS.get(masterAddress);
        TachyonFile tFile = tachyonClient.getFile(path);
        String fileData = null;
        if (tFile == null) {
            throw new FileDoesNotExistException(path);
        }
        if (tFile.isComplete()) {
            InStream is = tFile.getInStream(ReadType.NO_CACHE);
            int len = (int)Math.min(5120L, tFile.length() - offset);
            byte[] data = new byte[len];
            is.skip(offset);
            is.read(data, 0, len);
            fileData = CommonUtils.convertByteArrayToStringWithoutEscape(data);
            if (fileData == null) {
                fileData = "The requested file is not completely encoded in ascii";
            }
            is.close();
        } else {
            fileData = "The requested file is not complete yet.";
        }
        try {
            tachyonClient.close();
        }
        catch (TException e) {
            this.LOG.error((Object)e.getMessage());
        }
        List<BlockInfo> rawBlockList = this.mMasterInfo.getBlockList(path);
        ArrayList<UiBlockInfo> uiBlockInfo = new ArrayList<UiBlockInfo>();
        for (BlockInfo blockInfo : rawBlockList) {
            uiBlockInfo.add(new UiBlockInfo(blockInfo));
        }
        request.setAttribute("fileBlocks", uiBlockInfo);
        request.setAttribute("fileData", (Object)fileData);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, UnknownHostException {
        request.setAttribute("debug", (Object)Constants.DEBUG);
        request.setAttribute("masterNodeAddress", (Object)this.mMasterInfo.getMasterAddress().toString());
        request.setAttribute("invalidPathError", (Object)"");
        List<ClientFileInfo> filesInfo = null;
        String currentPath = request.getParameter("path");
        if (currentPath == null || currentPath.isEmpty()) {
            currentPath = "/";
        }
        request.setAttribute("currentPath", (Object)currentPath);
        request.setAttribute("viewingOffset", (Object)0);
        try {
            ClientFileInfo clientFileInfo = this.mMasterInfo.getClientFileInfo(currentPath);
            UiFileInfo currentFileInfo = new UiFileInfo(clientFileInfo);
            request.setAttribute("currentDirectory", (Object)currentFileInfo);
            request.setAttribute("blockSizeByte", (Object)currentFileInfo.getBlockSizeBytes());
            if (!currentFileInfo.getIsDirectory()) {
                String tmpParam = request.getParameter("offset");
                long offset = 0L;
                try {
                    if (tmpParam != null) {
                        offset = Long.valueOf(tmpParam);
                    }
                }
                catch (NumberFormatException nfe) {
                    offset = 0L;
                }
                if (offset < 0L) {
                    offset = 0L;
                } else if (offset > clientFileInfo.getLength()) {
                    offset = clientFileInfo.getLength();
                }
                this.displayFile(currentFileInfo.getAbsolutePath(), request, offset);
                request.setAttribute("viewingOffset", (Object)offset);
                this.getServletContext().getRequestDispatcher("/viewFile.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            CommonUtils.validatePath(currentPath);
            this.setPathDirectories(currentPath, request);
            filesInfo = this.mMasterInfo.getFilesInfo(currentPath);
        }
        catch (FileDoesNotExistException fdne) {
            request.setAttribute("invalidPathError", (Object)("Error: Invalid Path " + fdne.getMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (InvalidPathException ipe) {
            request.setAttribute("invalidPathError", (Object)("Error: Invalid Path " + ipe.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (IOException ie) {
            request.setAttribute("invalidPathError", (Object)("Error: File " + currentPath + " is not available " + ie.getMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        ArrayList<UiFileInfo> fileInfos = new ArrayList<UiFileInfo>(filesInfo.size());
        for (ClientFileInfo fileInfo : filesInfo) {
            UiFileInfo toAdd = new UiFileInfo(fileInfo);
            try {
                if (!toAdd.getIsDirectory() && fileInfo.getLength() > 0L) {
                    toAdd.setFileLocations(this.mMasterInfo.getFileLocations(toAdd.getId()).get(0).getLocations());
                }
            }
            catch (FileDoesNotExistException fdne) {
                request.setAttribute("invalidPathError", (Object)("Error: Invalid Path " + fdne.getMessage()));
                this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            fileInfos.add(toAdd);
        }
        Collections.sort(fileInfos);
        request.setAttribute("fileInfos", fileInfos);
        this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void setPathDirectories(String path, HttpServletRequest request) throws FileDoesNotExistException, InvalidPathException {
        if (path.equals("/")) {
            request.setAttribute("pathInfos", (Object)new UiFileInfo[0]);
            return;
        }
        String[] splitPath = path.split("/");
        UiFileInfo[] pathInfos = new UiFileInfo[splitPath.length - 1];
        String currentPath = "/";
        pathInfos[0] = new UiFileInfo(this.mMasterInfo.getClientFileInfo(currentPath));
        for (int i = 1; i < splitPath.length - 1; ++i) {
            currentPath = CommonUtils.concat(currentPath, splitPath[i]);
            pathInfos[i] = new UiFileInfo(this.mMasterInfo.getClientFileInfo(currentPath));
        }
        request.setAttribute("pathInfos", (Object)pathInfos);
    }

    public class UiBlockInfo
    implements Comparable<UiBlockInfo> {
        private final long ID;
        private final long BLOCK_LENGTH;
        private final boolean IN_MEMORY;

        public UiBlockInfo(BlockInfo blockInfo) {
            this.ID = blockInfo.BLOCK_ID;
            this.BLOCK_LENGTH = blockInfo.LENGTH;
            this.IN_MEMORY = blockInfo.isInMemory();
        }

        @Override
        public int compareTo(UiBlockInfo p) {
            return this.ID < p.ID ? -1 : (this.ID == p.ID ? 0 : 1);
        }

        public long getBlockLength() {
            return this.BLOCK_LENGTH;
        }

        public long getID() {
            return this.ID;
        }

        public boolean inMemory() {
            return this.IN_MEMORY;
        }
    }
}

