/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import org.apache.log4j.Logger;
import tachyon.Constants;
import tachyon.client.TachyonByteBuffer;
import tachyon.conf.WorkerConf;
import tachyon.util.CommonUtils;

public class DataServerMessage {
    public static final short DATA_SERVER_REQUEST_MESSAGE = 1;
    public static final short DATA_SERVER_RESPONSE_MESSAGE = 2;
    private final Logger LOG = Logger.getLogger((String)Constants.LOGGER_TYPE);
    private final boolean IS_TO_SEND_DATA;
    private final short mMsgType;
    private boolean mIsMessageReady;
    private ByteBuffer mHeader;
    private static final int HEADER_LENGTH = 26;
    private long mBlockId;
    private long mOffset;
    private long mLength;
    private int mLockId = -1;
    private TachyonByteBuffer mTachyonData = null;
    private ByteBuffer mData = null;

    public static DataServerMessage createBlockRequestMessage() {
        DataServerMessage ret = new DataServerMessage(false, 1);
        ret.mHeader = ByteBuffer.allocate(26);
        return ret;
    }

    public static DataServerMessage createBlockRequestMessage(long blockId) {
        return DataServerMessage.createBlockRequestMessage(blockId, 0L, -1L);
    }

    public static DataServerMessage createBlockRequestMessage(long blockId, long offset, long len) {
        DataServerMessage ret = new DataServerMessage(true, 1);
        ret.mHeader = ByteBuffer.allocate(26);
        ret.mBlockId = blockId;
        ret.mOffset = offset;
        ret.mLength = len;
        ret.generateHeader();
        ret.mData = ByteBuffer.allocate(0);
        ret.mIsMessageReady = true;
        return ret;
    }

    public static DataServerMessage createBlockResponseMessage(boolean toSend, long blockId) {
        return DataServerMessage.createBlockResponseMessage(toSend, blockId, 0L, -1L);
    }

    public static DataServerMessage createBlockResponseMessage(boolean toSend, long blockId, long offset, long len) {
        DataServerMessage ret = new DataServerMessage(toSend, 2);
        if (toSend) {
            ret.mBlockId = blockId;
            try {
                if (offset < 0L) {
                    throw new IOException("Offset can not be negative: " + offset);
                }
                if (len < 0L && len != -1L) {
                    throw new IOException("Length can not be negative except -1: " + len);
                }
                String filePath = CommonUtils.concat(WorkerConf.get().DATA_FOLDER, blockId);
                ret.LOG.info((Object)("Try to response remote requst by reading from " + filePath));
                RandomAccessFile file = new RandomAccessFile(filePath, "r");
                long fileLength = file.length();
                String error = null;
                if (offset > fileLength) {
                    error = String.format("Offset(%d) is larger than file length(%d)", offset, fileLength);
                }
                if (error == null && len != -1L && offset + len > fileLength) {
                    error = String.format("Offset(%d) plus length(%d) is larger than file length(%d)", offset, len, fileLength);
                }
                if (error != null) {
                    file.close();
                    throw new IOException(error);
                }
                if (len == -1L) {
                    len = fileLength - offset;
                }
                ret.mHeader = ByteBuffer.allocate(26);
                ret.mOffset = offset;
                ret.mLength = len;
                FileChannel channel = file.getChannel();
                ret.mTachyonData = null;
                ret.mData = channel.map(FileChannel.MapMode.READ_ONLY, offset, len);
                channel.close();
                file.close();
                ret.mIsMessageReady = true;
                ret.generateHeader();
                ret.LOG.info((Object)("Response remote requst by reading from " + filePath + " preparation done."));
            }
            catch (Exception e) {
                ret.mBlockId = -ret.mBlockId;
                ret.mLength = 0L;
                ret.mHeader = ByteBuffer.allocate(26);
                ret.mData = ByteBuffer.allocate(0);
                ret.mIsMessageReady = true;
                ret.generateHeader();
                ret.LOG.error((Object)("The file is not here : " + e.getMessage()), (Throwable)e);
            }
        } else {
            ret.mHeader = ByteBuffer.allocate(26);
            ret.mData = null;
        }
        return ret;
    }

    private DataServerMessage(boolean isToSendData, short msgType) {
        this.IS_TO_SEND_DATA = isToSendData;
        this.mMsgType = msgType;
        this.mIsMessageReady = false;
    }

    public void checkReady() {
        if (!this.mIsMessageReady) {
            CommonUtils.runtimeException("Message is not ready.");
        }
    }

    public void close() {
        if (this.mMsgType == 2) {
            try {
                if (this.mTachyonData != null) {
                    this.mTachyonData.close();
                }
            }
            catch (Exception e) {
                this.LOG.error((Object)e.getMessage());
            }
        }
    }

    public boolean finishSending() {
        this.isSend(true);
        return this.mHeader.remaining() == 0 && this.mData.remaining() == 0;
    }

    private void generateHeader() {
        this.mHeader.clear();
        this.mHeader.putShort(this.mMsgType);
        this.mHeader.putLong(this.mBlockId);
        this.mHeader.putLong(this.mOffset);
        this.mHeader.putLong(this.mLength);
        this.mHeader.flip();
    }

    public long getBlockId() {
        this.checkReady();
        return this.mBlockId;
    }

    public long getLength() {
        this.checkReady();
        return this.mLength;
    }

    int getLockId() {
        return this.mLockId;
    }

    public long getOffset() {
        this.checkReady();
        return this.mOffset;
    }

    public ByteBuffer getReadOnlyData() {
        this.checkReady();
        ByteBuffer ret = this.mData.asReadOnlyBuffer();
        ret.flip();
        return ret;
    }

    public boolean isMessageReady() {
        return this.mIsMessageReady;
    }

    private void isSend(boolean isSend) {
        if (this.IS_TO_SEND_DATA != isSend) {
            if (this.IS_TO_SEND_DATA) {
                CommonUtils.runtimeException("Try to recv on send message");
            } else {
                CommonUtils.runtimeException("Try to send on recv message");
            }
        }
    }

    public int recv(SocketChannel socketChannel) throws IOException {
        this.isSend(false);
        int numRead = 0;
        if (this.mHeader.remaining() > 0) {
            numRead = socketChannel.read(this.mHeader);
            if (this.mHeader.remaining() == 0) {
                this.mHeader.flip();
                short msgType = this.mHeader.getShort();
                assert (this.mMsgType == msgType);
                this.mBlockId = this.mHeader.getLong();
                this.mOffset = this.mHeader.getLong();
                this.mLength = this.mHeader.getLong();
                assert (this.mLength < Integer.MAX_VALUE);
                if (this.mMsgType == 2) {
                    this.mData = this.mLength == -1L ? ByteBuffer.allocate(0) : ByteBuffer.allocate((int)this.mLength);
                }
                this.LOG.info((Object)String.format("data" + this.mData + ", blockId(%d), offset(%d), dataLength(%d)", this.mBlockId, this.mOffset, this.mLength));
                if (this.mMsgType == 1 || this.mLength <= 0L) {
                    this.mIsMessageReady = true;
                }
            }
        } else {
            numRead = socketChannel.read(this.mData);
            if (this.mData.remaining() == 0) {
                this.mIsMessageReady = true;
            }
        }
        return numRead;
    }

    public void send(SocketChannel socketChannel) throws IOException {
        this.isSend(true);
        socketChannel.write(this.mHeader);
        if (this.mHeader.remaining() == 0) {
            socketChannel.write(this.mData);
        }
    }

    void setLockId(int lockId) {
        this.mLockId = lockId;
    }
}

