/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import tachyon.Pair;
import tachyon.TachyonURI;
import tachyon.UnderFileSystemHdfs;
import tachyon.UnderFileSystemSingleLocal;
import tachyon.conf.CommonConf;

public abstract class UnderFileSystem {
    public static UnderFileSystem get(String path) {
        return UnderFileSystem.get(path, null);
    }

    public static UnderFileSystem get(String path, Object conf) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path may not be null");
        if (UnderFileSystem.isHadoopUnderFS(path)) {
            return UnderFileSystemHdfs.getClient(path, conf);
        }
        if (path.startsWith("/") || path.startsWith("file://")) {
            return UnderFileSystemSingleLocal.getClient();
        }
        throw new IllegalArgumentException("Unknown under file system scheme " + path);
    }

    private static boolean isHadoopUnderFS(String path) {
        for (String prefix : CommonConf.get().HADOOP_UFS_PREFIXES) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static Pair<String, String> parse(TachyonURI path) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path may not be null");
        if (path.hasScheme()) {
            String authority;
            String header = path.getScheme() + "://";
            String string = authority = path.hasAuthority() ? path.getAuthority() : "";
            if (header.equals("tachyon://") || header.equals("tachyon-ft://") || UnderFileSystem.isHadoopUnderFS(header)) {
                if (path.getPath().isEmpty()) {
                    return new Pair<String, String>(header + authority, "/");
                }
                return new Pair<String, String>(header + authority, path.getPath());
            }
            if (header.equals("file://")) {
                return new Pair<String, String>("/", path.getPath());
            }
        } else if (path.isPathAbsolute()) {
            return new Pair<String, String>("/", path.getPath());
        }
        return null;
    }

    public abstract void close() throws IOException;

    public abstract OutputStream create(String var1) throws IOException;

    public abstract OutputStream create(String var1, int var2) throws IOException;

    public abstract OutputStream create(String var1, short var2, int var3) throws IOException;

    public abstract boolean delete(String var1, boolean var2) throws IOException;

    public abstract boolean exists(String var1) throws IOException;

    public abstract long getBlockSizeByte(String var1) throws IOException;

    public abstract Object getConf();

    public abstract List<String> getFileLocations(String var1) throws IOException;

    public abstract List<String> getFileLocations(String var1, long var2) throws IOException;

    public abstract long getFileSize(String var1) throws IOException;

    public abstract long getModificationTimeMs(String var1) throws IOException;

    public abstract long getSpace(String var1, SpaceType var2) throws IOException;

    public abstract boolean isFile(String var1) throws IOException;

    public abstract String[] list(String var1) throws IOException;

    public abstract boolean mkdirs(String var1, boolean var2) throws IOException;

    public abstract InputStream open(String var1) throws IOException;

    public abstract boolean rename(String var1, String var2) throws IOException;

    public abstract void setConf(Object var1);

    public abstract void setPermission(String var1, String var2) throws IOException;

    public static enum SpaceType {
        SPACE_TOTAL(0),
        SPACE_FREE(1),
        SPACE_USED(2);

        private final int mValue;

        private SpaceType(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }
    }
}

