/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import tachyon.TachyonURI;
import tachyon.client.TachyonFSCore;
import tachyon.conf.UserConf;

abstract class AbstractTachyonFS
implements TachyonFSCore {
    AbstractTachyonFS() {
    }

    public synchronized int createFile(TachyonURI path) throws IOException {
        return this.createFile(path, UserConf.get().DEFAULT_BLOCK_SIZE_BYTE);
    }

    public synchronized int createFile(TachyonURI path, long blockSizeByte) throws IOException {
        if (blockSizeByte > 0x80000000L) {
            throw new IOException("Block size must be less than 2GB: " + blockSizeByte);
        }
        return this.createFile(path, TachyonURI.EMPTY_URI, blockSizeByte, true);
    }

    public synchronized int createFile(TachyonURI path, TachyonURI ufsPath) throws IOException {
        return this.createFile(path, ufsPath, -1L, true);
    }

    public synchronized boolean delete(int fid, boolean recursive) throws IOException {
        return this.delete(fid, TachyonURI.EMPTY_URI, recursive);
    }

    public synchronized boolean delete(TachyonURI path, boolean recursive) throws IOException {
        return this.delete(-1, path, recursive);
    }

    public synchronized boolean mkdir(TachyonURI path) throws IOException {
        return this.mkdirs(path, true);
    }

    public synchronized boolean rename(int fileId, TachyonURI dstPath) throws IOException {
        return this.rename(fileId, TachyonURI.EMPTY_URI, dstPath);
    }

    public synchronized boolean rename(TachyonURI srcPath, TachyonURI dstPath) throws IOException {
        return this.rename(-1, srcPath, dstPath);
    }

    public synchronized boolean freepath(TachyonURI path, boolean recursive) throws IOException {
        return this.freepath(-1, path, recursive);
    }
}

