/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.UnderFileSystem;
import tachyon.client.BlockInStream;
import tachyon.client.BlockOutStream;
import tachyon.client.ReadType;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.client.WriteType;
import tachyon.conf.UserConf;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.NetAddress;
import tachyon.util.NetworkUtils;
import tachyon.worker.nio.DataServerMessage;

public class RemoteBlockInStream
extends BlockInStream {
    private static final int BUFFER_SIZE = UserConf.get().REMOTE_READ_BUFFER_SIZE_BYTE;
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private ClientBlockInfo mBlockInfo;
    private InputStream mCheckpointInputStream = null;
    private long mCheckpointPos = -1L;
    private long mBlockPos = 0L;
    private ByteBuffer mCurrentBuffer = null;
    private long mBufferStartPos;
    private boolean mRecache;
    private boolean mAttemptReadFromWorkers = true;
    private BlockOutStream mBlockOutStream = null;
    private Object mUFSConf = null;
    private static final int MAX_REMOTE_READ_ATTEMPTS = 2;

    RemoteBlockInStream(TachyonFile file, ReadType readType, int blockIndex) throws IOException {
        this(file, readType, blockIndex, null);
    }

    RemoteBlockInStream(TachyonFile file, ReadType readType, int blockIndex, Object ufsConf) throws IOException {
        super(file, readType, blockIndex);
        if (!this.mFile.isComplete()) {
            throw new IOException("File " + this.mFile.getPath() + " is not ready to read");
        }
        this.mBlockInfo = this.mFile.getClientBlockInfo(this.mBlockIndex);
        this.mRecache = readType.isCache();
        this.mUFSConf = ufsConf;
    }

    private void cancelRecache() throws IOException {
        if (this.mRecache) {
            this.mRecache = false;
            if (this.mBlockOutStream != null) {
                this.mBlockOutStream.cancel();
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed) {
            return;
        }
        if (this.mRecache && this.mBlockOutStream != null) {
            if (this.mBlockPos == this.mBlockInfo.length) {
                this.mBlockOutStream.close();
            } else {
                this.mBlockOutStream.cancel();
            }
        }
        if (this.mCheckpointInputStream != null) {
            this.mCheckpointInputStream.close();
        }
        this.mClosed = true;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.read(b) == -1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.mBlockPos == this.mBlockInfo.length) {
            return -1;
        }
        int bytesLeft = len = (int)Math.min((long)len, this.mBlockInfo.length - this.mBlockPos);
        if (bytesLeft > 0 && this.mBlockOutStream == null && this.mRecache) {
            try {
                this.mBlockOutStream = new BlockOutStream(this.mFile, WriteType.TRY_CACHE, this.mBlockIndex);
            }
            catch (IOException ioe) {
                LOG.warn("Recache attempt failed.", (Throwable)ioe);
                this.cancelRecache();
            }
        }
        while (bytesLeft > 0 && this.mAttemptReadFromWorkers && this.updateCurrentBuffer()) {
            int bytesToRead = Math.min(bytesLeft, this.mCurrentBuffer.remaining());
            this.mCurrentBuffer.get(b, off, bytesToRead);
            if (this.mRecache) {
                this.mBlockOutStream.write(b, off, bytesToRead);
            }
            off += bytesToRead;
            bytesLeft -= bytesToRead;
            this.mBlockPos += (long)bytesToRead;
        }
        if (bytesLeft > 0) {
            this.mAttemptReadFromWorkers = false;
            if (!this.setupStreamFromUnderFs()) {
                LOG.error("Failed to read at position " + this.mBlockPos + " in block " + this.mBlockInfo.getBlockId() + " from workers or underfs");
                return len - bytesLeft;
            }
            while (bytesLeft > 0) {
                int readBytes = this.mCheckpointInputStream.read(b, off, bytesLeft);
                if (readBytes <= 0) {
                    LOG.error("Checkpoint stream read 0 bytes, which shouldn't ever happen");
                    return len - bytesLeft;
                }
                if (this.mRecache) {
                    this.mBlockOutStream.write(b, off, readBytes);
                }
                off += readBytes;
                bytesLeft -= readBytes;
                this.mBlockPos += (long)readBytes;
                this.mCheckpointPos += (long)readBytes;
            }
        }
        return len;
    }

    public static ByteBuffer readRemoteByteBuffer(TachyonFS tachyonFS, ClientBlockInfo blockInfo, long offset, long len) {
        ByteBuffer buf = null;
        try {
            List<NetAddress> blockLocations = blockInfo.getLocations();
            LOG.info("Block locations:" + blockLocations);
            for (NetAddress blockLocation : blockLocations) {
                String host = blockLocation.mHost;
                int port = blockLocation.mSecondaryPort;
                if (port == -1) continue;
                if (host.equals(InetAddress.getLocalHost().getHostName()) || host.equals(InetAddress.getLocalHost().getHostAddress()) || host.equals(NetworkUtils.getLocalHostName())) {
                    LOG.warn("Master thinks the local machine has data, But not! blockId:{}", (Object)blockInfo.blockId);
                }
                LOG.info(host + ":" + port + " current host is " + NetworkUtils.getLocalHostName() + " " + NetworkUtils.getLocalIpAddress());
                try {
                    buf = RemoteBlockInStream.retrieveByteBufferFromRemoteMachine(new InetSocketAddress(host, port), blockInfo.blockId, offset, len);
                    if (buf == null) continue;
                    break;
                }
                catch (IOException e) {
                    LOG.error("Fail to retrieve byte buffer for block " + blockInfo.blockId + " from remote " + host + ":" + port + " with offset " + offset + " and length " + len, (Throwable)e);
                    buf = null;
                }
            }
        }
        catch (IOException e) {
            LOG.error("Failed to get read data from remote ", (Throwable)e);
            buf = null;
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer retrieveByteBufferFromRemoteMachine(InetSocketAddress address, long blockId, long offset, long length) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        try {
            socketChannel.connect(address);
            LOG.info("Connected to remote machine " + address + " sent");
            DataServerMessage sendMsg = DataServerMessage.createBlockRequestMessage(blockId, offset, length);
            while (!sendMsg.finishSending()) {
                sendMsg.send(socketChannel);
            }
            LOG.info("Data " + blockId + " to remote machine " + address + " sent");
            DataServerMessage recvMsg = DataServerMessage.createBlockResponseMessage(false, blockId, null);
            while (!recvMsg.isMessageReady()) {
                int numRead = recvMsg.recv(socketChannel);
                if (numRead != -1) continue;
                LOG.warn("Read nothing");
            }
            LOG.info("Data " + blockId + " from remote machine " + address + " received");
            if (!recvMsg.isMessageReady()) {
                LOG.info("Data " + blockId + " from remote machine is not ready.");
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            if (recvMsg.getBlockId() < 0L) {
                LOG.info("Data " + recvMsg.getBlockId() + " is not in remote machine.");
                ByteBuffer byteBuffer = null;
                return byteBuffer;
            }
            ByteBuffer byteBuffer = recvMsg.getReadOnlyData();
            return byteBuffer;
        }
        finally {
            socketChannel.close();
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < 0L) {
            throw new IOException("Seek position is negative: " + pos);
        }
        if (pos > this.mBlockInfo.length) {
            throw new IOException("Seek position is past block size: " + pos + ", Block Size = " + this.mBlockInfo.length);
        }
        if (pos == this.mBlockPos) {
            return;
        }
        this.cancelRecache();
        this.mBlockPos = pos;
    }

    private boolean setupStreamFromUnderFs() throws IOException {
        if (this.mCheckpointInputStream == null || this.mBlockPos < this.mCheckpointPos) {
            String checkpointPath = this.mFile.getUfsPath();
            LOG.info("Opening stream from underlayer fs: " + checkpointPath);
            if (checkpointPath.equals("")) {
                return false;
            }
            UnderFileSystem underfsClient = UnderFileSystem.get(checkpointPath, this.mUFSConf);
            this.mCheckpointInputStream = underfsClient.open(checkpointPath);
            if (this.mCheckpointInputStream.skip(this.mBlockInfo.offset) != this.mBlockInfo.offset) {
                throw new IOException("Failed to skip to the block offset " + this.mBlockInfo.offset + " in the checkpoint file");
            }
            this.mCheckpointPos = 0L;
        }
        while (this.mCheckpointPos < this.mBlockPos) {
            long skipped = this.mCheckpointInputStream.skip(this.mBlockPos - this.mCheckpointPos);
            if (skipped <= 0L) {
                throw new IOException("Failed to skip to the position " + this.mBlockPos + " for block " + this.mBlockInfo);
            }
            this.mCheckpointPos += skipped;
        }
        return true;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        this.cancelRecache();
        long skipped = Math.min(n, this.mBlockInfo.length - this.mBlockPos);
        this.mBlockPos += skipped;
        return skipped;
    }

    private boolean updateCurrentBuffer() throws IOException {
        if (this.mCurrentBuffer != null && this.mBufferStartPos <= this.mBlockPos && this.mBlockPos < Math.min(this.mBufferStartPos + (long)BUFFER_SIZE, this.mBlockInfo.length)) {
            this.mCurrentBuffer.position((int)(this.mBlockPos - this.mBufferStartPos));
            return true;
        }
        this.mBufferStartPos = this.mBlockPos;
        long length = Math.min((long)BUFFER_SIZE, this.mBlockInfo.length - this.mBufferStartPos);
        LOG.info("Try to find remote worker and read block {} from {}, with len {}", new Object[]{this.mBlockInfo.blockId, this.mBufferStartPos, length});
        for (int i = 0; i < 2; ++i) {
            this.mCurrentBuffer = RemoteBlockInStream.readRemoteByteBuffer(this.mTachyonFS, this.mBlockInfo, this.mBufferStartPos, length);
            if (this.mCurrentBuffer != null) {
                return true;
            }
            this.mBlockInfo = this.mFile.getClientBlockInfo(this.mBlockIndex);
        }
        return false;
    }
}

