/*
 * Decompiled with CFR 0.152.
 */
package tachyon.conf;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Utils {
    private static final Logger LOG = LoggerFactory.getLogger((String)"");
    private static final CharMatcher LIST_SPLITTER_MATCHER = CharMatcher.is((char)',').or(CharMatcher.WHITESPACE);
    private static final Splitter LIST_SPLITTER = Splitter.on((CharMatcher)LIST_SPLITTER_MATCHER).omitEmptyStrings().trimResults();

    Utils() {
    }

    public static boolean getBooleanProperty(String property) {
        return Boolean.valueOf(Utils.getProperty(property));
    }

    public static boolean getBooleanProperty(String property, boolean defaultValue) {
        return Boolean.valueOf(Utils.getProperty(property, defaultValue + ""));
    }

    public static <T extends Enum<T>> T getEnumProperty(String property, T defaultValue) {
        String val = Utils.getProperty(property, null);
        return null == val ? defaultValue : Enum.valueOf(defaultValue.getDeclaringClass(), val);
    }

    public static int getIntProperty(String property) {
        return Integer.valueOf(Utils.getProperty(property));
    }

    public static int getIntProperty(String property, int defaultValue) {
        return Integer.valueOf(Utils.getProperty(property, defaultValue + ""));
    }

    public static Integer getIntegerProperty(String property, Integer defaultValue) {
        try {
            return Integer.valueOf(Utils.getProperty(property, null));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long getLongProperty(String property) {
        return Long.valueOf(Utils.getProperty(property));
    }

    public static long getLongProperty(String property, int defaultValue) {
        return Long.valueOf(Utils.getProperty(property, defaultValue + ""));
    }

    public static ImmutableList<String> getListProperty(String property, ImmutableList<String> defaultValue) {
        String strList = Utils.getProperty(property, null);
        if (strList == null) {
            return defaultValue;
        }
        return ImmutableList.copyOf((Iterable)LIST_SPLITTER.split((CharSequence)strList));
    }

    public static String getProperty(String property) {
        String ret = System.getProperty(property);
        Preconditions.checkArgument((ret != null ? 1 : 0) != 0, (Object)(property + " is not configured."));
        LOG.debug("{} : {}", (Object)property, (Object)ret);
        return ret;
    }

    public static String getProperty(String property, String defaultValue) {
        String ret = System.getProperty(property);
        String msg = "";
        if (ret == null) {
            ret = defaultValue;
            msg = " uses the default value";
        }
        LOG.debug("{} {} : {}", new Object[]{property, msg, ret});
        return ret;
    }
}

