/*
 * Decompiled with CFR 0.152.
 */
package tachyon.conf;

import com.google.common.base.Optional;
import tachyon.StorageLevelAlias;
import tachyon.conf.Utils;
import tachyon.util.CommonUtils;
import tachyon.util.NetworkUtils;
import tachyon.worker.NetworkType;
import tachyon.worker.allocation.AllocateStrategyType;
import tachyon.worker.eviction.EvictStrategyType;
import tachyon.worker.netty.ChannelType;
import tachyon.worker.netty.FileTransferType;

public class WorkerConf
extends Utils {
    private static WorkerConf sWorkerConf = null;
    public final String MASTER_HOSTNAME = WorkerConf.getProperty("tachyon.master.hostname", NetworkUtils.getLocalHostName());
    public final int MASTER_PORT = WorkerConf.getIntProperty("tachyon.master.port", 19998);
    public final int PORT = WorkerConf.getIntProperty("tachyon.worker.port", 29998);
    public final int DATA_PORT = WorkerConf.getIntProperty("tachyon.worker.data.port", 29999);
    public final String DATA_FOLDER = WorkerConf.getProperty("tachyon.worker.data.folder", "/datastore");
    public final long MEMORY_SIZE = CommonUtils.parseSpaceSize(WorkerConf.getProperty("tachyon.worker.memory.size", "134217728"));
    public final long HEARTBEAT_TIMEOUT_MS = WorkerConf.getIntProperty("tachyon.worker.heartbeat.timeout.ms", 10000);
    public final int TO_MASTER_HEARTBEAT_INTERVAL_MS = WorkerConf.getIntProperty("tachyon.worker.to.master.heartbeat.interval.ms", 1000);
    public final int SELECTOR_THREADS = WorkerConf.getIntProperty("tachyon.worker.selector.threads", 3);
    public final int QUEUE_SIZE_PER_SELECTOR = WorkerConf.getIntProperty("tachyon.worker.queue.size.per.selector", 3000);
    public final int SERVER_THREADS = WorkerConf.getIntProperty("tachyon.worker.server.threads", Runtime.getRuntime().availableProcessors());
    public final int USER_TIMEOUT_MS = WorkerConf.getIntProperty("tachyon.worker.user.timeout.ms", 10000);
    public static final String USER_TEMP_RELATIVE_FOLDER = "users";
    public final int WORKER_CHECKPOINT_THREADS = WorkerConf.getIntProperty("tachyon.worker.checkpoint.threads", 1);
    public final int WORKER_PER_THREAD_CHECKPOINT_CAP_MB_SEC = WorkerConf.getIntProperty("tachyon.worker.per.thread.checkpoint.cap.mb.sec", 1000);
    public final NetworkType NETWORK_TYPE;
    public final String KEYTAB_KEY;
    public final String KEYTAB = WorkerConf.getProperty(this.KEYTAB_KEY, null);
    public final String PRINCIPAL_KEY;
    public final String PRINCIPAL = WorkerConf.getProperty(this.PRINCIPAL_KEY, null);
    public final ChannelType NETTY_CHANNEL_TYPE;
    public final FileTransferType NETTY_FILE_TRANSFER_TYPE;
    public final int NETTY_HIGH_WATER_MARK;
    public final int NETTY_BOSS_THREADS;
    public final int NETTY_WORKER_THREADS;
    public final int NETTY_LOW_WATER_MARK;
    public final Optional<Integer> NETTY_BACKLOG;
    public final Optional<Integer> NETTY_SEND_BUFFER;
    public final Optional<Integer> NETTY_RECIEVE_BUFFER;
    public final EvictStrategyType EVICT_STRATEGY_TYPE;
    public final AllocateStrategyType ALLOCATE_STRATEGY_TYPE;
    public final int STORAGE_LEVELS;
    public final StorageLevelAlias[] STORAGE_LEVEL_ALIAS;
    public final String[] STORAGE_TIER_DIRS;
    public final String[] STORAGE_TIER_DIR_QUOTA;

    public static synchronized void clear() {
        sWorkerConf = null;
    }

    public static synchronized WorkerConf get() {
        if (sWorkerConf == null) {
            sWorkerConf = new WorkerConf();
        }
        return sWorkerConf;
    }

    private WorkerConf() {
        this.KEYTAB_KEY = "tachyon.worker.keytab.file";
        this.PRINCIPAL_KEY = "tachyon.worker.principal";
        this.NETWORK_TYPE = WorkerConf.getEnumProperty("tachyon.worker.network.type", NetworkType.NETTY);
        this.NETTY_BOSS_THREADS = WorkerConf.getIntProperty("tachyon.worker.network.netty.boss.threads", 1);
        this.NETTY_WORKER_THREADS = WorkerConf.getIntProperty("tachyon.worker.network.netty.worker.threads", 0);
        this.NETTY_CHANNEL_TYPE = WorkerConf.getEnumProperty("tachyon.worker.network.netty.channel", ChannelType.defaultType());
        this.NETTY_FILE_TRANSFER_TYPE = WorkerConf.getEnumProperty("tachyon.worker.network.netty.file.transfer", FileTransferType.MAPPED);
        this.NETTY_HIGH_WATER_MARK = WorkerConf.getIntProperty("tachyon.worker.network.netty.watermark.high", 32768);
        this.NETTY_LOW_WATER_MARK = WorkerConf.getIntProperty("tachyon.worker.network.netty.watermark.low", 8192);
        this.NETTY_BACKLOG = Optional.fromNullable((Object)WorkerConf.getIntegerProperty("tachyon.worker.network.netty.backlog", null));
        this.NETTY_SEND_BUFFER = Optional.fromNullable((Object)WorkerConf.getIntegerProperty("tachyon.worker.network.netty.buffer.send", null));
        this.NETTY_RECIEVE_BUFFER = Optional.fromNullable((Object)WorkerConf.getIntegerProperty("tachyon.worker.network.netty.buffer.receive", null));
        this.EVICT_STRATEGY_TYPE = WorkerConf.getEnumProperty("tachyon.worker.evict.strategy", EvictStrategyType.LRU);
        this.ALLOCATE_STRATEGY_TYPE = WorkerConf.getEnumProperty("tachyon.worker.allocate.strategy", AllocateStrategyType.MAX_FREE);
        this.STORAGE_LEVELS = WorkerConf.getIntProperty("tachyon.worker.hierarchystore.level.max", 1);
        this.STORAGE_LEVEL_ALIAS = new StorageLevelAlias[this.STORAGE_LEVELS];
        this.STORAGE_TIER_DIRS = new String[this.STORAGE_LEVELS];
        this.STORAGE_TIER_DIR_QUOTA = new String[this.STORAGE_LEVELS];
        for (int i = 0; i < this.STORAGE_LEVELS; ++i) {
            this.STORAGE_LEVEL_ALIAS[i] = WorkerConf.getEnumProperty("tachyon.worker.hierarchystore.level" + i + ".alias", StorageLevelAlias.MEM);
            if (this.STORAGE_LEVEL_ALIAS[i].equals((Object)StorageLevelAlias.MEM)) {
                this.STORAGE_TIER_DIR_QUOTA[i] = WorkerConf.getProperty("tachyon.worker.hierarchystore.level" + i + ".dirs.quota", this.MEMORY_SIZE + "");
                this.STORAGE_TIER_DIRS[i] = WorkerConf.getProperty("tachyon.worker.hierarchystore.level" + i + ".dirs.path", "/mnt/ramdisk");
                continue;
            }
            this.STORAGE_TIER_DIR_QUOTA[i] = WorkerConf.getProperty("tachyon.worker.hierarchystore.level" + i + ".dirs.quota");
            this.STORAGE_TIER_DIRS[i] = WorkerConf.getProperty("tachyon.worker.hierarchystore.level" + i + ".dirs.path");
        }
    }
}

