/*
 * Decompiled with CFR 0.152.
 */
package tachyon.hadoop;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.client.InStream;
import tachyon.client.ReadType;
import tachyon.client.TachyonFS;
import tachyon.client.TachyonFile;
import tachyon.conf.UserConf;

public class HdfsFileInputStream
extends InputStream
implements Seekable,
PositionedReadable {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private long mCurrentPosition;
    private TachyonFS mTFS;
    private int mFileId;
    private Path mHdfsPath;
    private Configuration mHadoopConf;
    private int mHadoopBufferSize;
    private TachyonFile mTachyonFile;
    private FSDataInputStream mHdfsInputStream = null;
    private InStream mTachyonFileInputStream = null;
    private int mBufferLimit = 0;
    private int mBufferPosition = 0;
    private byte[] mBuffer;

    public HdfsFileInputStream(TachyonFS tfs, int fileId, Path hdfsPath, Configuration conf, int bufferSize) throws IOException {
        this.mBuffer = new byte[UserConf.get().FILE_BUFFER_BYTES * 4];
        LOG.debug("PartitionInputStreamHdfs({}, {}, {}, {}, {})", new Object[]{tfs, fileId, hdfsPath, conf, bufferSize});
        this.mCurrentPosition = 0L;
        this.mTFS = tfs;
        this.mFileId = fileId;
        this.mHdfsPath = hdfsPath;
        this.mHadoopConf = conf;
        this.mHadoopBufferSize = bufferSize;
        this.mTachyonFile = this.mTFS.getFile(this.mFileId);
        if (this.mTachyonFile == null) {
            throw new FileNotFoundException("File " + hdfsPath + " with FID " + fileId + " is not found.");
        }
        this.mTachyonFile.setUFSConf(this.mHadoopConf);
        try {
            this.mTachyonFileInputStream = this.mTachyonFile.getInStream(ReadType.CACHE);
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.mTachyonFileInputStream != null) {
            this.mTachyonFileInputStream.close();
        }
        if (this.mHdfsInputStream != null) {
            this.mHdfsInputStream.close();
        }
    }

    private void getHdfsInputStream() throws IOException {
        if (this.mHdfsInputStream == null) {
            FileSystem fs = this.mHdfsPath.getFileSystem(this.mHadoopConf);
            this.mHdfsInputStream = fs.open(this.mHdfsPath, this.mHadoopBufferSize);
            this.mHdfsInputStream.seek(this.mCurrentPosition);
        }
    }

    private void getHdfsInputStream(long position) throws IOException {
        if (this.mHdfsInputStream == null) {
            FileSystem fs = this.mHdfsPath.getFileSystem(this.mHadoopConf);
            this.mHdfsInputStream = fs.open(this.mHdfsPath, this.mHadoopBufferSize);
        }
        this.mHdfsInputStream.seek(position);
    }

    public long getPos() throws IOException {
        return this.mCurrentPosition;
    }

    @Override
    public int read() throws IOException {
        if (this.mTachyonFileInputStream != null) {
            int ret = 0;
            try {
                ret = this.mTachyonFileInputStream.read();
                ++this.mCurrentPosition;
                return ret;
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mTachyonFileInputStream = null;
            }
        }
        this.getHdfsInputStream();
        return this.readFromHdfsBuffer();
    }

    @Override
    public int read(byte[] b) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.mTachyonFileInputStream != null) {
            int ret = 0;
            try {
                ret = this.mTachyonFileInputStream.read(b, off, len);
                this.mCurrentPosition += (long)ret;
                return ret;
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                this.mTachyonFileInputStream = null;
            }
        }
        this.getHdfsInputStream();
        b[off] = (byte)this.readFromHdfsBuffer();
        if (b[off] == -1) {
            return -1;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(long position, byte[] buffer, int offset, int length) throws IOException {
        int ret = -1;
        long oldPos = this.getPos();
        if (position < 0L || position >= this.mTachyonFile.length()) {
            return ret;
        }
        if (this.mTachyonFileInputStream != null) {
            try {
                this.mTachyonFileInputStream.seek(position);
                int n = ret = this.mTachyonFileInputStream.read(buffer, offset, length);
                return n;
            }
            finally {
                this.mTachyonFileInputStream.seek(oldPos);
            }
        }
        try {
            this.getHdfsInputStream(position);
            int n = ret = this.mHdfsInputStream.read(buffer, offset, length);
            return n;
        }
        finally {
            if (this.mHdfsInputStream != null) {
                this.mHdfsInputStream.seek(oldPos);
            }
        }
    }

    private int readFromHdfsBuffer() throws IOException {
        if (this.mBufferPosition < this.mBufferLimit) {
            return this.mBuffer[this.mBufferPosition++];
        }
        LOG.error("Reading from HDFS directly");
        while ((this.mBufferLimit = this.mHdfsInputStream.read(this.mBuffer)) == 0) {
            LOG.error("Read 0 bytes in readFromHdfsBuffer for " + this.mHdfsPath);
        }
        if (this.mBufferLimit == -1) {
            return -1;
        }
        this.mBufferPosition = 0;
        return this.mBuffer[this.mBufferPosition++];
    }

    public void readFully(long position, byte[] buffer) throws IOException {
        throw new IOException("Not supported");
    }

    public void readFully(long position, byte[] buffer, int offset, int length) throws IOException {
        throw new IOException("Not supported");
    }

    public void seek(long pos) throws IOException {
        if (pos == this.mCurrentPosition) {
            return;
        }
        if (pos < 0L) {
            throw new IllegalArgumentException("Seek position is negative: " + pos);
        }
        if (pos > this.mTachyonFile.length()) {
            throw new IllegalArgumentException("Seek position is past EOF: " + pos + ", fileSize = " + this.mTachyonFile.length());
        }
        if (this.mTachyonFileInputStream != null) {
            this.mTachyonFileInputStream.seek(pos);
        } else {
            this.getHdfsInputStream(pos);
        }
        this.mCurrentPosition = pos;
    }

    public boolean seekToNewSource(long targetPos) throws IOException {
        throw new IOException("Not supported");
    }
}

