/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.HeartbeatExecutor;
import tachyon.HeartbeatThread;
import tachyon.Pair;
import tachyon.PrefixList;
import tachyon.TachyonURI;
import tachyon.UnderFileSystem;
import tachyon.conf.CommonConf;
import tachyon.conf.MasterConf;
import tachyon.master.BlockInfo;
import tachyon.master.Counters;
import tachyon.master.Dependency;
import tachyon.master.DependencyType;
import tachyon.master.ImageElement;
import tachyon.master.ImageElementType;
import tachyon.master.ImageWriter;
import tachyon.master.Inode;
import tachyon.master.InodeFile;
import tachyon.master.InodeFolder;
import tachyon.master.Journal;
import tachyon.master.MasterWorkerInfo;
import tachyon.master.RawTables;
import tachyon.master.RecomputeCommand;
import tachyon.thrift.BlockInfoException;
import tachyon.thrift.ClientBlockInfo;
import tachyon.thrift.ClientDependencyInfo;
import tachyon.thrift.ClientFileInfo;
import tachyon.thrift.ClientRawTableInfo;
import tachyon.thrift.ClientWorkerInfo;
import tachyon.thrift.Command;
import tachyon.thrift.CommandType;
import tachyon.thrift.DependencyDoesNotExistException;
import tachyon.thrift.FileAlreadyExistException;
import tachyon.thrift.FileDoesNotExistException;
import tachyon.thrift.InvalidPathException;
import tachyon.thrift.NetAddress;
import tachyon.thrift.SuspectedFileSizeException;
import tachyon.thrift.TableColumnException;
import tachyon.thrift.TableDoesNotExistException;
import tachyon.thrift.TachyonException;
import tachyon.util.CommonUtils;

public class MasterInfo
extends ImageWriter {
    public static final String COL = "COL_";
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final InetSocketAddress mMasterAddress;
    private final long mStartTimeNSPrefix;
    private final long mStartTimeMs;
    private final MasterConf mMasterConf;
    private final Counters mCheckpointInfo = new Counters(0, 0L, 0);
    private final AtomicInteger mInodeCounter = new AtomicInteger(0);
    private final AtomicInteger mDependencyCounter = new AtomicInteger(0);
    private final AtomicInteger mRerunCounter = new AtomicInteger(0);
    private final AtomicInteger mUserCounter = new AtomicInteger(0);
    private final AtomicInteger mWorkerCounter = new AtomicInteger(0);
    private InodeFolder mRoot;
    private final Object mRootLock = new Object();
    private final Map<Integer, Inode> mFileIdToInodes = new HashMap<Integer, Inode>();
    private final Map<Integer, Dependency> mFileIdToDependency = new HashMap<Integer, Dependency>();
    private final RawTables mRawTables = new RawTables();
    private final Set<Integer> mUncheckpointedDependencies = new HashSet<Integer>();
    private final Set<Integer> mPriorityDependencies = new HashSet<Integer>();
    private final Set<Integer> mLostFiles = new HashSet<Integer>();
    private final Set<Integer> mBeingRecomputedFiles = new HashSet<Integer>();
    private final Set<Integer> mMustRecomputedDpendencies = new HashSet<Integer>();
    private final Map<Long, MasterWorkerInfo> mWorkers = new HashMap<Long, MasterWorkerInfo>();
    private final Map<NetAddress, Long> mWorkerAddressToId = new HashMap<NetAddress, Long>();
    private final BlockingQueue<MasterWorkerInfo> mLostWorkers = new ArrayBlockingQueue<MasterWorkerInfo>(32);
    private final PrefixList mWhitelist;
    private final Set<Integer> mPinnedInodeFileIds;
    private final Journal mJournal;
    private final ExecutorService mExecutorService;
    private Future<?> mHeartbeat;
    private Future<?> mRecompute;

    public MasterInfo(InetSocketAddress address, Journal journal, ExecutorService mExecutorService) throws IOException {
        this.mExecutorService = mExecutorService;
        this.mMasterConf = MasterConf.get();
        this.mRoot = new InodeFolder("", this.mInodeCounter.incrementAndGet(), -1, System.currentTimeMillis());
        this.mFileIdToInodes.put(this.mRoot.getId(), this.mRoot);
        this.mMasterAddress = address;
        this.mStartTimeMs = System.currentTimeMillis();
        this.mStartTimeNSPrefix = this.mStartTimeMs - this.mStartTimeMs % 1000000L;
        this.mJournal = journal;
        this.mWhitelist = new PrefixList(this.mMasterConf.WHITELIST);
        this.mPinnedInodeFileIds = Collections.synchronizedSet(new HashSet());
        this.mJournal.loadImage(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Pair<Boolean, Boolean> _addCheckpoint(long workerId, int fileId, long length, TachyonURI checkpointPath, long opTimeMs) throws FileNotFoundException, SuspectedFileSizeException, BlockInfoException {
        LOG.info(CommonUtils.parametersToString(workerId, fileId, length, checkpointPath));
        if (workerId != -1L) {
            MasterWorkerInfo tWorkerInfo = this.getWorkerInfo(workerId);
            tWorkerInfo.updateLastUpdatedTimeMs();
        }
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.mFileIdToInodes.get(fileId);
            if (inode == null) {
                throw new FileNotFoundException("File " + fileId + " does not exist.");
            }
            if (inode.isDirectory()) {
                throw new FileNotFoundException("File " + fileId + " is a folder.");
            }
            InodeFile tFile = (InodeFile)inode;
            boolean needLog = false;
            if (tFile.isComplete()) {
                if (tFile.getLength() != length) {
                    throw new SuspectedFileSizeException(fileId + ". Original Size: " + tFile.getLength() + ". New Size: " + length);
                }
            } else {
                tFile.setLength(length);
                needLog = true;
            }
            if (!tFile.hasCheckpointed()) {
                tFile.setUfsPath(checkpointPath.toString());
                needLog = true;
                Map<Integer, Dependency> map = this.mFileIdToDependency;
                synchronized (map) {
                    int depId = tFile.getDependencyId();
                    if (depId != -1) {
                        Dependency dep = this.mFileIdToDependency.get(depId);
                        dep.childCheckpointed(tFile.getId());
                        if (dep.hasCheckpointed()) {
                            this.mUncheckpointedDependencies.remove(dep.mId);
                            this.mPriorityDependencies.remove(dep.mId);
                        }
                    }
                }
            }
            this.addFile(fileId, tFile.getDependencyId());
            tFile.setComplete();
            if (needLog) {
                tFile.setLastModificationTimeMs(opTimeMs);
            }
            return new Pair<Boolean, Boolean>(true, needLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _completeFile(int fileId, long opTimeMs) throws FileDoesNotExistException {
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.mFileIdToInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("File " + fileId + " does not exit.");
            }
            if (!inode.isFile()) {
                throw new FileDoesNotExistException("File " + fileId + " is not a file.");
            }
            this.addFile(fileId, ((InodeFile)inode).getDependencyId());
            ((InodeFile)inode).setComplete();
            inode.setLastModificationTimeMs(opTimeMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int _createDependency(List<Integer> parentsIds, List<Integer> childrenIds, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, DependencyType dependencyType, int dependencyId, long creationTimeMs) throws InvalidPathException, FileDoesNotExistException {
        Dependency dep = null;
        Map<Integer, Dependency> map = this.mRootLock;
        synchronized (map) {
            Inode inode;
            HashSet<Integer> parentDependencyIds = new HashSet<Integer>();
            for (int k = 0; k < parentsIds.size(); ++k) {
                int parentId = parentsIds.get(k);
                inode = this.mFileIdToInodes.get(parentId);
                if (inode.isFile()) {
                    LOG.info("PARENT DEPENDENCY ID IS " + ((InodeFile)inode).getDependencyId() + " " + inode);
                    if (((InodeFile)inode).getDependencyId() == -1) continue;
                    parentDependencyIds.add(((InodeFile)inode).getDependencyId());
                    continue;
                }
                throw new InvalidPathException("Parent " + parentId + " is not a file.");
            }
            dep = new Dependency(dependencyId, parentsIds, childrenIds, commandPrefix, data, comment, framework, frameworkVersion, dependencyType, parentDependencyIds, creationTimeMs);
            ArrayList<Inode> childrenInodes = new ArrayList<Inode>();
            for (int k = 0; k < childrenIds.size(); ++k) {
                inode = (InodeFile)this.mFileIdToInodes.get(childrenIds.get(k));
                ((InodeFile)inode).setDependencyId(dep.mId);
                inode.setLastModificationTimeMs(creationTimeMs);
                childrenInodes.add(inode);
                if (!((InodeFile)inode).hasCheckpointed()) continue;
                dep.childCheckpointed(inode.getId());
            }
        }
        map = this.mFileIdToDependency;
        synchronized (map) {
            this.mFileIdToDependency.put(dep.mId, dep);
            if (!dep.hasCheckpointed()) {
                this.mUncheckpointedDependencies.add(dep.mId);
            }
            for (int parentDependencyId : dep.mParentDependencies) {
                this.mFileIdToDependency.get(parentDependencyId).addChildrenDependency(dep.mId);
            }
        }
        this.mJournal.getEditLog().createDependency(parentsIds, childrenIds, commandPrefix, data, comment, framework, frameworkVersion, dependencyType, dependencyId, creationTimeMs);
        this.mJournal.getEditLog().flush();
        LOG.info("Dependency created: " + dep);
        return dep.mId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int _createFile(boolean recursive, TachyonURI path, boolean directory, long blockSizeByte, long creationTimeMs) throws FileAlreadyExistException, InvalidPathException, BlockInfoException, TachyonException {
        if (path.isRoot()) {
            LOG.info("FileAlreadyExistException: " + path);
            throw new FileAlreadyExistException(path.toString());
        }
        if (!directory && blockSizeByte < 1L) {
            throw new BlockInfoException("Invalid block size " + blockSizeByte);
        }
        LOG.debug("createFile {}", (Object)CommonUtils.parametersToString(path));
        String[] pathNames = CommonUtils.getPathComponents(path.toString());
        String name = path.getName();
        String[] parentPath = new String[pathNames.length - 1];
        System.arraycopy(pathNames, 0, parentPath, 0, parentPath.length);
        Object object = this.mRootLock;
        synchronized (object) {
            Pair<Inode, Integer> inodeTraversal = this.traverseToInode(parentPath);
            int pathIndex = parentPath.length;
            if (!this.traversalSucceeded(inodeTraversal)) {
                if (!recursive) {
                    String msg = "File " + path + " creation failed. Component " + inodeTraversal.getSecond() + "(" + parentPath[inodeTraversal.getSecond()] + ") does not exist";
                    LOG.info("InvalidPathException: " + msg);
                    throw new InvalidPathException(msg);
                }
                pathIndex = inodeTraversal.getSecond();
            }
            if (!inodeTraversal.getFirst().isDirectory()) {
                throw new InvalidPathException("Could not traverse to parent folder of path " + path + ". Component " + pathNames[pathIndex - 1] + " is not a directory.");
            }
            InodeFolder currentInodeFolder = (InodeFolder)inodeTraversal.getFirst();
            for (int k = pathIndex; k < parentPath.length; ++k) {
                InodeFolder dir = new InodeFolder(pathNames[k], this.mInodeCounter.incrementAndGet(), currentInodeFolder.getId(), creationTimeMs);
                dir.setPinned(currentInodeFolder.isPinned());
                currentInodeFolder.addChild(dir);
                currentInodeFolder.setLastModificationTimeMs(creationTimeMs);
                this.mFileIdToInodes.put(dir.getId(), dir);
                currentInodeFolder = dir;
            }
            Inode ret = currentInodeFolder.getChild(name);
            if (ret != null) {
                if (ret.isDirectory() && directory) {
                    return ret.getId();
                }
                LOG.info("FileAlreadyExistException: " + path);
                throw new FileAlreadyExistException(path.toString());
            }
            if (directory) {
                ret = new InodeFolder(name, this.mInodeCounter.incrementAndGet(), currentInodeFolder.getId(), creationTimeMs);
                ret.setPinned(currentInodeFolder.isPinned());
            } else {
                ret = new InodeFile(name, this.mInodeCounter.incrementAndGet(), currentInodeFolder.getId(), blockSizeByte, creationTimeMs);
                ret.setPinned(currentInodeFolder.isPinned());
                if (ret.isPinned()) {
                    this.mPinnedInodeFileIds.add(ret.getId());
                }
                if (this.mWhitelist.inList(path.toString())) {
                    ((InodeFile)ret).setCache(true);
                }
            }
            this.mFileIdToInodes.put(ret.getId(), ret);
            currentInodeFolder.addChild(ret);
            currentInodeFolder.setLastModificationTimeMs(creationTimeMs);
            LOG.debug("createFile: File Created: {} parent: ", (Object)ret, (Object)currentInodeFolder);
            return ret.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _createRawTable(int tableId, int columns, ByteBuffer metadata) throws TachyonException {
        RawTables rawTables = this.mRawTables;
        synchronized (rawTables) {
            if (!this.mRawTables.addRawTable(tableId, columns, metadata)) {
                throw new TachyonException("Failed to create raw table.");
            }
            this.mJournal.getEditLog().createRawTable(tableId, columns, metadata);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean _delete(int fileId, boolean recursive, long opTimeMs) throws TachyonException {
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.mFileIdToInodes.get(fileId);
            if (inode == null) {
                return true;
            }
            if (inode.isDirectory() && !recursive && ((InodeFolder)inode).getNumberOfChildren() > 0) {
                return false;
            }
            if (inode.getId() == this.mRoot.getId()) {
                return false;
            }
            ArrayList<Inode> delInodes = new ArrayList<Inode>();
            delInodes.add(inode);
            if (inode.isDirectory()) {
                delInodes.addAll(this.getInodeChildrenRecursive((InodeFolder)inode));
            }
            for (int i = delInodes.size() - 1; i >= 0; --i) {
                Inode delInode = (Inode)delInodes.get(i);
                if (delInode.isFile()) {
                    String checkpointPath = ((InodeFile)delInode).getUfsPath();
                    if (!checkpointPath.equals("")) {
                        UnderFileSystem ufs = UnderFileSystem.get(checkpointPath);
                        try {
                            if (!ufs.exists(checkpointPath)) {
                                LOG.warn("File does not exist the underfs: " + checkpointPath);
                            } else if (!ufs.delete(checkpointPath, true)) {
                                return false;
                            }
                        }
                        catch (IOException e) {
                            throw new TachyonException(e.getMessage());
                        }
                    }
                    List<Pair<Long, Long>> blockIdWorkerIdList = ((InodeFile)delInode).getBlockIdWorkerIdPairs();
                    Map<Long, MasterWorkerInfo> map = this.mWorkers;
                    synchronized (map) {
                        for (Pair<Long, Long> blockIdWorkerId : blockIdWorkerIdList) {
                            MasterWorkerInfo workerInfo = this.mWorkers.get(blockIdWorkerId.getSecond());
                            if (workerInfo == null) continue;
                            workerInfo.updateToRemovedBlock(true, blockIdWorkerId.getFirst());
                        }
                    }
                    this.mPinnedInodeFileIds.remove(delInode.getId());
                }
                InodeFolder parent = (InodeFolder)this.mFileIdToInodes.get(delInode.getParentId());
                parent.removeChild(delInode);
                parent.setLastModificationTimeMs(opTimeMs);
                if (this.mRawTables.exist(delInode.getId()) && !this.mRawTables.delete(delInode.getId())) {
                    return false;
                }
                this.mFileIdToInodes.remove(delInode.getId());
                delInode.reverseId();
            }
            return true;
        }
    }

    public ClientRawTableInfo _getClientRawTableInfo(TachyonURI path, Inode inode) throws TableDoesNotExistException {
        LOG.info("getClientRawTableInfo(" + path + ")");
        if (!this.mRawTables.exist(inode.getId())) {
            throw new TableDoesNotExistException("Table " + inode.getId() + " does not exist.");
        }
        ClientRawTableInfo ret = new ClientRawTableInfo();
        ret.id = inode.getId();
        ret.name = inode.getName();
        ret.path = path.toString();
        ret.columns = this.mRawTables.getColumns(ret.id);
        ret.metadata = this.mRawTables.getMetadata(ret.id);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TachyonURI> _ls(Inode inode, TachyonURI path, boolean recursive) throws InvalidPathException, FileDoesNotExistException {
        Object object = this.mRootLock;
        synchronized (object) {
            ArrayList<TachyonURI> ret = new ArrayList<TachyonURI>();
            ret.add(path);
            if (inode.isDirectory()) {
                for (Inode child : ((InodeFolder)inode).getChildren()) {
                    TachyonURI childUri = path.join(child.getName());
                    if (recursive) {
                        ret.addAll(this._ls(child, childUri, recursive));
                        continue;
                    }
                    ret.add(childUri);
                }
            }
            return ret;
        }
    }

    void _recomputePinnedFiles(Inode inode, Optional<Boolean> setPinState, long opTimeMs) {
        if (setPinState.isPresent()) {
            inode.setPinned((Boolean)setPinState.get());
            inode.setLastModificationTimeMs(opTimeMs);
        }
        if (inode.isFile()) {
            if (inode.isPinned()) {
                this.mPinnedInodeFileIds.add(inode.getId());
            } else {
                this.mPinnedInodeFileIds.remove(inode.getId());
            }
        } else if (inode.isDirectory()) {
            for (Inode child : ((InodeFolder)inode).getChildren()) {
                this._recomputePinnedFiles(child, setPinState, opTimeMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _rename(int fileId, TachyonURI dstPath, long opTimeMs) throws FileDoesNotExistException, InvalidPathException {
        Object object = this.mRootLock;
        synchronized (object) {
            String[] dstComponents;
            TachyonURI srcPath = this.getPath(fileId);
            if (srcPath.equals(dstPath)) {
                return true;
            }
            if (srcPath.isRoot() || dstPath.isRoot()) {
                return false;
            }
            String[] srcComponents = CommonUtils.getPathComponents(srcPath.toString());
            if (srcComponents.length < (dstComponents = CommonUtils.getPathComponents(dstPath.toString())).length) {
                boolean isPrefix = true;
                for (int prefixInd = 0; prefixInd < srcComponents.length; ++prefixInd) {
                    if (srcComponents[prefixInd].equals(dstComponents[prefixInd])) continue;
                    isPrefix = false;
                    break;
                }
                if (isPrefix) {
                    throw new InvalidPathException("Failed to rename: " + srcPath + " is a prefix of " + dstPath);
                }
            }
            TachyonURI srcParent = srcPath.getParent();
            TachyonURI dstParent = dstPath.getParent();
            Inode srcParentInode = this.getInode(srcParent);
            if (srcParentInode == null || !srcParentInode.isDirectory()) {
                return false;
            }
            Inode dstParentInode = this.getInode(dstParent);
            if (dstParentInode == null || !dstParentInode.isDirectory()) {
                return false;
            }
            Inode srcInode = ((InodeFolder)srcParentInode).getChild(srcComponents[srcComponents.length - 1]);
            if (srcInode == null) {
                return false;
            }
            if (((InodeFolder)dstParentInode).getChild(dstComponents[dstComponents.length - 1]) != null) {
                return false;
            }
            ((InodeFolder)srcParentInode).removeChild(srcInode);
            srcParentInode.setLastModificationTimeMs(opTimeMs);
            srcInode.setParentId(dstParentInode.getId());
            srcInode.setName(dstComponents[dstComponents.length - 1]);
            ((InodeFolder)dstParentInode).addChild(srcInode);
            dstParentInode.setLastModificationTimeMs(opTimeMs);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _setPinned(int fileId, boolean pinned, long opTimeMs) throws FileDoesNotExistException {
        LOG.info("setPinned(" + fileId + ", " + pinned + ")");
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.mFileIdToInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("Failed to find inode" + fileId);
            }
            this._recomputePinnedFiles(inode, (Optional<Boolean>)Optional.of((Object)pinned), opTimeMs);
        }
    }

    private void addBlock(InodeFile tFile, BlockInfo blockInfo, long opTimeMs) throws BlockInfoException {
        tFile.addBlock(blockInfo);
        tFile.setLastModificationTimeMs(opTimeMs);
        this.mJournal.getEditLog().addBlock(tFile.getId(), blockInfo.mBlockIndex, blockInfo.mLength, opTimeMs);
        this.mJournal.getEditLog().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCheckpoint(long workerId, int fileId, long length, TachyonURI checkpointPath) throws FileNotFoundException, SuspectedFileSizeException, BlockInfoException {
        long opTimeMs = System.currentTimeMillis();
        Object object = this.mRootLock;
        synchronized (object) {
            Pair<Boolean, Boolean> ret = this._addCheckpoint(workerId, fileId, length, checkpointPath, opTimeMs);
            if (ret.getSecond().booleanValue()) {
                this.mJournal.getEditLog().addCheckpoint(fileId, length, checkpointPath, opTimeMs);
                this.mJournal.getEditLog().flush();
            }
            return ret.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(int fileId, int dependencyId) {
        Map<Integer, Dependency> map = this.mFileIdToDependency;
        synchronized (map) {
            if (this.mLostFiles.contains(fileId)) {
                this.mLostFiles.remove(fileId);
            }
            if (this.mBeingRecomputedFiles.contains(fileId)) {
                this.mBeingRecomputedFiles.remove(fileId);
            }
        }
    }

    private void addToInodeMap(Inode inode, Map<Integer, Inode> map) {
        map.put(inode.getId(), inode);
        if (inode.isDirectory()) {
            InodeFolder inodeFolder = (InodeFolder)inode;
            for (Inode child : inodeFolder.getChildren()) {
                this.addToInodeMap(child, map);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cacheBlock(long workerId, long workerUsedBytes, long storageDirId, long blockId, long length) throws FileDoesNotExistException, SuspectedFileSizeException, BlockInfoException {
        LOG.debug("Cache block: {}", (Object)CommonUtils.parametersToString(workerId, workerUsedBytes, blockId, length));
        MasterWorkerInfo tWorkerInfo = this.getWorkerInfo(workerId);
        tWorkerInfo.updateBlock(true, blockId);
        tWorkerInfo.updateUsedBytes(workerUsedBytes);
        tWorkerInfo.updateLastUpdatedTimeMs();
        int fileId = BlockInfo.computeInodeId(blockId);
        int blockIndex = BlockInfo.computeBlockIndex(blockId);
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.mFileIdToInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("File " + fileId + " does not exist.");
            }
            if (inode.isDirectory()) {
                throw new FileDoesNotExistException("File " + fileId + " is a folder.");
            }
            InodeFile tFile = (InodeFile)inode;
            if (tFile.getNumberOfBlocks() <= blockIndex) {
                this.addBlock(tFile, new BlockInfo(tFile, blockIndex, length), System.currentTimeMillis());
            }
            tFile.addLocation(blockIndex, workerId, tWorkerInfo.mWorkerAddress, storageDirId);
            if (tFile.hasCheckpointed()) {
                return -1;
            }
            return tFile.getDependencyId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeFile(int fileId) throws FileDoesNotExistException {
        long opTimeMs = System.currentTimeMillis();
        Object object = this.mRootLock;
        synchronized (object) {
            this._completeFile(fileId, opTimeMs);
            this.mJournal.getEditLog().completeFile(fileId, opTimeMs);
            this.mJournal.getEditLog().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createDependency(List<TachyonURI> parents, List<TachyonURI> children, String commandPrefix, List<ByteBuffer> data, String comment, String framework, String frameworkVersion, DependencyType dependencyType) throws InvalidPathException, FileDoesNotExistException {
        Object object = this.mRootLock;
        synchronized (object) {
            LOG.info("ParentList: " + CommonUtils.listToString(parents));
            List<Integer> parentsIdList = this.getFilesIds(parents);
            List<Integer> childrenIdList = this.getFilesIds(children);
            int depId = this.mDependencyCounter.incrementAndGet();
            long creationTimeMs = System.currentTimeMillis();
            int ret = this._createDependency(parentsIdList, childrenIdList, commandPrefix, data, comment, framework, frameworkVersion, dependencyType, depId, creationTimeMs);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createFile(boolean recursive, TachyonURI path, boolean directory, long blockSizeByte) throws FileAlreadyExistException, InvalidPathException, BlockInfoException, TachyonException {
        long creationTimeMs = System.currentTimeMillis();
        Object object = this.mRootLock;
        synchronized (object) {
            int ret = this._createFile(recursive, path, directory, blockSizeByte, creationTimeMs);
            this.mJournal.getEditLog().createFile(recursive, path, directory, blockSizeByte, creationTimeMs);
            this.mJournal.getEditLog().flush();
            return ret;
        }
    }

    public int createFile(TachyonURI path, long blockSizeByte) throws FileAlreadyExistException, InvalidPathException, BlockInfoException, TachyonException {
        return this.createFile(true, path, false, blockSizeByte);
    }

    public int createFile(TachyonURI path, long blockSizeByte, boolean recursive) throws FileAlreadyExistException, InvalidPathException, BlockInfoException, TachyonException {
        return this.createFile(recursive, path, false, blockSizeByte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createNewBlock(int fileId) throws FileDoesNotExistException {
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.mFileIdToInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("File " + fileId + " does not exit.");
            }
            if (!inode.isFile()) {
                throw new FileDoesNotExistException("File " + fileId + " is not a file.");
            }
            return ((InodeFile)inode).getNewBlockId();
        }
    }

    public int createRawTable(TachyonURI path, int columns, ByteBuffer metadata) throws FileAlreadyExistException, InvalidPathException, TableColumnException, TachyonException {
        int id;
        LOG.info("createRawTable" + CommonUtils.parametersToString(path, columns));
        if (columns <= 0 || columns >= CommonConf.get().MAX_COLUMNS) {
            throw new TableColumnException("Column " + columns + " should between 0 to " + CommonConf.get().MAX_COLUMNS);
        }
        try {
            id = this.createFile(true, path, true, 0L);
            this._createRawTable(id, columns, metadata);
        }
        catch (BlockInfoException e) {
            throw new FileAlreadyExistException(e.getMessage());
        }
        for (int k = 0; k < columns; ++k) {
            this.mkdirs(path.join(COL + k), true);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(int fileId, boolean recursive) throws TachyonException {
        long opTimeMs = System.currentTimeMillis();
        Object object = this.mRootLock;
        synchronized (object) {
            boolean ret = this._delete(fileId, recursive, opTimeMs);
            this.mJournal.getEditLog().delete(fileId, recursive, opTimeMs);
            this.mJournal.getEditLog().flush();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(TachyonURI path, boolean recursive) throws TachyonException {
        LOG.info("delete(" + path + ")");
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = null;
            try {
                inode = this.getInode(path);
            }
            catch (InvalidPathException e) {
                return false;
            }
            if (inode == null) {
                return true;
            }
            return this.delete(inode.getId(), recursive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBlockIdBasedOnOffset(int fileId, long offset) throws FileDoesNotExistException {
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.mFileIdToInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("FileId " + fileId + " does not exist.");
            }
            if (!inode.isFile()) {
                throw new FileDoesNotExistException(fileId + " is not a file.");
            }
            return ((InodeFile)inode).getBlockIdBasedOnOffset(offset);
        }
    }

    public List<BlockInfo> getBlockList(TachyonURI path) throws InvalidPathException, FileDoesNotExistException {
        Inode inode = this.getInode(path);
        if (inode == null) {
            throw new FileDoesNotExistException(path + " does not exist.");
        }
        if (!inode.isFile()) {
            throw new FileDoesNotExistException(path + " is not a file.");
        }
        InodeFile inodeFile = (InodeFile)inode;
        return inodeFile.getBlockList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCapacityBytes() {
        long ret = 0L;
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            for (MasterWorkerInfo worker : this.mWorkers.values()) {
                ret += worker.getCapacityBytes();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientBlockInfo getClientBlockInfo(long blockId) throws FileDoesNotExistException, BlockInfoException {
        int fileId = BlockInfo.computeInodeId(blockId);
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.mFileIdToInodes.get(fileId);
            if (inode == null || inode.isDirectory()) {
                throw new FileDoesNotExistException("FileId " + fileId + " does not exist.");
            }
            ClientBlockInfo ret = ((InodeFile)inode).getClientBlockInfo(BlockInfo.computeBlockIndex(blockId));
            LOG.debug("getClientBlockInfo: {} : {}", (Object)blockId, (Object)ret);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientDependencyInfo getClientDependencyInfo(int dependencyId) throws DependencyDoesNotExistException {
        Dependency dep = null;
        Map<Integer, Dependency> map = this.mFileIdToDependency;
        synchronized (map) {
            dep = this.mFileIdToDependency.get(dependencyId);
            if (dep == null) {
                throw new DependencyDoesNotExistException("No dependency with id " + dependencyId);
            }
        }
        return dep.generateClientDependencyInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientFileInfo getClientFileInfo(int fid) {
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.mFileIdToInodes.get(fid);
            if (inode == null) {
                ClientFileInfo info = new ClientFileInfo();
                info.id = -1;
                return info;
            }
            return inode.generateClientFileInfo(this.getPath(inode).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientFileInfo getClientFileInfo(TachyonURI path) throws InvalidPathException {
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.getInode(path);
            if (inode == null) {
                ClientFileInfo info = new ClientFileInfo();
                info.id = -1;
                return info;
            }
            return inode.generateClientFileInfo(path.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRawTableInfo getClientRawTableInfo(int id) throws TableDoesNotExistException {
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.mFileIdToInodes.get(id);
            if (inode == null || !inode.isDirectory()) {
                throw new TableDoesNotExistException("Table " + id + " does not exist.");
            }
            return this._getClientRawTableInfo(this.getPath(inode), inode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientRawTableInfo getClientRawTableInfo(TachyonURI path) throws TableDoesNotExistException, InvalidPathException {
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.getInode(path);
            if (inode == null) {
                throw new TableDoesNotExistException("Table " + path + " does not exist.");
            }
            return this._getClientRawTableInfo(path, inode);
        }
    }

    public int getFileId(TachyonURI path) throws InvalidPathException {
        Inode inode = this.getInode(path);
        int ret = -1;
        if (inode != null) {
            ret = inode.getId();
        }
        LOG.debug("getFileId({}): {}", (Object)path, (Object)ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClientBlockInfo> getFileBlocks(int fileId) throws FileDoesNotExistException {
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.mFileIdToInodes.get(fileId);
            if (inode == null || inode.isDirectory()) {
                throw new FileDoesNotExistException("FileId " + fileId + " does not exist.");
            }
            List<ClientBlockInfo> ret = ((InodeFile)inode).getClientBlockInfos();
            LOG.debug("getFileLocations: {} {}", (Object)fileId, ret);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClientBlockInfo> getFileBlocks(TachyonURI path) throws FileDoesNotExistException, InvalidPathException {
        LOG.info("getFileLocations: " + path);
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.getInode(path);
            if (inode == null) {
                throw new FileDoesNotExistException(path.toString());
            }
            return this.getFileBlocks(inode.getId());
        }
    }

    private List<Integer> getFilesIds(List<TachyonURI> pathList) throws InvalidPathException, FileDoesNotExistException {
        ArrayList<Integer> ret = new ArrayList<Integer>(pathList.size());
        for (int k = 0; k < pathList.size(); ++k) {
            ret.addAll(this.listFiles(pathList.get(k), true));
        }
        return ret;
    }

    public List<ClientFileInfo> getFilesInfo(TachyonURI path) throws FileDoesNotExistException, InvalidPathException {
        ArrayList<ClientFileInfo> ret = new ArrayList<ClientFileInfo>();
        Inode inode = this.getInode(path);
        if (inode == null) {
            throw new FileDoesNotExistException(path.toString());
        }
        if (inode.isDirectory()) {
            for (Inode child : ((InodeFolder)inode).getChildren()) {
                ret.add(child.generateClientFileInfo(CommonUtils.concat(path, child.getName())));
            }
        } else {
            ret.add(inode.generateClientFileInfo(path.toString()));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TachyonURI> getInMemoryFiles() {
        ArrayList<TachyonURI> ret = new ArrayList<TachyonURI>();
        LOG.info("getInMemoryFiles()");
        LinkedList<Pair<InodeFolder, TachyonURI>> nodesQueue = new LinkedList<Pair<InodeFolder, TachyonURI>>();
        Object object = this.mRootLock;
        synchronized (object) {
            nodesQueue.add(new Pair<InodeFolder, TachyonURI>(this.mRoot, new TachyonURI("/")));
            while (!nodesQueue.isEmpty()) {
                Pair tPair = (Pair)nodesQueue.poll();
                InodeFolder tFolder = (InodeFolder)tPair.getFirst();
                TachyonURI curUri = (TachyonURI)tPair.getSecond();
                Set<Inode> children = tFolder.getChildren();
                for (Inode tInode : children) {
                    TachyonURI newUri = curUri.join(tInode.getName());
                    if (tInode.isDirectory()) {
                        nodesQueue.add(new Pair<InodeFolder, TachyonURI>((InodeFolder)tInode, newUri));
                        continue;
                    }
                    if (!((InodeFile)tInode).isFullyInMemory()) continue;
                    ret.add(newUri);
                }
            }
        }
        return ret;
    }

    private Inode getInode(TachyonURI path) throws InvalidPathException {
        return this.getInode(CommonUtils.getPathComponents(path.toString()));
    }

    private Inode getInode(String[] pathNames) throws InvalidPathException {
        Pair<Inode, Integer> inodeTraversal = this.traverseToInode(pathNames);
        if (!this.traversalSucceeded(inodeTraversal)) {
            return null;
        }
        return inodeTraversal.getFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Inode> getInodeChildrenRecursive(InodeFolder inodeFolder) {
        Object object = this.mRootLock;
        synchronized (object) {
            ArrayList<Inode> ret = new ArrayList<Inode>();
            for (Inode i : inodeFolder.getChildren()) {
                ret.add(i);
                if (!i.isDirectory()) continue;
                ret.addAll(this.getInodeChildrenRecursive((InodeFolder)i));
            }
            return ret;
        }
    }

    public Journal getJournal() {
        return this.mJournal;
    }

    public InetSocketAddress getMasterAddress() {
        return this.mMasterAddress;
    }

    public long getNewUserId() {
        return this.mUserCounter.incrementAndGet();
    }

    public int getNumberOfFiles(TachyonURI path) throws InvalidPathException, FileDoesNotExistException {
        Inode inode = this.getInode(path);
        if (inode == null) {
            throw new FileDoesNotExistException(path.toString());
        }
        if (inode.isFile()) {
            return 1;
        }
        return ((InodeFolder)inode).getNumberOfChildren();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TachyonURI getPath(Inode inode) {
        Object object = this.mRootLock;
        synchronized (object) {
            if (inode.getId() == 1) {
                return new TachyonURI("/");
            }
            if (inode.getParentId() == 1) {
                return new TachyonURI("/" + inode.getName());
            }
            return this.getPath(this.mFileIdToInodes.get(inode.getParentId())).join(inode.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TachyonURI getPath(int fileId) throws FileDoesNotExistException {
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.mFileIdToInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("FileId " + fileId + " does not exist");
            }
            return this.getPath(inode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getPinIdList() {
        Set<Integer> set = this.mPinnedInodeFileIds;
        synchronized (set) {
            return Lists.newArrayList(this.mPinnedInodeFileIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getPriorityDependencyList() {
        Map<Integer, Dependency> map = this.mFileIdToDependency;
        synchronized (map) {
            int earliestDepId = -1;
            if (this.mPriorityDependencies.isEmpty()) {
                long earliest = Long.MAX_VALUE;
                for (int depId : this.mUncheckpointedDependencies) {
                    Dependency dep = this.mFileIdToDependency.get(depId);
                    if (!dep.hasChildrenDependency()) {
                        this.mPriorityDependencies.add(dep.mId);
                    }
                    if (dep.mCreationTimeMs >= earliest) continue;
                    earliest = dep.mCreationTimeMs;
                    earliestDepId = dep.mId;
                }
                if (!this.mPriorityDependencies.isEmpty()) {
                    LOG.info("New computed priority dependency list " + this.mPriorityDependencies);
                }
            }
            if (this.mPriorityDependencies.isEmpty() && earliestDepId != -1) {
                this.mPriorityDependencies.add(earliestDepId);
                LOG.info("Priority dependency list by earliest creation time: " + this.mPriorityDependencies);
            }
            ArrayList<Integer> ret = new ArrayList<Integer>(this.mPriorityDependencies.size());
            ret.addAll(this.mPriorityDependencies);
            return ret;
        }
    }

    public int getRawTableId(TachyonURI path) throws InvalidPathException, TableDoesNotExistException {
        int id;
        Inode inode = this.getInode(path);
        if (inode == null) {
            throw new TableDoesNotExistException(path.toString());
        }
        if (inode.isDirectory() && this.mRawTables.exist(id = inode.getId())) {
            return id;
        }
        return -1;
    }

    public long getStarttimeMs() {
        return this.mStartTimeMs;
    }

    public long getUnderFsCapacityBytes() throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(CommonConf.get().UNDERFS_DATA_FOLDER);
        return ufs.getSpace(CommonConf.get().UNDERFS_DATA_FOLDER, UnderFileSystem.SpaceType.SPACE_TOTAL);
    }

    public long getUnderFsFreeBytes() throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(CommonConf.get().UNDERFS_DATA_FOLDER);
        return ufs.getSpace(CommonConf.get().UNDERFS_DATA_FOLDER, UnderFileSystem.SpaceType.SPACE_FREE);
    }

    public long getUnderFsUsedBytes() throws IOException {
        UnderFileSystem ufs = UnderFileSystem.get(CommonConf.get().UNDERFS_DATA_FOLDER);
        return ufs.getSpace(CommonConf.get().UNDERFS_DATA_FOLDER, UnderFileSystem.SpaceType.SPACE_USED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getUsedBytes() {
        long ret = 0L;
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            for (MasterWorkerInfo worker : this.mWorkers.values()) {
                ret += worker.getUsedBytes();
            }
        }
        return ret;
    }

    public List<String> getWhiteList() {
        return this.mWhitelist.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetAddress getWorker(boolean random, String host) throws UnknownHostException {
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            if (this.mWorkerAddressToId.isEmpty()) {
                return null;
            }
            if (random) {
                int index = new Random(this.mWorkerAddressToId.size()).nextInt(this.mWorkerAddressToId.size());
                for (NetAddress address : this.mWorkerAddressToId.keySet()) {
                    if (index == 0) {
                        LOG.debug("getRandomWorker: {}", (Object)address);
                        return address;
                    }
                    --index;
                }
                Iterator<NetAddress> i$ = this.mWorkerAddressToId.keySet().iterator();
                if (i$.hasNext()) {
                    NetAddress address;
                    address = i$.next();
                    LOG.debug("getRandomWorker: {}", (Object)address);
                    return address;
                }
            } else {
                for (NetAddress address : this.mWorkerAddressToId.keySet()) {
                    InetAddress inetAddress = InetAddress.getByName(address.getMHost());
                    if (!inetAddress.getHostName().equals(host) && !inetAddress.getHostAddress().equals(host) && !inetAddress.getCanonicalHostName().equals(host)) continue;
                    LOG.debug("getLocalWorker: {}" + address);
                    return address;
                }
            }
        }
        LOG.info("getLocalWorker: no local worker on " + host);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getWorkerCount() {
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            return this.mWorkers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MasterWorkerInfo getWorkerInfo(long workerId) {
        MasterWorkerInfo ret = null;
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            ret = this.mWorkers.get(workerId);
            if (ret == null) {
                LOG.error("No worker: " + workerId);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ClientWorkerInfo> getWorkersInfo() {
        ArrayList<ClientWorkerInfo> ret = new ArrayList<ClientWorkerInfo>();
        Map<Long, MasterWorkerInfo> map = this.mWorkers;
        synchronized (map) {
            for (MasterWorkerInfo worker : this.mWorkers.values()) {
                ret.add(worker.generateClientWorkerInfo());
            }
        }
        return ret;
    }

    public List<ClientWorkerInfo> getLostWorkersInfo() {
        ArrayList<ClientWorkerInfo> ret = new ArrayList<ClientWorkerInfo>();
        for (MasterWorkerInfo worker : this.mLostWorkers) {
            ret.add(worker.generateClientWorkerInfo());
        }
        return ret;
    }

    public void init() throws IOException {
        this.mCheckpointInfo.updateEditTransactionCounter(this.mJournal.loadEditLog(this));
        this.mJournal.createImage(this);
        this.mJournal.createEditLog(this.mCheckpointInfo.getEditTransactionCounter());
        this.mHeartbeat = this.mExecutorService.submit(new HeartbeatThread("Master Heartbeat", new MasterInfoHeartbeatExecutor(), this.mMasterConf.HEARTBEAT_INTERVAL_MS));
        this.mRecompute = this.mExecutorService.submit(new RecomputationScheduler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> listFiles(TachyonURI path, boolean recursive) throws InvalidPathException, FileDoesNotExistException {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.getInode(path);
            if (inode == null) {
                throw new FileDoesNotExistException(path.toString());
            }
            if (inode.isFile()) {
                ret.add(inode.getId());
            } else if (recursive) {
                LinkedList<Inode> queue = new LinkedList<Inode>();
                queue.addAll(((InodeFolder)inode).getChildren());
                while (!queue.isEmpty()) {
                    Inode qinode = (Inode)queue.poll();
                    if (qinode.isDirectory()) {
                        queue.addAll(((InodeFolder)qinode).getChildren());
                        continue;
                    }
                    ret.add(qinode.getId());
                }
            } else {
                for (Inode child : ((InodeFolder)inode).getChildren()) {
                    ret.add(child.getId());
                }
            }
        }
        return ret;
    }

    public void loadImage(JsonParser parser, TachyonURI path) throws IOException {
        block10: while (true) {
            ImageElement ele;
            try {
                ele = (ImageElement)parser.readValueAs(ImageElement.class);
                LOG.debug("Read Element: {}", (Object)ele);
            }
            catch (IOException e) {
                if (e.getMessage().contains("end-of-input")) break;
                throw e;
            }
            switch (ele.mType) {
                case Version: {
                    if (ele.getInt("version") == 3) continue block10;
                    throw new IOException("Image " + path + " has journal version " + ele.getInt("version") + ". The system has version " + 3);
                }
                case Checkpoint: {
                    this.mInodeCounter.set(ele.getInt("inodeCounter"));
                    this.mCheckpointInfo.updateEditTransactionCounter(ele.getLong("editTransactionCounter"));
                    this.mCheckpointInfo.updateDependencyCounter(ele.getInt("dependencyCounter"));
                    break;
                }
                case Dependency: {
                    Dependency dep = Dependency.loadImage(ele);
                    this.mFileIdToDependency.put(dep.mId, dep);
                    if (!dep.hasCheckpointed()) {
                        this.mUncheckpointedDependencies.add(dep.mId);
                    }
                    Iterator<Integer> i$ = dep.mParentDependencies.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block10;
                        int parentDependencyId = i$.next();
                        this.mFileIdToDependency.get(parentDependencyId).addChildrenDependency(dep.mId);
                    }
                }
                case InodeFile: {
                    throw new IOException("Invalid element type " + ele);
                }
                case InodeFolder: {
                    InodeFolder inode = InodeFolder.loadImage(parser, ele);
                    this.addToInodeMap(inode, this.mFileIdToInodes);
                    this.recomputePinnedFiles(inode, (Optional<Boolean>)Optional.absent());
                    if (inode.getId() != 1) {
                        throw new IOException("Invalid element type " + ele);
                    }
                    this.mRoot = inode;
                    break;
                }
                case RawTable: {
                    this.mRawTables.loadImage(ele);
                    break;
                }
                default: {
                    throw new IOException("Invalid element type " + ele);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TachyonURI> ls(TachyonURI path, boolean recursive) throws InvalidPathException, FileDoesNotExistException {
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.getInode(path);
            if (inode == null) {
                throw new FileDoesNotExistException(path.toString());
            }
            return this._ls(inode, path, recursive);
        }
    }

    public boolean mkdirs(TachyonURI path, boolean recursive) throws FileAlreadyExistException, InvalidPathException, TachyonException {
        try {
            return this.createFile(recursive, path, true, 0L) > 0;
        }
        catch (BlockInfoException e) {
            throw new FileAlreadyExistException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void opAddBlock(int fileId, int blockIndex, long blockLength, long opTimeMs) throws FileDoesNotExistException, BlockInfoException {
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.mFileIdToInodes.get(fileId);
            if (inode == null) {
                throw new FileDoesNotExistException("File " + fileId + " does not exist.");
            }
            if (inode.isDirectory()) {
                throw new FileDoesNotExistException("File " + fileId + " is a folder.");
            }
            this.addBlock((InodeFile)inode, new BlockInfo((InodeFile)inode, blockIndex, blockLength), opTimeMs);
        }
    }

    private void recomputePinnedFiles(Inode inode, Optional<Boolean> setPinState) {
        long opTimeMs = System.currentTimeMillis();
        this._recomputePinnedFiles(inode, setPinState, opTimeMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long registerWorker(NetAddress workerNetAddress, long totalBytes, long usedBytes, Map<Long, List<Long>> currentBlockIds) throws BlockInfoException {
        long id = 0L;
        NetAddress workerAddress = new NetAddress(workerNetAddress);
        LOG.info("registerWorker(): WorkerNetAddress: " + workerAddress);
        Object object = this.mWorkers;
        synchronized (object) {
            MasterWorkerInfo tWorkerInfo;
            if (this.mWorkerAddressToId.containsKey(workerAddress)) {
                id = this.mWorkerAddressToId.get(workerAddress);
                this.mWorkerAddressToId.remove(workerAddress);
                LOG.warn("The worker " + workerAddress + " already exists as id " + id + ".");
            }
            if (id != 0L && this.mWorkers.containsKey(id)) {
                tWorkerInfo = this.mWorkers.get(id);
                this.mWorkers.remove(id);
                this.mLostWorkers.add(tWorkerInfo);
                LOG.warn("The worker with id " + id + " has been removed.");
            }
            id = this.mStartTimeNSPrefix + (long)this.mWorkerCounter.incrementAndGet();
            tWorkerInfo = new MasterWorkerInfo(id, workerAddress, totalBytes);
            tWorkerInfo.updateUsedBytes(usedBytes);
            for (List<Long> blockIds : currentBlockIds.values()) {
                tWorkerInfo.updateBlocks(true, blockIds);
            }
            tWorkerInfo.updateLastUpdatedTimeMs();
            this.mWorkers.put(id, tWorkerInfo);
            this.mWorkerAddressToId.put(workerAddress, id);
            LOG.info("registerWorker(): " + tWorkerInfo);
        }
        object = this.mRootLock;
        synchronized (object) {
            for (Map.Entry<Long, List<Long>> blockIds : currentBlockIds.entrySet()) {
                long storageDirId = blockIds.getKey();
                for (long blockId : blockIds.getValue()) {
                    int fileId = BlockInfo.computeInodeId(blockId);
                    int blockIndex = BlockInfo.computeBlockIndex(blockId);
                    Inode inode = this.mFileIdToInodes.get(fileId);
                    if (inode != null && inode.isFile()) {
                        ((InodeFile)inode).addLocation(blockIndex, id, workerAddress, storageDirId);
                        continue;
                    }
                    LOG.warn("registerWorker failed to add fileId " + fileId + " blockIndex " + blockIndex);
                }
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(int fileId, TachyonURI dstPath) throws FileDoesNotExistException, InvalidPathException {
        long opTimeMs = System.currentTimeMillis();
        Object object = this.mRootLock;
        synchronized (object) {
            boolean ret = this._rename(fileId, dstPath, opTimeMs);
            this.mJournal.getEditLog().rename(fileId, dstPath, opTimeMs);
            this.mJournal.getEditLog().flush();
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rename(TachyonURI srcPath, TachyonURI dstPath) throws FileDoesNotExistException, InvalidPathException {
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.getInode(srcPath);
            if (inode == null) {
                throw new FileDoesNotExistException("Failed to rename: " + srcPath + " does not exist");
            }
            return this.rename(inode.getId(), dstPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportLostFile(int fileId) {
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.mFileIdToInodes.get(fileId);
            if (inode == null) {
                LOG.warn("Tachyon does not have file " + fileId);
            } else if (inode.isDirectory()) {
                LOG.warn("Reported file is a directory " + inode);
            } else {
                InodeFile iFile = (InodeFile)inode;
                int depId = iFile.getDependencyId();
                Map<Integer, Dependency> map = this.mFileIdToDependency;
                synchronized (map) {
                    this.mLostFiles.add(fileId);
                    if (depId == -1) {
                        LOG.error("There is no dependency info for " + iFile + " . No recovery on that");
                    } else {
                        LOG.info("Reported file loss. Tachyon will recompute it: " + iFile.toString());
                        Dependency dep = this.mFileIdToDependency.get(depId);
                        dep.addLostFile(fileId);
                        this.mMustRecomputedDpendencies.add(depId);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFilesInDependency(int depId) {
        Map<Integer, Dependency> map = this.mFileIdToDependency;
        synchronized (map) {
            if (this.mFileIdToDependency.containsKey(depId)) {
                Dependency dep = this.mFileIdToDependency.get(depId);
                LOG.info("Request files in dependency " + dep);
                if (dep.hasLostFile()) {
                    this.mMustRecomputedDpendencies.add(depId);
                }
            } else {
                LOG.error("There is no dependency with id " + depId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPinned(int fileId, boolean pinned) throws FileDoesNotExistException {
        long opTimeMs = System.currentTimeMillis();
        Object object = this.mRootLock;
        synchronized (object) {
            this._setPinned(fileId, pinned, opTimeMs);
            this.mJournal.getEditLog().setPinned(fileId, pinned, opTimeMs);
            this.mJournal.getEditLog().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean freepath(int fileId, boolean recursive) throws TachyonException {
        LOG.info("free(" + fileId + ")");
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.mFileIdToInodes.get(fileId);
            if (inode == null) {
                LOG.error("File " + fileId + " does not exist");
                return true;
            }
            if (inode.isDirectory() && !recursive && ((InodeFolder)inode).getNumberOfChildren() > 0) {
                return false;
            }
            if (inode.getId() == this.mRoot.getId()) {
                return false;
            }
            ArrayList<Inode> freeInodes = new ArrayList<Inode>();
            freeInodes.add(inode);
            if (inode.isDirectory()) {
                freeInodes.addAll(this.getInodeChildrenRecursive((InodeFolder)inode));
            }
            for (int i = freeInodes.size() - 1; i >= 0; --i) {
                Inode freeInode = (Inode)freeInodes.get(i);
                if (!freeInode.isFile()) continue;
                List<Pair<Long, Long>> blockIdWorkerIdList = ((InodeFile)freeInode).getBlockIdWorkerIdPairs();
                Map<Long, MasterWorkerInfo> map = this.mWorkers;
                synchronized (map) {
                    for (Pair<Long, Long> blockIdWorkerId : blockIdWorkerIdList) {
                        MasterWorkerInfo workerInfo = this.mWorkers.get(blockIdWorkerId.getSecond());
                        if (workerInfo == null) continue;
                        workerInfo.updateToRemovedBlock(true, blockIdWorkerId.getFirst());
                    }
                    continue;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean freepath(TachyonURI path, boolean recursive) throws TachyonException {
        LOG.info("free(" + path + ")");
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = null;
            try {
                inode = this.getInode(path);
            }
            catch (InvalidPathException e) {
                return false;
            }
            if (inode == null) {
                return true;
            }
            return this.freepath(inode.getId(), recursive);
        }
    }

    public void stop() {
        if (this.mHeartbeat != null) {
            this.mHeartbeat.cancel(true);
        }
        if (this.mRecompute != null) {
            this.mRecompute.cancel(true);
        }
    }

    private boolean traversalSucceeded(Pair<Inode, Integer> inodeTraversal) {
        return inodeTraversal.getSecond() == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Inode, Integer> traverseToInode(String[] pathNames) throws InvalidPathException {
        Object object = this.mRootLock;
        synchronized (object) {
            if (pathNames == null || pathNames.length == 0) {
                throw new InvalidPathException("passed-in pathNames is null or empty");
            }
            if (pathNames.length == 1) {
                if (pathNames[0].equals("")) {
                    return new Pair<Inode, Integer>(this.mRoot, -1);
                }
                String msg = "File name starts with " + pathNames[0];
                LOG.info("InvalidPathException: " + msg);
                throw new InvalidPathException(msg);
            }
            Pair<Inode, Integer> ret = new Pair<Inode, Integer>(this.mRoot, -1);
            for (int k = 1; k < pathNames.length; ++k) {
                Inode next = ret.getFirst().getChild(pathNames[k]);
                if (next == null) {
                    ret.setSecond(k);
                    break;
                }
                ret.setFirst(next);
                if (ret.getFirst().isDirectory()) continue;
                if (k == pathNames.length - 1) break;
                String msg = "Traversal failed. Component " + k + "(" + ret.getFirst().getName() + ") is a file";
                LOG.info("InvalidPathException: " + msg);
                throw new InvalidPathException(msg);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRawTableMetadata(int tableId, ByteBuffer metadata) throws TableDoesNotExistException, TachyonException {
        Object object = this.mRootLock;
        synchronized (object) {
            Inode inode = this.mFileIdToInodes.get(tableId);
            if (inode == null || !inode.isDirectory() || !this.mRawTables.exist(tableId)) {
                throw new TableDoesNotExistException("Table " + tableId + " does not exist.");
            }
            this.mRawTables.updateMetadata(tableId, metadata);
            this.mJournal.getEditLog().updateRawTableMetadata(tableId, metadata);
            this.mJournal.getEditLog().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command workerHeartbeat(long workerId, long usedBytes, List<Long> removedBlockIds, Map<Long, List<Long>> addedBlockIds) throws BlockInfoException {
        LOG.debug("WorkerId: {}", (Object)workerId);
        Object object = this.mRootLock;
        synchronized (object) {
            Map<Long, MasterWorkerInfo> map = this.mWorkers;
            synchronized (map) {
                MasterWorkerInfo tWorkerInfo = this.mWorkers.get(workerId);
                if (tWorkerInfo == null) {
                    LOG.info("worker_heartbeat(): Does not contain worker with ID " + workerId + " . Send command to let it re-register.");
                    return new Command(CommandType.Register, new ArrayList<Long>());
                }
                tWorkerInfo.updateUsedBytes(usedBytes);
                tWorkerInfo.updateBlocks(false, removedBlockIds);
                tWorkerInfo.updateToRemovedBlocks(false, removedBlockIds);
                tWorkerInfo.updateLastUpdatedTimeMs();
                Iterator<Object> i$ = removedBlockIds.iterator();
                while (i$.hasNext()) {
                    long blockId = i$.next();
                    int fileId = BlockInfo.computeInodeId(blockId);
                    int blockIndex = BlockInfo.computeBlockIndex(blockId);
                    Inode inode = this.mFileIdToInodes.get(fileId);
                    if (inode == null) {
                        LOG.error("File " + fileId + " does not exist");
                        continue;
                    }
                    if (!inode.isFile()) continue;
                    ((InodeFile)inode).removeLocation(blockIndex, workerId);
                    LOG.debug("File {} with block {} was evicted from worker {} ", new Object[]{fileId, blockIndex, workerId});
                }
                for (Map.Entry entry : addedBlockIds.entrySet()) {
                    long storageDirId = (Long)entry.getKey();
                    Iterator i$2 = ((List)entry.getValue()).iterator();
                    while (i$2.hasNext()) {
                        long blockId = (Long)i$2.next();
                        int fileId = BlockInfo.computeInodeId(blockId);
                        int blockIndex = BlockInfo.computeBlockIndex(blockId);
                        Inode inode = this.mFileIdToInodes.get(fileId);
                        if (inode == null) {
                            LOG.error("File " + fileId + " does not exist");
                            continue;
                        }
                        if (!inode.isFile()) continue;
                        List<BlockInfo> blockInfoList = ((InodeFile)inode).getBlockList();
                        NetAddress workerAddress = this.mWorkers.get(workerId).getAddress();
                        if (blockInfoList.size() <= blockIndex) {
                            throw new BlockInfoException("BlockInfo not found! blockIndex:" + blockIndex);
                        }
                        BlockInfo blockInfo = blockInfoList.get(blockIndex);
                        blockInfo.addLocation(workerId, workerAddress, storageDirId);
                    }
                }
                List<Long> toRemovedBlocks = tWorkerInfo.getToRemovedBlocks();
                if (toRemovedBlocks.size() != 0) {
                    return new Command(CommandType.Free, toRemovedBlocks);
                }
            }
        }
        return new Command(CommandType.Nothing, new ArrayList<Long>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeImage(ObjectWriter objWriter, DataOutputStream dos) throws IOException {
        ImageElement ele = new ImageElement(ImageElementType.Version).withParameter("version", 3);
        this.writeElement(objWriter, dos, ele);
        Object object = this.mRootLock;
        synchronized (object) {
            Map<Integer, Dependency> map = this.mFileIdToDependency;
            synchronized (map) {
                for (Dependency dep : this.mFileIdToDependency.values()) {
                    dep.writeImage(objWriter, dos);
                }
            }
            this.mRoot.writeImage(objWriter, dos);
            this.mRawTables.writeImage(objWriter, dos);
            ele = new ImageElement(ImageElementType.Checkpoint).withParameter("inodeCounter", this.mInodeCounter.get()).withParameter("editTransactionCounter", this.mCheckpointInfo.getEditTransactionCounter()).withParameter("dependencyCounter", this.mCheckpointInfo.getDependencyCounter());
            this.writeElement(objWriter, dos, ele);
        }
    }

    public class RecomputationScheduler
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread.currentThread().setName("recompute-scheduler");
            while (!Thread.currentThread().isInterrupted()) {
                boolean hasLostFiles = false;
                boolean launched = false;
                ArrayList<String> cmds = new ArrayList<String>();
                Object object = MasterInfo.this.mRootLock;
                synchronized (object) {
                    Map map = MasterInfo.this.mFileIdToDependency;
                    synchronized (map) {
                        if (!MasterInfo.this.mMustRecomputedDpendencies.isEmpty()) {
                            Dependency dep;
                            ArrayList<Integer> recomputeList = new ArrayList<Integer>();
                            LinkedList<Integer> checkQueue = new LinkedList<Integer>();
                            checkQueue.addAll(MasterInfo.this.mMustRecomputedDpendencies);
                            while (!checkQueue.isEmpty()) {
                                int depId = (Integer)checkQueue.poll();
                                dep = (Dependency)MasterInfo.this.mFileIdToDependency.get(depId);
                                boolean canLaunch = true;
                                for (int k = 0; k < dep.mParentFiles.size(); ++k) {
                                    int tDepId;
                                    int fildId = dep.mParentFiles.get(k);
                                    if (!MasterInfo.this.mLostFiles.contains(fildId)) continue;
                                    canLaunch = false;
                                    InodeFile iFile = (InodeFile)MasterInfo.this.mFileIdToInodes.get(fildId);
                                    if (MasterInfo.this.mBeingRecomputedFiles.contains(fildId) || (tDepId = iFile.getDependencyId()) == -1 || MasterInfo.this.mMustRecomputedDpendencies.contains(tDepId)) continue;
                                    MasterInfo.this.mMustRecomputedDpendencies.add(tDepId);
                                    checkQueue.add(tDepId);
                                }
                                if (!canLaunch) continue;
                                recomputeList.add(depId);
                            }
                            hasLostFiles = !MasterInfo.this.mMustRecomputedDpendencies.isEmpty();
                            launched = recomputeList.size() > 0;
                            for (int k = 0; k < recomputeList.size(); ++k) {
                                MasterInfo.this.mMustRecomputedDpendencies.remove(recomputeList.get(k));
                                dep = (Dependency)MasterInfo.this.mFileIdToDependency.get(recomputeList.get(k));
                                MasterInfo.this.mBeingRecomputedFiles.addAll(dep.getLostFiles());
                                cmds.add(dep.getCommand());
                            }
                        }
                    }
                }
                for (String cmd : cmds) {
                    String filePath = CommonConf.get().TACHYON_HOME + "/logs/rerun-" + MasterInfo.this.mRerunCounter.incrementAndGet();
                    Thread thread = new Thread(new RecomputeCommand(cmd, filePath));
                    thread.setName("recompute-command-" + cmd);
                    thread.start();
                }
                if (launched) continue;
                if (hasLostFiles) {
                    LOG.info("HasLostFiles, but no job can be launched.");
                }
                CommonUtils.sleepMs(LOG, 1000L);
            }
        }
    }

    public class MasterInfoHeartbeatExecutor
    implements HeartbeatExecutor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void heartbeat() {
            LOG.debug("System status checking.");
            HashSet lostWorkers = new HashSet();
            Map map = MasterInfo.this.mWorkers;
            synchronized (map) {
                for (Map.Entry worker : MasterInfo.this.mWorkers.entrySet()) {
                    if (CommonUtils.getCurrentMs() - ((MasterWorkerInfo)worker.getValue()).getLastUpdatedTimeMs() <= (long)((MasterInfo)MasterInfo.this).mMasterConf.WORKER_TIMEOUT_MS) continue;
                    LOG.error("The worker " + worker.getValue() + " got timed out!");
                    MasterInfo.this.mLostWorkers.add(worker.getValue());
                    lostWorkers.add(worker.getKey());
                }
                Iterator i$ = lostWorkers.iterator();
                while (i$.hasNext()) {
                    long workerId = (Long)((Object)i$.next());
                    MasterWorkerInfo workerInfo = (MasterWorkerInfo)MasterInfo.this.mWorkers.get(workerId);
                    MasterInfo.this.mWorkerAddressToId.remove(workerInfo.getAddress());
                    MasterInfo.this.mWorkers.remove(workerId);
                }
            }
            boolean hadFailedWorker = false;
            while (MasterInfo.this.mLostWorkers.size() != 0) {
                hadFailedWorker = true;
                MasterWorkerInfo worker = (MasterWorkerInfo)MasterInfo.this.mLostWorkers.poll();
                Object object = MasterInfo.this.mRootLock;
                synchronized (object) {
                    Map map2 = MasterInfo.this.mFileIdToDependency;
                    synchronized (map2) {
                        try {
                            for (long blockId : worker.getBlocks()) {
                                int fileId = BlockInfo.computeInodeId(blockId);
                                InodeFile tFile = (InodeFile)MasterInfo.this.mFileIdToInodes.get(fileId);
                                if (tFile == null) continue;
                                int blockIndex = BlockInfo.computeBlockIndex(blockId);
                                tFile.removeLocation(blockIndex, worker.getId());
                                if (!tFile.hasCheckpointed() && tFile.getBlockLocations(blockIndex).size() == 0) {
                                    LOG.info("Block " + blockId + " got lost from worker " + worker.getId() + " .");
                                    int depId = tFile.getDependencyId();
                                    if (depId == -1) {
                                        LOG.error("Permanent Data loss: " + tFile);
                                        continue;
                                    }
                                    MasterInfo.this.mLostFiles.add(tFile.getId());
                                    Dependency dep = (Dependency)MasterInfo.this.mFileIdToDependency.get(depId);
                                    dep.addLostFile(tFile.getId());
                                    LOG.info("File " + tFile.getId() + " got lost from worker " + worker.getId() + " . Trying to recompute it using dependency " + dep.mId);
                                    if (MasterInfo.this.getPath(tFile).toString().startsWith(((MasterInfo)MasterInfo.this).mMasterConf.TEMPORARY_FOLDER)) continue;
                                    MasterInfo.this.mMustRecomputedDpendencies.add(depId);
                                    continue;
                                }
                                LOG.info("Block " + blockId + " only lost an in memory copy from worker " + worker.getId());
                            }
                        }
                        catch (BlockInfoException e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            if (hadFailedWorker) {
                LOG.warn("Restarting failed workers.");
                try {
                    Runtime.getRuntime().exec(CommonConf.get().TACHYON_HOME + "/bin/tachyon-start.sh restart_workers");
                }
                catch (IOException e) {
                    LOG.error(e.getMessage());
                }
            }
        }
    }
}

