/*
 * Decompiled with CFR 0.152.
 */
package tachyon.master;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.LeaderSelectorClient;
import tachyon.UnderFileSystem;
import tachyon.UnderFileSystemHdfs;
import tachyon.Version;
import tachyon.conf.CommonConf;
import tachyon.conf.MasterConf;
import tachyon.master.EditLogProcessor;
import tachyon.master.Journal;
import tachyon.master.MasterInfo;
import tachyon.master.MasterServiceHandler;
import tachyon.org.apache.thrift.server.TServer;
import tachyon.org.apache.thrift.server.TThreadedSelectorServer;
import tachyon.org.apache.thrift.transport.TNonblockingServerSocket;
import tachyon.org.apache.thrift.transport.TTransportException;
import tachyon.thrift.MasterService;
import tachyon.util.CommonUtils;
import tachyon.util.NetworkUtils;
import tachyon.util.ThreadFactoryUtils;
import tachyon.web.UIWebServer;

public class TachyonMaster {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private boolean mIsStarted;
    private MasterInfo mMasterInfo;
    private InetSocketAddress mMasterAddress;
    private UIWebServer mWebServer;
    private TNonblockingServerSocket mServerTNonblockingServerSocket;
    private TServer mMasterServiceServer;
    private MasterServiceHandler mMasterServiceHandler;
    private Journal mJournal;
    private EditLogProcessor mEditLogProcessor;
    private int mWebPort;
    private int mSelectorThreads;
    private int mAcceptQueueSizePerThread;
    private int mWorkerThreads;
    private boolean mZookeeperMode = false;
    private final ExecutorService mExecutorService = Executors.newFixedThreadPool(2, ThreadFactoryUtils.daemon("heartbeat-master-%d"));
    private LeaderSelectorClient mLeaderSelectorClient = null;
    private final int mPort;

    public static void main(String[] args) {
        if (args.length != 0) {
            LOG.info("java -cp target/tachyon-" + Version.VERSION + "-jar-with-dependencies.jar " + "tachyon.Master");
            System.exit(-1);
        }
        MasterConf mConf = MasterConf.get();
        TachyonMaster master = new TachyonMaster(new InetSocketAddress(mConf.HOSTNAME, mConf.PORT), mConf.WEB_PORT, mConf.SELECTOR_THREADS, mConf.QUEUE_SIZE_PER_SELECTOR, mConf.SERVER_THREADS);
        master.start();
    }

    public TachyonMaster(InetSocketAddress address, int webPort, int selectorThreads, int acceptQueueSizePerThreads, int workerThreads) {
        CommonConf.assertValidPort(address);
        CommonConf.assertValidPort(webPort);
        if (CommonConf.get().USE_ZOOKEEPER) {
            this.mZookeeperMode = true;
        }
        this.mIsStarted = false;
        this.mWebPort = webPort;
        this.mSelectorThreads = selectorThreads;
        this.mAcceptQueueSizePerThread = acceptQueueSizePerThreads;
        this.mWorkerThreads = workerThreads;
        try {
            this.mServerTNonblockingServerSocket = new TNonblockingServerSocket(address);
            this.mPort = NetworkUtils.getPort(this.mServerTNonblockingServerSocket);
            this.mMasterAddress = new InetSocketAddress(NetworkUtils.getFqdnHost(address), this.mPort);
            String journalFolder = MasterConf.get().JOURNAL_FOLDER;
            Preconditions.checkState((boolean)this.isFormatted(journalFolder, MasterConf.get().FORMAT_FILE_PREFIX), (Object)("Tachyon was not formatted! The journal folder is " + journalFolder));
            this.mJournal = new Journal(journalFolder, "image.data", "log.data");
            this.mMasterInfo = new MasterInfo(this.mMasterAddress, this.mJournal, this.mExecutorService);
            if (this.mZookeeperMode) {
                CommonConf conf = CommonConf.get();
                String name = NetworkUtils.getFqdnHost(this.mMasterAddress) + ":" + this.mMasterAddress.getPort();
                this.mLeaderSelectorClient = new LeaderSelectorClient(conf.ZOOKEEPER_ADDRESS, conf.ZOOKEEPER_ELECTION_PATH, conf.ZOOKEEPER_LEADER_PATH, name);
                this.mEditLogProcessor = new EditLogProcessor(this.mJournal, journalFolder, this.mMasterInfo);
                Thread logProcessor = new Thread(this.mEditLogProcessor);
                logProcessor.start();
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    MasterInfo getMasterInfo() {
        return this.mMasterInfo;
    }

    int getMetaPort() {
        return this.mPort;
    }

    private boolean isFormatted(String folder, String path) throws IOException {
        UnderFileSystem ufs;
        String[] files;
        if (!folder.endsWith("/")) {
            folder = folder + "/";
        }
        if ((files = (ufs = UnderFileSystem.get(folder)).list(folder)) == null) {
            return false;
        }
        for (String file : files) {
            if (!file.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    boolean isStarted() {
        return this.mIsStarted;
    }

    boolean isZookeeperMode() {
        return this.mZookeeperMode;
    }

    private void login() throws IOException {
        MasterConf mConf = MasterConf.get();
        if (mConf.KEYTAB == null || mConf.PRINCIPAL == null) {
            return;
        }
        UnderFileSystem ufs = UnderFileSystem.get(CommonConf.get().UNDERFS_ADDRESS);
        if (ufs instanceof UnderFileSystemHdfs) {
            ((UnderFileSystemHdfs)ufs).login(mConf.KEYTAB_KEY, mConf.KEYTAB, mConf.PRINCIPAL_KEY, mConf.PRINCIPAL, NetworkUtils.getFqdnHost(this.mMasterAddress));
        }
    }

    private void setup() throws IOException, TTransportException {
        this.login();
        if (this.mZookeeperMode) {
            this.mEditLogProcessor.stop();
        }
        this.mMasterInfo.init();
        this.mWebServer = new UIWebServer("Tachyon Master Server", new InetSocketAddress(NetworkUtils.getFqdnHost(this.mMasterAddress), this.mWebPort), this.mMasterInfo);
        this.mMasterServiceHandler = new MasterServiceHandler(this.mMasterInfo);
        MasterService.Processor<MasterServiceHandler> masterServiceProcessor = new MasterService.Processor<MasterServiceHandler>(this.mMasterServiceHandler);
        this.mMasterServiceServer = new TThreadedSelectorServer(((TThreadedSelectorServer.Args)new TThreadedSelectorServer.Args(this.mServerTNonblockingServerSocket).processor(masterServiceProcessor)).selectorThreads(this.mSelectorThreads).acceptQueueSizePerThread(this.mAcceptQueueSizePerThread).workerThreads(this.mWorkerThreads));
        this.mIsStarted = true;
    }

    public void start() {
        if (this.mZookeeperMode) {
            try {
                this.mLeaderSelectorClient.start();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
            Thread currentThread = Thread.currentThread();
            this.mLeaderSelectorClient.setCurrentMasterThread(currentThread);
            boolean running = false;
            while (true) {
                if (this.mLeaderSelectorClient.isLeader()) {
                    if (!running) {
                        running = true;
                        try {
                            this.setup();
                        }
                        catch (IOException e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                            throw Throwables.propagate((Throwable)e);
                        }
                        catch (TTransportException e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                            throw Throwables.propagate((Throwable)e);
                        }
                        this.mWebServer.startWebServer();
                        LOG.info("The master (leader) server started @ " + this.mMasterAddress);
                        this.mMasterServiceServer.serve();
                        LOG.info("The master (previous leader) server ended @ " + this.mMasterAddress);
                        this.mJournal.close();
                    }
                } else if (running) {
                    this.mMasterServiceServer.stop();
                    running = false;
                }
                CommonUtils.sleepMs(LOG, 100L);
            }
        }
        try {
            this.setup();
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        catch (TTransportException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
        this.mWebServer.startWebServer();
        LOG.info("Tachyon Master version " + Version.VERSION + " started @ " + this.mMasterAddress);
        this.mMasterServiceServer.serve();
        LOG.info("Tachyon Master version " + Version.VERSION + " ended @ " + this.mMasterAddress);
    }

    public void stop() throws Exception {
        if (this.mIsStarted) {
            this.mWebServer.shutdownWebServer();
            this.mMasterInfo.stop();
            this.mMasterServiceServer.stop();
            this.mServerTNonblockingServerSocket.close();
            this.mExecutorService.shutdown();
            this.mIsStarted = false;
        }
        if (this.mZookeeperMode) {
            if (this.mLeaderSelectorClient != null) {
                this.mLeaderSelectorClient.close();
            }
            if (this.mEditLogProcessor != null) {
                this.mEditLogProcessor.stop();
            }
        }
    }
}

