/*
 * Decompiled with CFR 0.152.
 */
package tachyon.util;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.Pair;
import tachyon.PrefixList;
import tachyon.TachyonURI;
import tachyon.UnderFileSystem;
import tachyon.Version;
import tachyon.client.TachyonFS;
import tachyon.util.CommonUtils;
import tachyon.util.NetworkUtils;

public class UfsUtils {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);

    private static TachyonURI buildTFSPath(TachyonURI tfsRootPath, TachyonURI ufsRootPath, TachyonURI path) {
        String filePath = path.getPath().substring(ufsRootPath.getPath().length());
        if (filePath.isEmpty()) {
            filePath = path.getPath().substring(ufsRootPath.getPath().lastIndexOf("/") + 1);
        }
        return new TachyonURI(CommonUtils.concat(tfsRootPath, filePath));
    }

    public static void loadUfs(TachyonURI tfsAddrRootPath, TachyonURI ufsAddrRootPath, String excludePaths) throws IOException {
        TachyonFS tfs = TachyonFS.get(tfsAddrRootPath);
        PrefixList excludePathPrefix = new PrefixList(excludePaths, ";");
        UfsUtils.loadUnderFs(tfs, tfsAddrRootPath, ufsAddrRootPath, excludePathPrefix);
    }

    public static void loadUnderFs(TachyonFS tfs, TachyonURI tachyonPath, TachyonURI ufsAddrRootPath, PrefixList excludePathPrefix) throws IOException {
        LOG.info("Loading to " + tachyonPath + " " + ufsAddrRootPath + " " + excludePathPrefix);
        try {
            ufsAddrRootPath = NetworkUtils.replaceHostName(ufsAddrRootPath);
            tachyonPath = NetworkUtils.replaceHostName(tachyonPath);
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to resolve hostname", (Throwable)e);
            throw new IOException(e);
        }
        Pair<String, String> ufsPair = UnderFileSystem.parse(ufsAddrRootPath);
        String ufsAddress = ufsPair.getFirst();
        String ufsRootPath = ufsPair.getSecond();
        if (!tfs.exist(tachyonPath)) {
            tfs.mkdir(tachyonPath);
        }
        UnderFileSystem ufs = UnderFileSystem.get(ufsAddress);
        LinkedList<TachyonURI> ufsPathQueue = new LinkedList<TachyonURI>();
        if (excludePathPrefix.outList(ufsRootPath)) {
            ufsPathQueue.add(ufsAddrRootPath);
        }
        while (!ufsPathQueue.isEmpty()) {
            TachyonURI tfsPath;
            TachyonURI ufsPath = (TachyonURI)ufsPathQueue.poll();
            LOG.info("Loading: " + ufsPath);
            if (ufs.isFile(ufsPath.toString())) {
                TachyonURI tfsPath2 = UfsUtils.buildTFSPath(tachyonPath, ufsAddrRootPath, ufsPath);
                if (tfs.exist(tfsPath2)) {
                    LOG.info("File " + tfsPath2 + " already exists in Tachyon.");
                    continue;
                }
                int fileId = tfs.createFile(tfsPath2, ufsPath);
                if (fileId == -1) {
                    LOG.info("Failed to create tachyon file: " + tfsPath2);
                    continue;
                }
                LOG.info("Create tachyon file " + tfsPath2 + " with file id " + fileId + " and " + "checkpoint location " + ufsPath);
                continue;
            }
            String[] files = ufs.list(ufsPath.toString());
            if (files != null) {
                for (String filePath : files) {
                    if (filePath.isEmpty()) continue;
                    LOG.info("Get: " + filePath);
                    String aPath = CommonUtils.concat(ufsPath, filePath);
                    String checkPath = aPath.substring(ufsAddrRootPath.toString().length());
                    if (checkPath.startsWith("/")) {
                        checkPath = checkPath.substring("/".length());
                    }
                    if (excludePathPrefix.inList(checkPath)) {
                        LOG.info("excluded: " + checkPath);
                        continue;
                    }
                    ufsPathQueue.add(new TachyonURI(aPath));
                }
            }
            if (tfs.exist(tfsPath = new TachyonURI(CommonUtils.concat(tachyonPath, ufsPath.getPath().substring(ufsAddrRootPath.getPath().length()))))) continue;
            tfs.mkdir(tfsPath);
        }
    }

    public static void main(String[] args) {
        if (args.length != 2 && args.length != 3) {
            UfsUtils.printUsage();
            System.exit(-1);
        }
        String exList = args.length == 3 ? args[2] : "";
        try {
            UfsUtils.loadUfs(new TachyonURI(args[0]), new TachyonURI(args[1]), exList);
        }
        catch (Exception e) {
            e.printStackTrace();
            UfsUtils.printUsage();
            System.exit(-1);
        }
        System.exit(0);
    }

    public static void printUsage() {
        String cmd = "java -cp target/tachyon-" + Version.VERSION + "-jar-with-dependencies.jar " + "tachyon.util.UfsUtils ";
        System.out.println("Usage: " + cmd + "<TachyonPath> <UfsPath> " + "[<Optional ExcludePathPrefix, separated by ;>]");
        System.out.println("Example: " + cmd + "tachyon://127.0.0.1:19998/a hdfs://localhost:9000/b c");
        System.out.println("Example: " + cmd + "tachyon://127.0.0.1:19998/a file:///b c");
        System.out.println("Example: " + cmd + "tachyon://127.0.0.1:19998/a /b c");
        System.out.print("In the TFS, all files under local FS /b will be registered under /a, ");
        System.out.println("except for those with prefix c");
    }
}

