/*
 * Decompiled with CFR 0.152.
 */
package tachyon.web;

import com.google.common.base.Throwables;
import java.io.File;
import java.net.InetSocketAddress;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.conf.CommonConf;
import tachyon.conf.MasterConf;
import tachyon.master.MasterInfo;
import tachyon.web.WebInterfaceBrowseServlet;
import tachyon.web.WebInterfaceConfigurationServlet;
import tachyon.web.WebInterfaceDependencyServlet;
import tachyon.web.WebInterfaceDownloadServlet;
import tachyon.web.WebInterfaceGeneralServlet;
import tachyon.web.WebInterfaceMemoryServlet;
import tachyon.web.WebInterfaceWorkersServlet;

public class UIWebServer {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private Server mServer;
    private String mServerName;
    private InetSocketAddress mAddress;

    public UIWebServer(String serverName, InetSocketAddress address, MasterInfo masterInfo) {
        this.mAddress = address;
        this.mServerName = serverName;
        this.mServer = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(address.getPort());
        connector.setAcceptors(MasterConf.get().WEB_THREAD_COUNT);
        this.mServer.setConnectors(new Connector[]{connector});
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(MasterConf.get().WEB_THREAD_COUNT * 2 + 1);
        threadPool.setMaxThreads(MasterConf.get().WEB_THREAD_COUNT * 2 + 100);
        this.mServer.setThreadPool((ThreadPool)threadPool);
        WebAppContext webappcontext = new WebAppContext();
        webappcontext.setContextPath("/");
        File warPath = new File(CommonConf.get().WEB_RESOURCES);
        webappcontext.setWar(warPath.getAbsolutePath());
        webappcontext.addServlet(new ServletHolder((Servlet)new WebInterfaceGeneralServlet(masterInfo)), "/home");
        webappcontext.addServlet(new ServletHolder((Servlet)new WebInterfaceWorkersServlet(masterInfo)), "/workers");
        webappcontext.addServlet(new ServletHolder((Servlet)new WebInterfaceConfigurationServlet(masterInfo)), "/configuration");
        webappcontext.addServlet(new ServletHolder((Servlet)new WebInterfaceBrowseServlet(masterInfo)), "/browse");
        webappcontext.addServlet(new ServletHolder((Servlet)new WebInterfaceMemoryServlet(masterInfo)), "/memory");
        webappcontext.addServlet(new ServletHolder((Servlet)new WebInterfaceDependencyServlet(masterInfo)), "/dependency");
        webappcontext.addServlet(new ServletHolder((Servlet)new WebInterfaceDownloadServlet(masterInfo)), "/download");
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{webappcontext, new DefaultHandler()});
        this.mServer.setHandler((Handler)handlers);
    }

    public void setHandler(AbstractHandler handler) {
        this.mServer.setHandler((Handler)handler);
    }

    public void shutdownWebServer() throws Exception {
        this.mServer.stop();
    }

    public void startWebServer() {
        try {
            this.mServer.start();
            LOG.info(this.mServerName + " started @ " + this.mAddress);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

