/*
 * Decompiled with CFR 0.152.
 */
package tachyon.web;

import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import tachyon.Constants;
import tachyon.master.MasterInfo;
import tachyon.thrift.ClientWorkerInfo;
import tachyon.util.CommonUtils;

public class WebInterfaceWorkersServlet
extends HttpServlet {
    private static final long serialVersionUID = -7454493761603179826L;
    private final transient MasterInfo mMasterInfo;

    public WebInterfaceWorkersServlet(MasterInfo masterInfo) {
        this.mMasterInfo = masterInfo;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.populateValues(request);
        this.getServletContext().getRequestDispatcher("/workers.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private NodeInfo[] generateOrderedNodeInfos(List<ClientWorkerInfo> workerInfos) {
        NodeInfo[] ret = new NodeInfo[workerInfos.size()];
        Collections.sort(workerInfos, new Ordering<ClientWorkerInfo>(){

            public int compare(ClientWorkerInfo info0, ClientWorkerInfo info1) {
                return info0.getAddress().getMHost().compareTo(info1.getAddress().getMHost());
            }
        });
        int index = 0;
        for (ClientWorkerInfo workerInfo : workerInfos) {
            ret[index++] = new NodeInfo(workerInfo);
        }
        return ret;
    }

    private void populateValues(HttpServletRequest request) throws IOException {
        request.setAttribute("debug", (Object)Constants.DEBUG);
        List<ClientWorkerInfo> workerInfos = this.mMasterInfo.getWorkersInfo();
        NodeInfo[] normalNodeInfos = this.generateOrderedNodeInfos(workerInfos);
        request.setAttribute("normalNodeInfos", (Object)normalNodeInfos);
        List<ClientWorkerInfo> lostWorkerInfos = this.mMasterInfo.getLostWorkersInfo();
        NodeInfo[] failedNodeInfos = this.generateOrderedNodeInfos(lostWorkerInfos);
        request.setAttribute("failedNodeInfos", (Object)failedNodeInfos);
    }

    public static class NodeInfo {
        private final String mName;
        private final String mLastContactSec;
        private final String mWorkerState;
        private final long mCapacityBytes;
        private final long mUsedBytes;
        private final int mFreePercent;
        private final int mUsedPercent;
        private final String mUptimeClockTime;

        private NodeInfo(ClientWorkerInfo workerInfo) {
            this.mName = workerInfo.getAddress().getMHost();
            this.mLastContactSec = Integer.toString(workerInfo.getLastContactSec());
            this.mWorkerState = workerInfo.getState();
            this.mCapacityBytes = workerInfo.getCapacityBytes();
            this.mUsedBytes = workerInfo.getUsedBytes();
            this.mUsedPercent = (int)(100L * this.mUsedBytes / this.mCapacityBytes);
            this.mFreePercent = 100 - this.mUsedPercent;
            this.mUptimeClockTime = CommonUtils.convertMsToShortClockTime(System.currentTimeMillis() - workerInfo.getStarttimeMs());
        }

        public String getCapacity() {
            return CommonUtils.getSizeFromBytes(this.mCapacityBytes);
        }

        public int getFreeSpacePercent() {
            return this.mFreePercent;
        }

        public String getLastHeartbeat() {
            return this.mLastContactSec;
        }

        public String getName() {
            return this.mName;
        }

        public String getState() {
            return this.mWorkerState;
        }

        public String getUptimeClockTime() {
            return this.mUptimeClockTime;
        }

        public String getUsedMemory() {
            return CommonUtils.getSizeFromBytes(this.mUsedBytes);
        }

        public int getUsedSpacePercent() {
            return this.mUsedPercent;
        }
    }
}

