/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import tachyon.worker.BlockHandlerLocal;

public abstract class BlockHandler
implements Closeable {
    public static BlockHandler get(String path) throws IOException, IllegalArgumentException {
        if (path.startsWith("/") || path.startsWith("file://")) {
            return new BlockHandlerLocal(path);
        }
        throw new IllegalArgumentException("Unsupported block file path: " + path);
    }

    public int append(long blockOffset, byte[] buf, int offset, int length) throws IOException {
        return this.append(blockOffset, ByteBuffer.wrap(buf, offset, length));
    }

    public abstract int append(long var1, ByteBuffer var3) throws IOException;

    public abstract boolean delete() throws IOException;

    public abstract ByteChannel getChannel();

    public abstract long getLength() throws IOException;

    public abstract ByteBuffer read(long var1, int var3) throws IOException;
}

