/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.util.CommonUtils;
import tachyon.worker.BlockHandler;

public final class BlockHandlerLocal
extends BlockHandler {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final RandomAccessFile mLocalFile;
    private final FileChannel mLocalFileChannel;
    private boolean mPermission = false;
    private final String mFilePath;
    private final Closer mCloser = Closer.create();

    BlockHandlerLocal(String filePath) throws IOException {
        this.mFilePath = (String)Preconditions.checkNotNull((Object)filePath);
        LOG.debug("{} is created", (Object)this.mFilePath);
        this.mLocalFile = (RandomAccessFile)this.mCloser.register((Closeable)new RandomAccessFile(this.mFilePath, "rw"));
        this.mLocalFileChannel = (FileChannel)this.mCloser.register((Closeable)this.mLocalFile.getChannel());
    }

    @Override
    public int append(long offset, ByteBuffer buf) throws IOException {
        this.checkPermission();
        int bufLen = buf.limit();
        MappedByteBuffer out = this.mLocalFileChannel.map(FileChannel.MapMode.READ_WRITE, offset, bufLen);
        out.put(buf);
        CommonUtils.cleanDirectBuffer(out);
        return bufLen;
    }

    private void checkPermission() throws IOException {
        if (!this.mPermission) {
            CommonUtils.changeLocalFileToFullPermission(this.mFilePath);
            CommonUtils.setLocalFileStickyBit(this.mFilePath);
            this.mPermission = true;
        }
    }

    @Override
    public void close() throws IOException {
        this.mCloser.close();
    }

    @Override
    public boolean delete() throws IOException {
        this.checkPermission();
        return new File(this.mFilePath).delete();
    }

    @Override
    public ByteChannel getChannel() {
        return this.mLocalFileChannel;
    }

    @Override
    public long getLength() throws IOException {
        return this.mLocalFile.length();
    }

    @Override
    public ByteBuffer read(long offset, int length) throws IOException {
        long fileLength = this.mLocalFile.length();
        String error = null;
        if (offset > fileLength) {
            error = String.format("offset(%d) is larger than file length(%d)", offset, fileLength);
        } else if (length != -1 && offset + (long)length > fileLength) {
            error = String.format("offset(%d) plus length(%d) is larger than file length(%d)", offset, length, fileLength);
        }
        if (error != null) {
            throw new IOException(error);
        }
        if (length == -1) {
            length = (int)(fileLength - offset);
        }
        MappedByteBuffer buf = this.mLocalFileChannel.map(FileChannel.MapMode.READ_ONLY, offset, length);
        return buf;
    }
}

