/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker;

public class SpaceCounter {
    private final long mCapacityBytes;
    private long mUsedBytes;

    public SpaceCounter(long capacityBytes) {
        this.mCapacityBytes = capacityBytes;
        this.mUsedBytes = 0L;
    }

    public synchronized long getAvailableBytes() {
        return this.mCapacityBytes - this.mUsedBytes;
    }

    public long getCapacityBytes() {
        return this.mCapacityBytes;
    }

    public synchronized long getUsedBytes() {
        return this.mUsedBytes;
    }

    public synchronized boolean requestSpaceBytes(long requestSpaceBytes) {
        if (this.getAvailableBytes() < requestSpaceBytes) {
            return false;
        }
        this.mUsedBytes += requestSpaceBytes;
        return true;
    }

    public synchronized void returnUsedBytes(long returnUsedBytes) {
        this.mUsedBytes -= returnUsedBytes;
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder("SpaceCounter(");
        sb.append(" TOTAL_BYTES: ").append(this.mCapacityBytes);
        sb.append(", mUsedBytes: ").append(this.mUsedBytes);
        sb.append(", mAvailableBytes: ").append(this.mCapacityBytes - this.mUsedBytes);
        sb.append(" )");
        return sb.toString();
    }

    public synchronized void updateUsedBytes(long usedBytes) {
        this.mUsedBytes = usedBytes;
    }
}

