/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker.eviction;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tachyon.Pair;
import tachyon.worker.eviction.EvictLRUBase;
import tachyon.worker.hierarchy.BlockInfo;
import tachyon.worker.hierarchy.StorageDir;

public final class EvictPartialLRU
extends EvictLRUBase {
    public EvictPartialLRU(boolean lastTier) {
        super(lastTier);
    }

    @Override
    public synchronized Pair<StorageDir, List<BlockInfo>> getDirCandidate(StorageDir[] storageDirs, Set<Integer> pinList, long requestBytes) {
        ArrayList<BlockInfo> blockInfoList = new ArrayList<BlockInfo>();
        HashSet<StorageDir> ignoredDirs = new HashSet<StorageDir>();
        StorageDir dirSelected = this.getDirWithMaxFreeSpace(requestBytes, storageDirs, ignoredDirs);
        while (dirSelected != null) {
            Pair<Long, Long> oldestAccess;
            HashSet<Long> blockIdSet = new HashSet<Long>();
            long sizeToEvict = 0L;
            while (sizeToEvict + dirSelected.getAvailableBytes() < requestBytes && (oldestAccess = this.getLRUBlock(dirSelected, blockIdSet, pinList)).getFirst() != -1L) {
                long blockSize = dirSelected.getBlockSize(oldestAccess.getFirst());
                sizeToEvict += blockSize;
                blockInfoList.add(new BlockInfo(dirSelected, oldestAccess.getFirst(), blockSize));
                blockIdSet.add(oldestAccess.getFirst());
            }
            if (sizeToEvict + dirSelected.getAvailableBytes() < requestBytes) {
                ignoredDirs.add(dirSelected);
                blockInfoList.clear();
                blockIdSet.clear();
                dirSelected = this.getDirWithMaxFreeSpace(requestBytes, storageDirs, ignoredDirs);
                continue;
            }
            return new Pair<StorageDir, List<BlockInfo>>(dirSelected, blockInfoList);
        }
        return null;
    }

    private StorageDir getDirWithMaxFreeSpace(long requestSize, StorageDir[] storageDirs, Set<StorageDir> ignoredList) {
        StorageDir dirSelected = null;
        long maxAvailableSize = -1L;
        for (StorageDir dir : storageDirs) {
            if (ignoredList.contains(dir) || dir.getCapacityBytes() < requestSize || dir.getAvailableBytes() <= maxAvailableSize) continue;
            dirSelected = dir;
            maxAvailableSize = dir.getAvailableBytes();
        }
        return dirSelected;
    }
}

