/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker.hierarchy;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.Pair;
import tachyon.TachyonURI;
import tachyon.UnderFileSystem;
import tachyon.util.CommonUtils;
import tachyon.worker.BlockHandler;
import tachyon.worker.SpaceCounter;

public final class StorageDir {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final ConcurrentMap<Long, Long> mBlockSizes = new ConcurrentHashMap<Long, Long>();
    private final ConcurrentMap<Long, Long> mLastBlockAccessTimeMs = new ConcurrentHashMap<Long, Long>();
    private final BlockingQueue<Long> mAddedBlockIdList = new ArrayBlockingQueue<Long>(10000);
    private final Set<Long> mToRemoveBlockIdSet = Collections.synchronizedSet(new HashSet());
    private final SpaceCounter mSpaceCounter;
    private final long mStorageDirId;
    private final TachyonURI mDirPath;
    private final TachyonURI mDataPath;
    private final TachyonURI mUserTempPath;
    private final UnderFileSystem mFs;
    private final Object mConf;
    private final ConcurrentMap<Long, Long> mOwnBytesPerUser = new ConcurrentHashMap<Long, Long>();
    private final ConcurrentMap<Pair<Long, Long>, Long> mTempBlockAllocatedBytes = new ConcurrentHashMap<Pair<Long, Long>, Long>();
    private final Multimap<Long, Long> mLockedBlocksPerUser = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
    private final Multimap<Long, Long> mUserPerLockedBlock = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());

    StorageDir(long storageDirId, String dirPath, long capacityBytes, String dataFolder, String userTempFolder, Object conf) {
        this.mStorageDirId = storageDirId;
        this.mDirPath = new TachyonURI(dirPath);
        this.mSpaceCounter = new SpaceCounter(capacityBytes);
        this.mDataPath = this.mDirPath.join(dataFolder);
        this.mUserTempPath = this.mDirPath.join(userTempFolder);
        this.mConf = conf;
        this.mFs = UnderFileSystem.get(dirPath, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accessBlock(long blockId) {
        ConcurrentMap<Long, Long> concurrentMap = this.mLastBlockAccessTimeMs;
        synchronized (concurrentMap) {
            if (this.containsBlock(blockId)) {
                this.mLastBlockAccessTimeMs.put(blockId, System.currentTimeMillis());
            }
        }
    }

    private void addBlockId(long blockId, long sizeBytes, boolean report) {
        this.addBlockId(blockId, sizeBytes, System.currentTimeMillis(), report);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBlockId(long blockId, long sizeBytes, long accessTimeMs, boolean report) {
        ConcurrentMap<Long, Long> concurrentMap = this.mLastBlockAccessTimeMs;
        synchronized (concurrentMap) {
            this.mLastBlockAccessTimeMs.put(blockId, accessTimeMs);
            if (this.mBlockSizes.containsKey(blockId)) {
                this.mSpaceCounter.returnUsedBytes((Long)this.mBlockSizes.remove(blockId));
            }
            this.mBlockSizes.put(blockId, sizeBytes);
            if (report) {
                this.mAddedBlockIdList.add(blockId);
            }
        }
    }

    public boolean cacheBlock(long userId, long blockId) throws IOException {
        String srcPath = this.getUserTempFilePath(userId, blockId);
        String dstPath = this.getBlockFilePath(blockId);
        Pair<Long, Long> blockInfo = new Pair<Long, Long>(userId, blockId);
        if (!this.mFs.exists(srcPath) || !this.mTempBlockAllocatedBytes.containsKey(blockInfo)) {
            this.cancelBlock(userId, blockId);
            throw new IOException("Block file doesn't exist! blockId:" + blockId + " " + srcPath);
        }
        long blockSize = this.mFs.getFileSize(srcPath);
        if (blockSize < 0L) {
            this.cancelBlock(userId, blockId);
            throw new IOException("Negative block size! blockId:" + blockId);
        }
        Long allocatedBytes = (Long)this.mTempBlockAllocatedBytes.remove(blockInfo);
        this.returnSpace(userId, allocatedBytes - blockSize);
        if (this.mFs.rename(srcPath, dstPath)) {
            this.addBlockId(blockId, blockSize, false);
            this.updateUserOwnBytes(userId, -blockSize);
            return true;
        }
        return false;
    }

    public boolean cancelBlock(long userId, long blockId) throws IOException {
        String filePath = this.getUserTempFilePath(userId, blockId);
        Long allocatedBytes = (Long)this.mTempBlockAllocatedBytes.remove(new Pair<Long, Long>(userId, blockId));
        if (allocatedBytes == null) {
            allocatedBytes = 0L;
        }
        this.returnSpace(userId, allocatedBytes);
        if (!this.mFs.exists(filePath)) {
            return true;
        }
        return this.mFs.delete(filePath, false);
    }

    public void cleanUserResources(long userId, Collection<Long> tempBlockIdList) {
        Collection blockIds = this.mLockedBlocksPerUser.removeAll((Object)userId);
        Iterator<Object> i$ = blockIds.iterator();
        while (i$.hasNext()) {
            long blockId = (Long)i$.next();
            this.mUserPerLockedBlock.remove((Object)blockId, (Object)userId);
        }
        for (Long tempBlockId : tempBlockIdList) {
            this.mTempBlockAllocatedBytes.remove(new Pair<Long, Long>(userId, tempBlockId));
        }
        try {
            this.mFs.delete(this.getUserTempPath(userId), true);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        this.returnSpace(userId);
    }

    public boolean containsBlock(long blockId) {
        return this.mLastBlockAccessTimeMs.containsKey(blockId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyBlock(long blockId, StorageDir dstDir) throws IOException {
        long size = this.getBlockSize(blockId);
        if (size == -1L) {
            LOG.error("Block file doesn't exist! blockId:{}", (Object)blockId);
            return false;
        }
        boolean copySuccess = false;
        Closer closer = Closer.create();
        ByteBuffer buffer = null;
        try {
            BlockHandler bhSrc = (BlockHandler)closer.register((Closeable)this.getBlockHandler(blockId));
            BlockHandler bhDst = (BlockHandler)closer.register((Closeable)dstDir.getBlockHandler(blockId));
            buffer = bhSrc.read(0L, (int)size);
            copySuccess = (long)bhDst.append(0L, buffer) == size;
        }
        catch (Throwable throwable) {
            closer.close();
            CommonUtils.cleanDirectBuffer(buffer);
            throw throwable;
        }
        closer.close();
        CommonUtils.cleanDirectBuffer(buffer);
        if (copySuccess) {
            dstDir.addBlockId(blockId, size, (Long)this.mLastBlockAccessTimeMs.get(blockId), true);
        }
        return copySuccess;
    }

    public boolean deleteBlock(long blockId) throws IOException {
        Long accessTimeMs = (Long)this.mLastBlockAccessTimeMs.remove(blockId);
        if (accessTimeMs == null) {
            LOG.warn("Block does not exist in current StorageDir! blockId:{}", (Object)blockId);
            return false;
        }
        String blockfile = this.getBlockFilePath(blockId);
        if (!this.isBlockLocked(blockId)) {
            if (!this.mFs.delete(blockfile, false)) {
                LOG.error("Failed to delete block file! filename:{}", (Object)blockfile);
                return false;
            }
            this.deleteBlockId(blockId);
        } else {
            this.mToRemoveBlockIdSet.add(blockId);
            LOG.debug("Add block file {} to remove list!", (Object)blockfile);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteBlockId(long blockId) {
        ConcurrentMap<Long, Long> concurrentMap = this.mLastBlockAccessTimeMs;
        synchronized (concurrentMap) {
            this.mLastBlockAccessTimeMs.remove(blockId);
            this.mSpaceCounter.returnUsedBytes((Long)this.mBlockSizes.remove(blockId));
            if (this.mAddedBlockIdList.contains(blockId)) {
                this.mAddedBlockIdList.remove(blockId);
            }
        }
    }

    public List<Long> getAddedBlockIdList() {
        ArrayList<Long> addedBlockIdList = new ArrayList<Long>();
        this.mAddedBlockIdList.drainTo(addedBlockIdList);
        return addedBlockIdList;
    }

    public long getAvailableBytes() {
        return this.mSpaceCounter.getAvailableBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getBlockData(long blockId, long offset, int length) throws IOException {
        BlockHandler bh = this.getBlockHandler(blockId);
        try {
            ByteBuffer byteBuffer = bh.read(offset, length);
            return byteBuffer;
        }
        finally {
            bh.close();
            this.accessBlock(blockId);
        }
    }

    public String getBlockFilePath(long blockId) {
        return this.mDataPath.join("" + blockId).toString();
    }

    public BlockHandler getBlockHandler(long blockId) throws IOException {
        String filePath = this.getBlockFilePath(blockId);
        try {
            return BlockHandler.get(filePath);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e.getMessage());
        }
    }

    public Set<Long> getBlockIds() {
        return this.mLastBlockAccessTimeMs.keySet();
    }

    public long getBlockSize(long blockId) {
        Long size = (Long)this.mBlockSizes.get(blockId);
        if (size == null) {
            return -1L;
        }
        return size;
    }

    public Set<Map.Entry<Long, Long>> getBlockSizes() {
        return this.mBlockSizes.entrySet();
    }

    public long getCapacityBytes() {
        return this.mSpaceCounter.getCapacityBytes();
    }

    public TachyonURI getDirDataPath() {
        return this.mDataPath;
    }

    public TachyonURI getDirPath() {
        return this.mDirPath;
    }

    public Set<Map.Entry<Long, Long>> getLastBlockAccessTimeMs() {
        return this.mLastBlockAccessTimeMs.entrySet();
    }

    public long getLockedSizeBytes() {
        long lockedBytes = 0L;
        Iterator i$ = this.mUserPerLockedBlock.keySet().iterator();
        while (i$.hasNext()) {
            long blockId = (Long)i$.next();
            Long blockSize = (Long)this.mBlockSizes.get(blockId);
            if (blockSize == null) continue;
            lockedBytes += blockSize.longValue();
        }
        return lockedBytes;
    }

    public long getStorageDirId() {
        return this.mStorageDirId;
    }

    public UnderFileSystem getUfs() {
        return this.mFs;
    }

    public Object getUfsConf() {
        return this.mConf;
    }

    public long getUsedBytes() {
        return this.mSpaceCounter.getUsedBytes();
    }

    public long getUserOwnBytes(long userId) {
        Long ownBytes = (Long)this.mOwnBytesPerUser.get(userId);
        if (ownBytes == null) {
            ownBytes = 0L;
        }
        return ownBytes;
    }

    public String getUserTempFilePath(long userId, long blockId) {
        return this.mUserTempPath.join("" + userId).join("" + blockId).toString();
    }

    public TachyonURI getUserTempPath() {
        return this.mUserTempPath;
    }

    public String getUserTempPath(long userId) {
        return this.mUserTempPath.join("" + userId).toString();
    }

    public void initailize() throws IOException {
        String dataPath = this.mDataPath.toString();
        if (!this.mFs.exists(dataPath)) {
            LOG.info("Data folder {} does not exist. Creating a new one.", (Object)this.mDataPath);
            this.mFs.mkdirs(dataPath, true);
            this.mFs.setPermission(dataPath, "775");
        } else if (this.mFs.isFile(dataPath)) {
            String msg = "Data folder " + this.mDataPath + " is not a folder!";
            throw new IllegalArgumentException(msg);
        }
        String userTempPath = this.mUserTempPath.toString();
        if (!this.mFs.exists(userTempPath)) {
            LOG.info("User temp folder {} does not exist. Creating a new one.", (Object)this.mUserTempPath);
            this.mFs.mkdirs(userTempPath, true);
            this.mFs.setPermission(userTempPath, "775");
        } else if (this.mFs.isFile(userTempPath)) {
            String msg = "User temp folder " + this.mUserTempPath + " is not a folder!";
            throw new IllegalArgumentException(msg);
        }
        int cnt = 0;
        for (String name : this.mFs.list(dataPath)) {
            String path = this.mDataPath.join(name).toString();
            if (!this.mFs.isFile(path)) continue;
            long fileSize = this.mFs.getFileSize(path);
            LOG.debug("File {}: {} with size {} Bs.", new Object[]{++cnt, path, fileSize});
            long blockId = CommonUtils.getBlockIdFromFileName(name);
            boolean success = this.mSpaceCounter.requestSpaceBytes(fileSize);
            if (success) {
                this.addBlockId(blockId, fileSize, true);
                continue;
            }
            this.mFs.delete(path, true);
            LOG.warn("Pre-existing files exceed storage capacity. deleting file:{}", (Object)path);
        }
    }

    public boolean isBlockLocked(long blockId) {
        return this.mUserPerLockedBlock.containsKey((Object)blockId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockBlock(long blockId, long userId) {
        ConcurrentMap<Long, Long> concurrentMap = this.mLastBlockAccessTimeMs;
        synchronized (concurrentMap) {
            if (!this.containsBlock(blockId)) {
                return false;
            }
            this.mUserPerLockedBlock.put((Object)blockId, (Object)userId);
            this.mLockedBlocksPerUser.put((Object)userId, (Object)blockId);
            return true;
        }
    }

    public boolean moveBlock(long blockId, StorageDir dstDir) throws IOException {
        if (this.copyBlock(blockId, dstDir)) {
            return this.deleteBlock(blockId);
        }
        return false;
    }

    public boolean requestSpace(long userId, long size) {
        boolean result = this.mSpaceCounter.requestSpaceBytes(size);
        if (result && userId != -3L) {
            this.updateUserOwnBytes(userId, size);
        }
        return result;
    }

    private void returnSpace(long userId) {
        Long ownBytes = (Long)this.mOwnBytesPerUser.remove(userId);
        if (ownBytes != null) {
            this.mSpaceCounter.returnUsedBytes(ownBytes);
        }
    }

    public void returnSpace(long userId, long size) {
        this.mSpaceCounter.returnUsedBytes(size);
        this.updateUserOwnBytes(userId, -size);
    }

    public boolean unlockBlock(long blockId, long userId) {
        if (this.mUserPerLockedBlock.remove((Object)blockId, (Object)userId)) {
            this.mLockedBlocksPerUser.remove((Object)userId, (Object)blockId);
            if (!this.isBlockLocked(blockId) && this.mToRemoveBlockIdSet.contains(blockId)) {
                try {
                    if (!this.mFs.delete(this.getBlockFilePath(blockId), false)) {
                        return false;
                    }
                    this.mToRemoveBlockIdSet.remove(blockId);
                    this.deleteBlockId(blockId);
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void updateTempBlockAllocatedBytes(long userId, long blockId, long sizeBytes) {
        Pair<Long, Long> blockInfo = new Pair<Long, Long>(userId, blockId);
        Long oldSize = this.mTempBlockAllocatedBytes.putIfAbsent(blockInfo, sizeBytes);
        if (oldSize != null) {
            while (!this.mTempBlockAllocatedBytes.replace(blockInfo, oldSize, oldSize + sizeBytes)) {
                oldSize = (Long)this.mTempBlockAllocatedBytes.get(blockInfo);
                if (oldSize != null) continue;
                LOG.error("Temporary block doesn't exist! blockId:{}", (Object)blockId);
                break;
            }
        }
    }

    private void updateUserOwnBytes(long userId, long sizeBytes) {
        Long used = this.mOwnBytesPerUser.putIfAbsent(userId, sizeBytes);
        if (used != null) {
            while (!this.mOwnBytesPerUser.replace(userId, used, used + sizeBytes)) {
                used = (Long)this.mOwnBytesPerUser.get(userId);
                if (used != null) continue;
                LOG.error("Unknown user! userId:{}", (Object)userId);
                break;
            }
        }
    }
}

