/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker.hierarchy;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.Constants;
import tachyon.Pair;
import tachyon.StorageDirId;
import tachyon.StorageLevelAlias;
import tachyon.conf.UserConf;
import tachyon.conf.WorkerConf;
import tachyon.worker.allocation.AllocateStrategies;
import tachyon.worker.allocation.AllocateStrategy;
import tachyon.worker.eviction.EvictStrategies;
import tachyon.worker.eviction.EvictStrategy;
import tachyon.worker.hierarchy.BlockInfo;
import tachyon.worker.hierarchy.StorageDir;

public class StorageTier {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    private final int mLevel;
    private final StorageLevelAlias mAlias;
    private final StorageTier mNextTier;
    private final StorageDir[] mDirs;
    private final AllocateStrategy mSpaceAllocator;
    private final EvictStrategy mBlockEvictor;
    private final long mCapacityBytes;
    private static final int FAILED_SPACE_REQUEST_LIMITS = UserConf.get().FAILED_SPACE_REQUEST_LIMITS;

    public StorageTier(int storageLevel, StorageLevelAlias storageLevelAlias, String[] dirPaths, long[] dirCapacityBytes, String dataFolder, String userTempFolder, StorageTier nextTier, Object conf) throws IOException {
        this.mLevel = storageLevel;
        this.mAlias = storageLevelAlias;
        this.mDirs = new StorageDir[dirPaths.length];
        long quotaBytes = 0L;
        for (int i = 0; i < dirPaths.length; ++i) {
            long storageDirId = StorageDirId.getStorageDirId(storageLevel, this.mAlias.getValue(), i);
            this.mDirs[i] = new StorageDir(storageDirId, dirPaths[i], dirCapacityBytes[i], dataFolder, userTempFolder, conf);
            quotaBytes += dirCapacityBytes[i];
        }
        this.mCapacityBytes = quotaBytes;
        this.mNextTier = nextTier;
        this.mSpaceAllocator = AllocateStrategies.getAllocateStrategy(WorkerConf.get().ALLOCATE_STRATEGY_TYPE);
        this.mBlockEvictor = EvictStrategies.getEvictStrategy(WorkerConf.get().EVICT_STRATEGY_TYPE, this.isLastTier());
    }

    public boolean containsBlock(long blockId) {
        return this.getStorageDirByBlockId(blockId) != null;
    }

    public long getCapacityBytes() {
        return this.mCapacityBytes;
    }

    public StorageTier getNextStorageTier() {
        return this.mNextTier;
    }

    public StorageDir getStorageDirByBlockId(long blockId) {
        for (StorageDir dir : this.mDirs) {
            if (!dir.containsBlock(blockId)) continue;
            return dir;
        }
        return null;
    }

    public StorageDir getStorageDirByIndex(int dirIndex) {
        if (dirIndex < this.mDirs.length && dirIndex >= 0) {
            return this.mDirs[dirIndex];
        }
        return null;
    }

    public StorageDir[] getStorageDirs() {
        return this.mDirs;
    }

    public int getLevel() {
        return this.mLevel;
    }

    public StorageLevelAlias getAlias() {
        return this.mAlias;
    }

    public long getUsedBytes() {
        long used = 0L;
        for (StorageDir dir : this.mDirs) {
            used += dir.getUsedBytes();
        }
        return used;
    }

    public void initialize() throws IOException {
        for (StorageDir dir : this.mDirs) {
            dir.initailize();
        }
    }

    public boolean isLastTier() {
        return this.mNextTier == null;
    }

    public StorageDir requestSpace(long userId, long requestBytes, Set<Integer> pinList, List<Long> removedBlockIds) throws IOException {
        return this.requestSpace(this.mDirs, userId, requestBytes, pinList, removedBlockIds);
    }

    public boolean requestSpace(StorageDir storageDir, long userId, long requestBytes, Set<Integer> pinList, List<Long> removedBlockIds) throws IOException {
        if (StorageDirId.getStorageLevel(storageDir.getStorageDirId()) != this.mLevel) {
            return false;
        }
        StorageDir[] dirs = new StorageDir[]{storageDir};
        return storageDir == this.requestSpace(dirs, userId, requestBytes, pinList, removedBlockIds);
    }

    private synchronized StorageDir requestSpace(StorageDir[] dirs, long userId, long requestSizeBytes, Set<Integer> pinList, List<Long> removedBlockIds) throws IOException {
        StorageDir dirSelected = this.mSpaceAllocator.getStorageDir(dirs, userId, requestSizeBytes);
        if (dirSelected != null) {
            return dirSelected;
        }
        if (this.mSpaceAllocator.fitInPossible(dirs, requestSizeBytes)) {
            for (int attempt = 0; attempt < FAILED_SPACE_REQUEST_LIMITS; ++attempt) {
                Pair<StorageDir, List<BlockInfo>> evictInfo = this.mBlockEvictor.getDirCandidate(dirs, pinList, requestSizeBytes);
                if (evictInfo == null) {
                    return null;
                }
                dirSelected = evictInfo.getFirst();
                List<BlockInfo> blocksInfoList = evictInfo.getSecond();
                for (BlockInfo blockInfo : blocksInfoList) {
                    StorageDir dir = blockInfo.getStorageDir();
                    if (dir.isBlockLocked(blockInfo.getBlockId())) continue;
                    long blockId = blockInfo.getBlockId();
                    if (this.isLastTier()) {
                        dir.deleteBlock(blockId);
                        removedBlockIds.add(blockId);
                    } else {
                        StorageDir dstDir = this.mNextTier.requestSpace(-3L, blockInfo.getSize(), pinList, removedBlockIds);
                        dir.moveBlock(blockId, dstDir);
                    }
                    LOG.debug("Evicted block Id:{}" + blockId);
                }
                if (dirSelected.requestSpace(userId, requestSizeBytes)) {
                    return dirSelected;
                }
                LOG.warn("Request space failed! attempt:{} storageLevel:{}", (Object)attempt, (Object)this.mLevel);
            }
        }
        LOG.warn("No StorageDir is allocated! requestSize:{} storageLevel:{} used:{} capacity:{}", new Object[]{requestSizeBytes, this.mLevel, this.getUsedBytes(), this.getCapacityBytes()});
        return null;
    }

    public String toString() {
        return this.mLevel + "_" + (Object)((Object)this.mAlias);
    }
}

