/*
 * Decompiled with CFR 0.152.
 */
package tachyon.worker.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.stream.ChunkedWriteHandler;
import tachyon.worker.BlocksLocker;
import tachyon.worker.netty.BlockRequest;
import tachyon.worker.netty.BlockResponse;
import tachyon.worker.netty.DataServerHandler;

public final class PipelineHandler
extends ChannelInitializer<SocketChannel> {
    private final BlocksLocker mLocker;

    public PipelineHandler(BlocksLocker locker) {
        this.mLocker = locker;
    }

    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("nioChunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("blockRequestDecoder", (ChannelHandler)new BlockRequest.Decoder());
        pipeline.addLast("blockResponseEncoder", (ChannelHandler)new BlockResponse.Encoder());
        pipeline.addLast("dataServerHandler", (ChannelHandler)new DataServerHandler(this.mLocker));
    }
}

