/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.messaging.AddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.AlterIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.CreateIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.DropFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.DropIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.DropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.hadoop.hive.metastore.messaging.MessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.MessageFactory;
import org.apache.hadoop.hive.metastore.messaging.json.ExtendedJSONAddPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.ExtendedJSONAlterDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.ExtendedJSONAlterPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.ExtendedJSONAlterTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.ExtendedJSONCreateDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.ExtendedJSONCreateTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.ExtendedJSONDropDatabaseMessage;
import org.apache.hadoop.hive.metastore.messaging.json.ExtendedJSONDropPartitionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.ExtendedJSONDropTableMessage;
import org.apache.hadoop.hive.metastore.messaging.json.ExtendedJSONMessageDeserializer;
import org.apache.hadoop.hive.metastore.messaging.json.JSONAlterIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONCreateIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropFunctionMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONDropIndexMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONInsertMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageFactory;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

public class ExtendedJSONMessageFactory
extends MessageFactory {
    private static final Log LOG = LogFactory.getLog(ExtendedJSONMessageFactory.class.getName());
    private static ExtendedJSONMessageDeserializer deserializer = new ExtendedJSONMessageDeserializer();
    protected static final HiveConf hiveConf = new HiveConf();
    protected static final String MS_SERVER_URL;
    protected static final String MS_SERVICE_PRINCIPAL;

    public ExtendedJSONMessageFactory() {
        LOG.info("Using ExtendedJSONMessageFactory for building Notification log messages ");
    }

    @Override
    public MessageDeserializer getDeserializer() {
        return deserializer;
    }

    @Override
    public String getVersion() {
        return "0.1";
    }

    @Override
    public void init() throws MetaException {
        super.init();
        List<String> excludePatterns = Arrays.asList(HiveConf.getTrimmedStringsVar(hiveConf, HiveConf.ConfVars.EVENT_NOTIFICATION_PARAMETERS_EXCLUDE_PATTERNS));
        try {
            JSONMessageFactory.paramsFilter = MetaStoreUtils.compilePatternsToPredicates(excludePatterns);
        }
        catch (PatternSyntaxException e) {
            LOG.error("Regex pattern compilation failed. Verify that " + HiveConf.ConfVars.EVENT_NOTIFICATION_PARAMETERS_EXCLUDE_PATTERNS.varname + " has valid patterns.");
            throw new MetaException("Regex pattern compilation failed. " + e.getMessage());
        }
    }

    @Override
    public String getMessageFormat() {
        return "json";
    }

    @Override
    public ExtendedJSONCreateDatabaseMessage buildCreateDatabaseMessage(Database db) {
        return new ExtendedJSONCreateDatabaseMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, this.now(), db);
    }

    @Override
    public ExtendedJSONAlterDatabaseMessage buildAlterDatabaseMessage(Database before, Database after) {
        return new ExtendedJSONAlterDatabaseMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, before, after, this.now());
    }

    @Override
    public ExtendedJSONDropDatabaseMessage buildDropDatabaseMessage(Database db) {
        return new ExtendedJSONDropDatabaseMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, db, this.now(), db.getLocationUri());
    }

    @Override
    public ExtendedJSONCreateTableMessage buildCreateTableMessage(Table table) {
        return new ExtendedJSONCreateTableMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, this.now(), table);
    }

    @Override
    public ExtendedJSONAlterTableMessage buildAlterTableMessage(Table before, Table after) {
        String oldLocation = null;
        String newLocation = null;
        if (before != null && before.isSetSd()) {
            oldLocation = before.getSd().getLocation();
        }
        if (after != null && after.isSetSd()) {
            newLocation = after.getSd().getLocation();
        }
        return new ExtendedJSONAlterTableMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, before, after, this.now(), oldLocation, newLocation);
    }

    @Override
    public ExtendedJSONDropTableMessage buildDropTableMessage(Table table) {
        String location = null;
        if (table != null && table.isSetSd()) {
            location = table.getSd().getLocation();
        }
        return new ExtendedJSONDropTableMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, this.now(), location);
    }

    @Override
    public ExtendedJSONAlterPartitionMessage buildAlterPartitionMessage(Table table, Partition before, Partition after) {
        String oldLocation = null;
        String newLocation = null;
        if (before != null && before.isSetSd()) {
            oldLocation = before.getSd().getLocation();
        }
        if (after != null && after.isSetSd()) {
            newLocation = after.getSd().getLocation();
        }
        return new ExtendedJSONAlterPartitionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, before, after, this.now(), after.getValues(), oldLocation, newLocation);
    }

    @Override
    public DropPartitionMessage buildDropPartitionMessage(Table table, Iterator<Partition> partitions) {
        PartitionBasicInfo partitionBasicInfo = this.getPartitionBasicInfo(table, partitions);
        return new ExtendedJSONDropPartitionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, partitionBasicInfo.getPartitionList(), this.now(), partitionBasicInfo.getLocations());
    }

    @Override
    public CreateFunctionMessage buildCreateFunctionMessage(Function function) {
        return new JSONCreateFunctionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, function, this.now());
    }

    @Override
    public DropFunctionMessage buildDropFunctionMessage(Function function) {
        return new JSONDropFunctionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, function, this.now());
    }

    @Override
    public CreateIndexMessage buildCreateIndexMessage(Index index) {
        return new JSONCreateIndexMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, index, this.now());
    }

    @Override
    public DropIndexMessage buildDropIndexMessage(Index index) {
        return new JSONDropIndexMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, index, this.now());
    }

    @Override
    public AlterIndexMessage buildAlterIndexMessage(Index before, Index after) {
        return new JSONAlterIndexMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, before, after, this.now());
    }

    @Override
    public InsertMessage buildInsertMessage(Table tableObj, Partition partObj, boolean replace, List<String> files) {
        return new JSONInsertMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, tableObj, partObj, replace, files, this.now());
    }

    @Override
    public AddPartitionMessage buildAddPartitionMessage(Table table, Iterator<Partition> partitionsIterator) {
        PartitionBasicInfo partitionBasicInfo = this.getPartitionBasicInfo(table, partitionsIterator);
        return new ExtendedJSONAddPartitionMessage(MS_SERVER_URL, MS_SERVICE_PRINCIPAL, table, partitionBasicInfo.getPartitions(), this.now(), partitionBasicInfo.getLocations());
    }

    public AddPartitionMessage buildAddPartitionMessage(Table table, List<Partition> partitions) {
        return this.buildAddPartitionMessage(table, partitions.iterator());
    }

    private PartitionBasicInfo getPartitionBasicInfo(Table table, Iterator<Partition> iterator) {
        PartitionBasicInfo partitionBasicInfo = new PartitionBasicInfo();
        while (iterator.hasNext()) {
            Partition partition = iterator.next();
            partitionBasicInfo.getPartitions().add(partition);
            partitionBasicInfo.getPartitionList().add(ExtendedJSONMessageFactory.getPartitionKeyValues(table, partition));
            partitionBasicInfo.getLocations().add(partition.getSd().getLocation());
        }
        return partitionBasicInfo;
    }

    private static Map<String, String> getPartitionKeyValues(Table table, Partition partition) {
        LinkedHashMap<String, String> partitionKeys = new LinkedHashMap<String, String>();
        if (table.getPartitionKeysSize() != partition.getValuesSize()) {
            LOG.error("PartitionKeys size and partition values size different.");
            return partitionKeys;
        }
        for (int i = 0; i < table.getPartitionKeysSize(); ++i) {
            partitionKeys.put(table.getPartitionKeys().get(i).getName(), partition.getValues().get(i));
        }
        return partitionKeys;
    }

    private long now() {
        return System.currentTimeMillis() / 1000L;
    }

    static {
        hiveConf.addResource("hive-site.xml");
        MS_SERVER_URL = hiveConf.get(HiveConf.ConfVars.METASTOREURIS.name(), "");
        MS_SERVICE_PRINCIPAL = hiveConf.get(HiveConf.ConfVars.METASTORE_KERBEROS_PRINCIPAL.name(), "");
    }

    private class PartitionBasicInfo {
        private List<Map<String, String>> partitionList = Lists.newArrayList();
        private List<String> locations = Lists.newArrayList();
        private List<Partition> partitions = Lists.newArrayList();

        private PartitionBasicInfo() {
        }

        public List<Map<String, String>> getPartitionList() {
            return this.partitionList;
        }

        public List<Partition> getPartitions() {
            return this.partitions;
        }

        public List<String> getLocations() {
            return this.locations;
        }
    }
}

