/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.util.ConcurrentModificationException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.persistence.HashMapWrapper;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinBytesTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinEagerRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKeyObject;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinObjectSerDeContext;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinPersistableTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinRowContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastTableContainer;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Writable;

public class MapJoinTableContainerSerDe {
    private final MapJoinObjectSerDeContext keyContext;
    private final MapJoinObjectSerDeContext valueContext;

    public MapJoinTableContainerSerDe(MapJoinObjectSerDeContext keyContext, MapJoinObjectSerDeContext valueContext) {
        this.keyContext = keyContext;
        this.valueContext = valueContext;
    }

    public MapJoinObjectSerDeContext getKeyContext() {
        return this.keyContext;
    }

    public MapJoinObjectSerDeContext getValueContext() {
        return this.valueContext;
    }

    public MapJoinPersistableTableContainer load(ObjectInputStream in) throws HiveException {
        MapJoinPersistableTableContainer tableContainer;
        SerDe keySerDe = this.keyContext.getSerDe();
        SerDe valueSerDe = this.valueContext.getSerDe();
        try {
            String name = in.readUTF();
            Map metaData = (Map)in.readObject();
            tableContainer = this.create(name, metaData);
        }
        catch (IOException e) {
            throw new HiveException("IO error while trying to create table container", e);
        }
        catch (ClassNotFoundException e) {
            throw new HiveException("Class Initialization error while trying to create table container", e);
        }
        try {
            Writable keyContainer = keySerDe.getSerializedClass().newInstance();
            Writable valueContainer = valueSerDe.getSerializedClass().newInstance();
            int numKeys = in.readInt();
            for (int keyIndex = 0; keyIndex < numKeys; ++keyIndex) {
                MapJoinKeyObject key = new MapJoinKeyObject();
                key.read(this.keyContext, in, keyContainer);
                MapJoinEagerRowContainer values = new MapJoinEagerRowContainer();
                values.read(this.valueContext, in, valueContainer);
                tableContainer.put(key, values);
            }
            return tableContainer;
        }
        catch (IOException e) {
            throw new HiveException("IO error while trying to create table container", e);
        }
        catch (Exception e) {
            throw new HiveException("Error while trying to create table container", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapJoinTableContainer load(FileSystem fs, Path folder, Configuration hconf) throws HiveException {
        try {
            if (!fs.exists(folder)) {
                return MapJoinTableContainerSerDe.getDefaultEmptyContainer(hconf, this.keyContext, this.valueContext);
            }
            if (!fs.isDirectory(folder)) {
                throw new HiveException("Error, not a directory: " + folder);
            }
            FileStatus[] fileStatuses = fs.listStatus(folder);
            if (fileStatuses == null || fileStatuses.length == 0) {
                return MapJoinTableContainerSerDe.getDefaultEmptyContainer(hconf, this.keyContext, this.valueContext);
            }
            SerDe keySerDe = this.keyContext.getSerDe();
            SerDe valueSerDe = this.valueContext.getSerDe();
            Writable keyContainer = keySerDe.getSerializedClass().newInstance();
            Writable valueContainer = valueSerDe.getSerializedClass().newInstance();
            MapJoinTableContainer tableContainer = null;
            boolean useOptimizedContainer = HiveConf.getBoolVar(hconf, HiveConf.ConfVars.HIVEMAPJOINUSEOPTIMIZEDTABLE);
            for (FileStatus fileStatus : fileStatuses) {
                Path filePath = fileStatus.getPath();
                if (ShimLoader.getHadoopShims().isDirectory(fileStatus)) {
                    throw new HiveException("Error, not a file: " + filePath);
                }
                FSDataInputStream is = null;
                ObjectInputStream in = null;
                try {
                    is = fs.open(filePath, 4096);
                    in = new ObjectInputStream((InputStream)is);
                    String name = in.readUTF();
                    Map metaData = (Map)in.readObject();
                    if (tableContainer == null) {
                        tableContainer = useOptimizedContainer ? new MapJoinBytesTableContainer(hconf, this.valueContext, -1L, 0L) : this.create(name, metaData);
                    }
                    tableContainer.setSerde(this.keyContext, this.valueContext);
                    if (useOptimizedContainer) {
                        this.loadOptimized((MapJoinBytesTableContainer)tableContainer, in, keyContainer, valueContainer);
                        continue;
                    }
                    this.loadNormal((MapJoinPersistableTableContainer)tableContainer, in, keyContainer, valueContainer);
                }
                finally {
                    if (in != null) {
                        in.close();
                    } else if (is != null) {
                        is.close();
                    }
                }
            }
            if (tableContainer != null) {
                tableContainer.seal();
            }
            return tableContainer;
        }
        catch (IOException e) {
            throw new HiveException("IO error while trying to create table container", e);
        }
        catch (Exception e) {
            throw new HiveException("Error while trying to create table container", e);
        }
    }

    private void loadNormal(MapJoinPersistableTableContainer container, ObjectInputStream in, Writable keyContainer, Writable valueContainer) throws Exception {
        int numKeys = in.readInt();
        for (int keyIndex = 0; keyIndex < numKeys; ++keyIndex) {
            MapJoinKeyObject key = new MapJoinKeyObject();
            key.read(this.keyContext, in, keyContainer);
            if (container.get(key) == null) {
                container.put(key, new MapJoinEagerRowContainer());
            }
            MapJoinEagerRowContainer values = (MapJoinEagerRowContainer)container.get(key);
            values.read(this.valueContext, in, valueContainer);
            container.put(key, values);
        }
    }

    private void loadOptimized(MapJoinBytesTableContainer container, ObjectInputStream in, Writable key, Writable value) throws Exception {
        int numKeys = in.readInt();
        for (int keyIndex = 0; keyIndex < numKeys; ++keyIndex) {
            key.readFields((DataInput)in);
            long numRows = in.readLong();
            for (long rowIndex = 0L; rowIndex < numRows; ++rowIndex) {
                value.readFields((DataInput)in);
                container.putRow(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapJoinTableContainer loadFastContainer(MapJoinDesc mapJoinDesc, FileSystem fs, Path folder, Configuration hconf) throws HiveException {
        try {
            VectorMapJoinFastTableContainer tableContainer = new VectorMapJoinFastTableContainer(mapJoinDesc, hconf, -1L);
            tableContainer.setSerde(this.keyContext, this.valueContext);
            if (fs.exists(folder)) {
                if (!fs.isDirectory(folder)) {
                    throw new HiveException("Error, not a directory: " + folder);
                }
                FileStatus[] fileStatuses = fs.listStatus(folder);
                if (fileStatuses != null && fileStatuses.length > 0) {
                    SerDe keySerDe = this.keyContext.getSerDe();
                    SerDe valueSerDe = this.valueContext.getSerDe();
                    Writable key = keySerDe.getSerializedClass().newInstance();
                    Writable value = valueSerDe.getSerializedClass().newInstance();
                    for (FileStatus fileStatus : fileStatuses) {
                        Path filePath = fileStatus.getPath();
                        if (ShimLoader.getHadoopShims().isDirectory(fileStatus)) {
                            throw new HiveException("Error, not a file: " + filePath);
                        }
                        FSDataInputStream is = null;
                        ObjectInputStream in = null;
                        try {
                            is = fs.open(filePath, 4096);
                            in = new ObjectInputStream((InputStream)is);
                            in.readUTF();
                            in.readObject();
                            int numKeys = in.readInt();
                            for (int keyIndex = 0; keyIndex < numKeys; ++keyIndex) {
                                key.readFields((DataInput)in);
                                long numRows = in.readLong();
                                for (long rowIndex = 0L; rowIndex < numRows; ++rowIndex) {
                                    value.readFields((DataInput)in);
                                    tableContainer.putRow(key, value);
                                }
                            }
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            } else if (is != null) {
                                is.close();
                            }
                        }
                    }
                }
            }
            tableContainer.seal();
            return tableContainer;
        }
        catch (IOException e) {
            throw new HiveException("IO error while trying to create table container", e);
        }
        catch (Exception e) {
            throw new HiveException("Error while trying to create table container", e);
        }
    }

    public void persist(ObjectOutputStream out, MapJoinPersistableTableContainer tableContainer) throws HiveException {
        int numKeys = tableContainer.size();
        try {
            out.writeUTF(tableContainer.getClass().getName());
            out.writeObject(tableContainer.getMetaData());
            out.writeInt(numKeys);
            for (Map.Entry<MapJoinKey, MapJoinRowContainer> entry : tableContainer.entrySet()) {
                entry.getKey().write(this.keyContext, out);
                entry.getValue().write(this.valueContext, out);
            }
        }
        catch (SerDeException e) {
            String msg = "SerDe error while attempting to persist table container";
            throw new HiveException(msg, e);
        }
        catch (IOException e) {
            String msg = "IO error while attempting to persist table container";
            throw new HiveException(msg, e);
        }
        if (numKeys != tableContainer.size()) {
            throw new ConcurrentModificationException("TableContainer was modified while persisting: " + tableContainer);
        }
    }

    public static void persistDummyTable(ObjectOutputStream out) throws IOException {
        HashMapWrapper tableContainer = new HashMapWrapper();
        out.writeUTF(tableContainer.getClass().getName());
        out.writeObject(tableContainer.getMetaData());
        out.writeInt(tableContainer.size());
    }

    private MapJoinPersistableTableContainer create(String name, Map<String, String> metaData) throws HiveException {
        try {
            Class clazz = JavaUtils.loadClass(name);
            Constructor constructor = clazz.getDeclaredConstructor(Map.class);
            return (MapJoinPersistableTableContainer)constructor.newInstance(metaData);
        }
        catch (Exception e) {
            String msg = "Error while attemping to create table container of type: " + name + ", with metaData: " + metaData;
            throw new HiveException(msg, e);
        }
    }

    private static MapJoinTableContainer getDefaultEmptyContainer(Configuration hconf, MapJoinObjectSerDeContext keyCtx, MapJoinObjectSerDeContext valCtx) throws SerDeException {
        boolean useOptimizedContainer = HiveConf.getBoolVar(hconf, HiveConf.ConfVars.HIVEMAPJOINUSEOPTIMIZEDTABLE);
        if (useOptimizedContainer) {
            return new MapJoinBytesTableContainer(hconf, valCtx, -1L, 0L);
        }
        HashMapWrapper container = new HashMapWrapper();
        container.setSerde(keyCtx, valCtx);
        container.seal();
        return container;
    }
}

