/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.spark;

import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.serializer.KryoSerializer;

final class ShuffleKryoSerializer {
    private static final String HIVE_SHUFFLE_KRYO_SERIALIZER = "org.apache.hive.spark.NoHashCodeKryoSerializer";
    private static KryoSerializer INSTANCE;

    private ShuffleKryoSerializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static KryoSerializer getInstance(JavaSparkContext sc, Configuration conf) {
        if (INSTANCE == null) {
            Class<ShuffleKryoSerializer> clazz = ShuffleKryoSerializer.class;
            synchronized (ShuffleKryoSerializer.class) {
                if (INSTANCE == null) {
                    try {
                        INSTANCE = (KryoSerializer)Thread.currentThread().getContextClassLoader().loadClass(HIVE_SHUFFLE_KRYO_SERIALIZER).getConstructor(SparkConf.class).newInstance(sc.getConf());
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return INSTANCE;
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        throw new IllegalStateException("Unable to create kryo serializer for shuffle RDDs using class org.apache.hive.spark.NoHashCodeKryoSerializer", e);
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return INSTANCE;
            }
        }
        return INSTANCE;
    }
}

