/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringUnaryUDFDirect;

public class StringRTrim
extends StringUnaryUDFDirect {
    private static final long serialVersionUID = 1L;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public StringRTrim(int inputColumn, int outputColumn) {
        super(inputColumn, outputColumn);
    }

    public StringRTrim() {
    }

    @Override
    protected void func(BytesColumnVector outV, byte[][] vector, int[] start, int[] length, int batchIndex) {
        int index;
        byte[] bytes = vector[batchIndex];
        int startIndex = start[batchIndex];
        for (index = startIndex + length[batchIndex] - 1; index >= startIndex && bytes[index] == 32; --index) {
        }
        int resultLength = index - startIndex + 1;
        if (resultLength == 0) {
            outV.setVal(batchIndex, EMPTY_BYTES, 0, 0);
            return;
        }
        outV.setVal(batchIndex, bytes, startIndex, resultLength);
    }
}

