/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DecimalUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class DecimalColModuloDecimalColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumn;

    public DecimalColModuloDecimalColumn(int colNum1, int colNum2, int outputColumn) {
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
        this.outputColumn = outputColumn;
    }

    public DecimalColModuloDecimalColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DecimalColumnVector inputColVector1 = (DecimalColumnVector)batch.cols[this.colNum1];
        DecimalColumnVector inputColVector2 = (DecimalColumnVector)batch.cols[this.colNum2];
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.cols[this.outputColumn];
        boolean[] outputIsNull = outputColVector.isNull;
        int[] sel = batch.selected;
        HiveDecimalWritable[] vector1 = inputColVector1.vector;
        HiveDecimalWritable[] vector2 = inputColVector2.vector;
        NullUtil.propagateNullsColCol(inputColVector1, inputColVector2, outputColVector, sel, n, batch.selectedInUse);
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            DecimalUtil.moduloChecked(0, vector1[0], vector2[0], outputColVector);
        } else if (inputColVector1.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    DecimalUtil.moduloChecked(i, vector1[0], vector2[i], outputColVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    DecimalUtil.moduloChecked(i, vector1[0], vector2[i], outputColVector);
                }
            }
        } else if (inputColVector2.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    DecimalUtil.moduloChecked(i, vector1[i], vector2[0], outputColVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    DecimalUtil.moduloChecked(i, vector1[i], vector2[0], outputColVector);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                DecimalUtil.moduloChecked(i, vector1[i], vector2[i], outputColVector);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                DecimalUtil.moduloChecked(i, vector1[i], vector2[i], outputColVector);
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum1 + ", col " + this.colNum2;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("decimal"), VectorExpressionDescriptor.ArgumentType.getType("decimal")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

