/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Timestamp;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.DateTimeMath;

public class TimestampColSubtractIntervalDayTimeColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum1;
    private int colNum2;
    private int outputColumn;
    private DateTimeMath dtm = new DateTimeMath();

    public TimestampColSubtractIntervalDayTimeColumn(int colNum1, int colNum2, int outputColumn) {
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
        this.outputColumn = outputColumn;
    }

    public TimestampColSubtractIntervalDayTimeColumn() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        TimestampColumnVector inputColVector1 = (TimestampColumnVector)batch.cols[this.colNum1];
        IntervalDayTimeColumnVector inputColVector2 = (IntervalDayTimeColumnVector)batch.cols[this.colNum2];
        TimestampColumnVector outputColVector = (TimestampColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        NullUtil.propagateNullsColCol(inputColVector1, inputColVector2, outputColVector, sel, n, batch.selectedInUse);
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            this.dtm.subtract(inputColVector1.asScratchTimestamp(0), inputColVector2.asScratchIntervalDayTime(0), outputColVector.getScratchTimestamp());
            outputColVector.setFromScratchTimestamp(0);
        } else if (inputColVector1.isRepeating) {
            Timestamp value1 = inputColVector1.asScratchTimestamp(0);
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.dtm.subtract(value1, inputColVector2.asScratchIntervalDayTime(i), outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.dtm.subtract(value1, inputColVector2.asScratchIntervalDayTime(i), outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            }
        } else if (inputColVector2.isRepeating) {
            HiveIntervalDayTime value2 = inputColVector2.asScratchIntervalDayTime(0);
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.dtm.subtract(inputColVector1.asScratchTimestamp(i), value2, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    this.dtm.subtract(inputColVector1.asScratchTimestamp(i), value2, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                this.dtm.subtract(inputColVector1.asScratchTimestamp(i), inputColVector2.asScratchIntervalDayTime(i), outputColVector.getScratchTimestamp());
                outputColVector.setFromScratchTimestamp(i);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.dtm.subtract(inputColVector1.asScratchTimestamp(i), inputColVector2.asScratchIntervalDayTime(i), outputColVector.getScratchTimestamp());
                outputColVector.setFromScratchTimestamp(i);
            }
        }
        NullUtil.setNullDataEntriesTimestamp(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.colNum1 + ", col " + this.colNum2;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("timestamp"), VectorExpressionDescriptor.ArgumentType.getType("interval_day_time")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

