/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.log;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.log.HushableRandomAccessFileAppender;
import org.apache.hadoop.hive.ql.log.NullAppender;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.routing.Route;
import org.apache.logging.log4j.core.appender.routing.Routes;
import org.apache.logging.log4j.core.appender.routing.RoutingAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Node;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.processor.PluginEntry;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;

public final class LogDivertAppenderForTest {
    public static final String TEST_QUERY_ROUTING_APPENDER = "test-query-routing";

    private LogDivertAppenderForTest() {
    }

    public static void registerRoutingAppenderIfInTest(org.apache.hadoop.conf.Configuration conf) {
        if (!conf.getBoolean(HiveConf.ConfVars.HIVE_IN_TEST.varname, HiveConf.ConfVars.HIVE_IN_TEST.defaultBoolVal)) {
            return;
        }
        String logLocation = HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_SERVER2_LOGGING_OPERATION_LOG_LOCATION);
        PluginEntry nullAppenderEntry = new PluginEntry();
        nullAppenderEntry.setClassName(NullAppender.class.getName());
        PluginType nullAppenderType = new PluginType(nullAppenderEntry, NullAppender.class, "appender");
        Node nullAppenderChildNode = new Node(null, "test-null-appender", nullAppenderType);
        PluginEntry defaultRouteEntry = new PluginEntry();
        defaultRouteEntry.setClassName(Route.class.getName());
        PluginType defaultRouteType = new PluginType(defaultRouteEntry, Route.class, "");
        Node defaultRouteNode = new Node(null, "test-route-default", defaultRouteType);
        defaultRouteNode.getChildren().add(nullAppenderChildNode);
        PluginEntry queryIdRouteEntry = new PluginEntry();
        queryIdRouteEntry.setClassName(Route.class.getName());
        PluginType queryIdRouteType = new PluginType(queryIdRouteEntry, Route.class, "");
        Node queryIdRouteNode = new Node(null, "test-route-mdc", queryIdRouteType);
        PluginEntry queryIdAppenderEntry = new PluginEntry();
        queryIdAppenderEntry.setClassName(HushableRandomAccessFileAppender.class.getName());
        PluginType queryIdAppenderType = new PluginType(queryIdAppenderEntry, HushableRandomAccessFileAppender.class, "appender");
        Node queryIdAppenderNode = new Node(queryIdRouteNode, "test-query-file-appender", queryIdAppenderType);
        queryIdAppenderNode.getAttributes().put("fileName", logLocation + "/${ctx:sessionId}/${ctx:queryId}.test");
        queryIdAppenderNode.getAttributes().put("name", "test-query-file-appender");
        queryIdRouteNode.getChildren().add(queryIdAppenderNode);
        PluginEntry filterEntry = new PluginEntry();
        filterEntry.setClassName(TestFilter.class.getName());
        PluginType filterType = new PluginType(filterEntry, TestFilter.class, "");
        Node filterNode = new Node(queryIdAppenderNode, "test-filter", filterType);
        queryIdAppenderNode.getChildren().add(filterNode);
        PluginEntry layoutEntry = new PluginEntry();
        layoutEntry.setClassName(PatternLayout.class.getName());
        PluginType layoutType = new PluginType(layoutEntry, PatternLayout.class, "");
        Node layoutNode = new Node(queryIdAppenderNode, "PatternLayout", layoutType);
        layoutNode.getAttributes().put("pattern", "%-5p : %m%n");
        queryIdAppenderNode.getChildren().add(layoutNode);
        Route defaultRoute = Route.createRoute(null, (String)"${ctx:queryId}", (Node)defaultRouteNode);
        Route mdcRoute = Route.createRoute(null, null, (Node)queryIdRouteNode);
        Routes routes = Routes.newBuilder().withPattern("${ctx:queryId}").withRoutes(new Route[]{defaultRoute, mdcRoute}).build();
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = context.getConfiguration();
        RoutingAppender routingAppender = ((RoutingAppender.Builder)((RoutingAppender.Builder)((RoutingAppender.Builder)RoutingAppender.newBuilder().withName(TEST_QUERY_ROUTING_APPENDER)).withIgnoreExceptions(true)).withRoutes(routes).setConfiguration(configuration)).build();
        LoggerConfig loggerConfig = configuration.getRootLogger();
        loggerConfig.addAppender((Appender)routingAppender, null, null);
        context.updateLoggers();
        routingAppender.start();
    }

    @Plugin(name="TestFilter", category="Core", elementType="filter", printObject=true)
    private static class TestFilter
    extends AbstractFilter {
        private TestFilter() {
        }

        public Filter.Result filter(LogEvent event) {
            if (event.getLevel().equals((Object)Level.INFO) && "SessionState".equals(event.getLoggerName()) && (event.getMessage().getFormattedMessage().startsWith("PREHOOK:") || event.getMessage().getFormattedMessage().startsWith("POSTHOOK:") || event.getMessage().getFormattedMessage().startsWith("unix_timestamp(void)") || event.getMessage().getFormattedMessage().startsWith("Warning: "))) {
                return Filter.Result.ACCEPT;
            }
            return Filter.Result.DENY;
        }

        @PluginFactory
        public static TestFilter createFilter() {
            return new TestFilter();
        }
    }
}

