/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.plan.FetchWork;

public class ExplainSemanticAnalyzer
extends BaseSemanticAnalyzer {
    List<FieldSchema> fieldList;
    ExplainConfiguration config = new ExplainConfiguration();

    public ExplainSemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        FetchTask fetchTask;
        int childCount = ast.getChildCount();
        for (int i = 1; i < childCount; ++i) {
            int explainOptions = ast.getChild(i).getType();
            if (explainOptions == 131) {
                this.config.setFormatted(true);
                continue;
            }
            if (explainOptions == 116) {
                this.config.setExtended(true);
                continue;
            }
            if (explainOptions == 91) {
                this.config.setDependency(true);
                continue;
            }
            if (explainOptions == 177) {
                this.config.setLogical(true);
                continue;
            }
            if (explainOptions == 40) {
                this.config.setAuthorize(true);
                continue;
            }
            if (explainOptions != 320) continue;
            this.config.setVectorization(true);
            if (i + 1 >= childCount) continue;
            int vectorizationOption = ast.getChild(i + 1).getType();
            if (vectorizationOption == 829) {
                this.config.setVectorizationOnly(true);
                if (++i + 1 >= childCount) break;
                vectorizationOption = ast.getChild(i + 1).getType();
            }
            if (vectorizationOption == 940) {
                this.config.setVectorizationDetailLevel(ExplainConfiguration.VectorizationDetailLevel.SUMMARY);
                ++i;
                continue;
            }
            if (vectorizationOption == 830) {
                this.config.setVectorizationDetailLevel(ExplainConfiguration.VectorizationDetailLevel.OPERATOR);
                ++i;
                continue;
            }
            if (vectorizationOption == 755) {
                this.config.setVectorizationDetailLevel(ExplainConfiguration.VectorizationDetailLevel.EXPRESSION);
                ++i;
                continue;
            }
            if (vectorizationOption != 738) continue;
            this.config.setVectorizationDetailLevel(ExplainConfiguration.VectorizationDetailLevel.DETAIL);
            ++i;
        }
        this.ctx.setExplain(true);
        this.ctx.setExplainLogical(this.config.isLogical());
        ASTNode input = (ASTNode)ast.getChild(0);
        BaseSemanticAnalyzer sem = SemanticAnalyzerFactory.get(this.queryState, input);
        sem.analyze(input, this.ctx);
        sem.validate();
        this.inputs = sem.getInputs();
        this.outputs = sem.getOutputs();
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        List<Task<Serializable>> tasks = sem.getAllRootTasks();
        if (tasks == null) {
            tasks = Collections.emptyList();
        }
        if ((fetchTask = sem.getFetchTask()) != null) {
            ((FetchWork)fetchTask.getWork()).initializeForFetch(this.ctx.getOpContext());
        }
        ParseContext pCtx = null;
        if (sem instanceof SemanticAnalyzer) {
            pCtx = ((SemanticAnalyzer)sem).getParseContext();
        }
        this.config.setUserLevelExplain(!this.config.isExtended() && !this.config.isFormatted() && !this.config.isDependency() && !this.config.isLogical() && !this.config.isAuthorize() && HiveConf.getBoolVar(this.ctx.getConf(), HiveConf.ConfVars.HIVE_EXPLAIN_USER) && HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez"));
        ExplainWork work = new ExplainWork(this.ctx.getResFile(), pCtx, tasks, fetchTask, sem, this.config, this.ctx.getCboInfo());
        work.setAppendTaskType(HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVEEXPLAINDEPENDENCYAPPENDTASKTYPES));
        ExplainTask explTask = (ExplainTask)TaskFactory.get(work, this.conf, new Task[0]);
        this.fieldList = explTask.getResultSchema();
        this.rootTasks.add(explTask);
    }

    @Override
    public List<FieldSchema> getResultSchema() {
        return this.fieldList;
    }

    @Override
    public boolean skipAuthorization() {
        List<Task<? extends Serializable>> rootTasks = this.getRootTasks();
        assert (rootTasks != null && rootTasks.size() == 1);
        Task<? extends Serializable> task = rootTasks.get(0);
        return task instanceof ExplainTask && ((ExplainWork)((ExplainTask)task).getWork()).isAuthorize();
    }
}

