/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.util.HashSet;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.LongWritable;

@Description(name="count", value="_FUNC_(*) - Returns the total number of retrieved rows, including rows containing NULL values.\n_FUNC_(expr) - Returns the number of rows for which the supplied expression is non-NULL.\n_FUNC_(DISTINCT expr[, expr...]) - Returns the number of rows for which the supplied expression(s) are unique and non-NULL.")
public class GenericUDAFCount
implements GenericUDAFResolver2 {
    @Override
    public GenericUDAFEvaluator getEvaluator(TypeInfo[] parameters) throws SemanticException {
        return new GenericUDAFCountEvaluator();
    }

    @Override
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo paramInfo) throws SemanticException {
        TypeInfo[] parameters = paramInfo.getParameters();
        if (parameters.length == 0) {
            if (!paramInfo.isAllColumns()) {
                throw new UDFArgumentException("Argument expected");
            }
            assert (!paramInfo.isDistinct()) : "DISTINCT not supported with *";
        } else {
            if (parameters.length > 1 && !paramInfo.isDistinct()) {
                throw new UDFArgumentException("DISTINCT keyword must be specified");
            }
            assert (!paramInfo.isAllColumns()) : "* not supported in expression list";
        }
        GenericUDAFCountEvaluator countEvaluator = new GenericUDAFCountEvaluator();
        countEvaluator.setWindowing(paramInfo.isWindowing());
        countEvaluator.setCountAllColumns(paramInfo.isAllColumns());
        countEvaluator.setCountDistinct(paramInfo.isDistinct());
        return countEvaluator;
    }

    public static class GenericUDAFCountEvaluator
    extends GenericUDAFEvaluator {
        private boolean isWindowing = false;
        private boolean countAllColumns = false;
        private boolean countDistinct = false;
        private LongObjectInspector partialCountAggOI;
        private ObjectInspector[] inputOI;
        private ObjectInspector[] outputOI;
        private LongWritable result;

        @Override
        public ObjectInspector init(GenericUDAFEvaluator.Mode m, ObjectInspector[] parameters) throws HiveException {
            super.init(m, parameters);
            if (this.mode == GenericUDAFEvaluator.Mode.PARTIAL2 || this.mode == GenericUDAFEvaluator.Mode.FINAL) {
                this.partialCountAggOI = (LongObjectInspector)parameters[0];
            } else {
                this.inputOI = parameters;
                this.outputOI = ObjectInspectorUtils.getStandardObjectInspector(this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA);
            }
            this.result = new LongWritable(0L);
            return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        }

        public void setWindowing(boolean isWindowing) {
            this.isWindowing = isWindowing;
        }

        private void setCountAllColumns(boolean countAllCols) {
            this.countAllColumns = countAllCols;
        }

        private void setCountDistinct(boolean countDistinct) {
            this.countDistinct = countDistinct;
        }

        private boolean isWindowingDistinct() {
            return this.isWindowing && this.countDistinct;
        }

        @Override
        public GenericUDAFEvaluator.AggregationBuffer getNewAggregationBuffer() throws HiveException {
            CountAgg buffer = new CountAgg();
            this.reset(buffer);
            return buffer;
        }

        @Override
        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            ((CountAgg)agg).value = 0L;
            ((CountAgg)agg).uniqueObjects = new HashSet();
        }

        @Override
        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            if (parameters == null) {
                return;
            }
            if (this.countAllColumns) {
                assert (parameters.length == 0);
                ++((CountAgg)agg).value;
            } else {
                boolean countThisRow = true;
                for (Object nextParam : parameters) {
                    if (nextParam != null) continue;
                    countThisRow = false;
                    break;
                }
                if (countThisRow && this.isWindowingDistinct()) {
                    HashSet<ObjectInspectorUtils.ObjectInspectorObject> uniqueObjs = ((CountAgg)agg).uniqueObjects;
                    ObjectInspectorUtils.ObjectInspectorObject obj = new ObjectInspectorUtils.ObjectInspectorObject(ObjectInspectorUtils.copyToStandardObject(parameters, this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.JAVA), this.outputOI);
                    if (!uniqueObjs.contains(obj)) {
                        uniqueObjs.add(obj);
                    } else {
                        countThisRow = false;
                    }
                }
                if (countThisRow) {
                    ++((CountAgg)agg).value;
                }
            }
        }

        @Override
        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object partial) throws HiveException {
            if (partial != null) {
                CountAgg countAgg = (CountAgg)agg;
                if (this.isWindowingDistinct()) {
                    throw new HiveException("Distinct windowing UDAF doesn't support merge and terminatePartial");
                }
                long p = this.partialCountAggOI.get(partial);
                countAgg.value += p;
            }
        }

        @Override
        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            this.result.set(((CountAgg)agg).value);
            return this.result;
        }

        @Override
        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            if (this.isWindowingDistinct()) {
                throw new HiveException("Distinct windowing UDAF doesn't support merge and terminatePartial");
            }
            return this.terminate(agg);
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        static class CountAgg
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            HashSet<ObjectInspectorUtils.ObjectInspectorObject> uniqueObjects;
            long value;

            CountAgg() {
            }

            @Override
            public int estimate() {
                return 8;
            }
        }
    }
}

