/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.parquet.column.values.plain;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hive.org.apache.parquet.column.values.ValuesReader;
import org.apache.hive.org.apache.parquet.io.ParquetDecodingException;
import org.apache.hive.org.apache.parquet.io.api.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedLenByteArrayPlainValuesReader
extends ValuesReader {
    private static final Logger LOG = LoggerFactory.getLogger(FixedLenByteArrayPlainValuesReader.class);
    private ByteBuffer in;
    private int offset;
    private int length;

    public FixedLenByteArrayPlainValuesReader(int length) {
        this.length = length;
    }

    @Override
    public Binary readBytes() {
        try {
            int start = this.offset;
            this.offset = start + this.length;
            return Binary.fromConstantByteBuffer(this.in, start, this.length);
        }
        catch (RuntimeException e) {
            throw new ParquetDecodingException("could not read bytes at offset " + this.offset, e);
        }
    }

    @Override
    public void skip() {
        this.offset += this.length;
    }

    @Override
    public void initFromPage(int valueCount, ByteBuffer in, int offset) throws IOException {
        LOG.debug("init from page at offset {} for length {}", (Object)offset, (Object)(in.limit() - offset));
        this.in = in;
        this.offset = offset;
    }
}

