/*
 * Decompiled with CFR 0.152.
 */
package org.talend.camel;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.camel.TalendEndpoint;
import routines.system.api.TalendESBRoute;
import routines.system.api.TalendJob;

public class TalendProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(TalendProducer.class);
    private Thread workingThread;
    private TalendJob jobInstance;

    public TalendProducer(TalendEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Exchange exchange) throws Exception {
        TalendEndpoint talendEndpoint = (TalendEndpoint)this.getEndpoint();
        String context = talendEndpoint.getContext();
        ArrayList<String> args = new ArrayList<String>();
        if (context != null) {
            args.add("--context=" + context);
        }
        if (talendEndpoint.isPropagateHeader()) {
            TalendProducer.getParamsFromHeaders(exchange, args);
        }
        TalendProducer.getParamsFromProperties(this.getEndpoint().getCamelContext().getProperties(), args);
        TalendProducer.getParamsFromProperties(talendEndpoint.getEndpointProperties(), args);
        boolean success = false;
        TalendJob jobInstance = this.getJobInstance();
        try {
            this.invokeTalendJob(jobInstance, args.toArray(new String[args.size()]), exchange);
            this.jobDone();
            success = true;
        }
        finally {
            if (!success) {
                this.jobDown();
            }
        }
    }

    private static void getParamsFromProperties(Map<String, String> propertiesMap, Collection<String> args) {
        if (propertiesMap != null) {
            for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
                args.add("--context_param " + entry.getKey() + '=' + entry.getValue());
            }
        }
    }

    private static void getParamsFromHeaders(Exchange exchange, Collection<String> args) {
        Map headers = exchange.getIn().getHeaders();
        for (Map.Entry header : headers.entrySet()) {
            Object headerValue = header.getValue();
            if (headerValue == null) continue;
            String headerStringValue = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, headerValue);
            args.add("--context_param " + (String)header.getKey() + '=' + headerStringValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeTalendJob(TalendJob jobInstance, String[] args, Exchange exchange) {
        Thread thread;
        try {
            Method setExchangeMethod = jobInstance.getClass().getMethod("setExchange", Exchange.class);
            LOG.debug("Pass the exchange from route to Job");
            ObjectHelper.invokeMethod((Method)setExchangeMethod, (Object)jobInstance, (Object[])new Object[]{exchange});
        }
        catch (NoSuchMethodException e) {
            LOG.debug("No setExchange(exchange) method found in Job, the message data will be ignored");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking Talend job '" + jobInstance.getClass().getCanonicalName() + ".runJob(String[] args)' with args: " + Arrays.toString(args));
        }
        this.workingThread = thread = Thread.currentThread();
        ClassLoader oldContextCL = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(jobInstance.getClass().getClassLoader());
            int result = jobInstance.runJobInTOS(args);
            if (result != 0) {
                throw new RuntimeCamelException("Execution of Talend job '" + jobInstance.getClass().getCanonicalName() + "' with args: " + Arrays.toString(args) + "' failed, see stderr for details");
            }
        }
        finally {
            thread.setContextClassLoader(oldContextCL);
            this.workingThread = null;
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        boolean success = false;
        try {
            TalendJob wjob = this.jobInstance;
            if (wjob instanceof TalendESBRoute) {
                ((TalendESBRoute)wjob).stop();
                LOG.info("Job instance stopped.");
                ((Object)((Object)this)).wait(100L);
            }
            success = true;
        }
        finally {
            Thread wthread = this.workingThread;
            if (null != wthread) {
                LOG.info("Enforce Talend job termination.");
                wthread.interrupt();
            }
            if (!success) {
                this.jobDown();
            }
        }
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        this.jobDown();
    }

    private TalendJob getJobInstance() throws Exception {
        if (this.jobInstance == null) {
            this.jobInstance = ((TalendEndpoint)this.getEndpoint()).getJobInstance();
            LOG.debug("Getting new job instance.");
        } else {
            LOG.debug("Re-using sticky job instance.");
        }
        return this.jobInstance;
    }

    private void jobDone() throws Exception {
        if (!((TalendEndpoint)this.getEndpoint()).isStickyJob()) {
            this.jobDown();
        }
    }

    private void jobDown() throws Exception {
        TalendJob job = this.jobInstance;
        this.jobInstance = null;
        if (job instanceof TalendESBRoute) {
            ((TalendESBRoute)job).shutdown();
            LOG.info("Job instance shut down.");
        }
    }
}

