/*
 * Decompiled with CFR 0.152.
 */
package org.talend.camel;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.camel.TalendEndpoint;
import routines.system.api.TalendESBJobBean;
import routines.system.api.TalendJob;

public class TalendProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(TalendProducer.class);
    private TalendESBJobBean jobInstance;
    private final boolean stickyJob;
    private final boolean propagateHeader;

    public TalendProducer(TalendEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.stickyJob = endpoint.isStickyJob();
        this.propagateHeader = endpoint.isPropagateHeader();
    }

    public void process(Exchange exchange) throws Exception {
        this.invokeTalendJob(exchange);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.stickyJob) {
            if (this.jobInstance == null) {
                this.jobInstance = this.createJobInstance();
            }
            this.jobInstance.prepareJob(this.prepareArgs(null));
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.stickyJob && this.jobInstance != null) {
            this.jobInstance.discardJob();
            this.jobInstance = null;
        }
    }

    private String[] prepareArgs(Exchange exchange) {
        TalendEndpoint talendEndpoint = (TalendEndpoint)this.getEndpoint();
        String context = talendEndpoint.getContext();
        ArrayList<String> args = new ArrayList<String>();
        if (context != null) {
            args.add("--context=" + context);
        }
        if (this.propagateHeader && exchange != null) {
            TalendProducer.getParamsFromHeaders(exchange, args);
        }
        TalendProducer.getParamsFromProperties(this.getEndpoint().getCamelContext().getProperties(), args);
        TalendProducer.getParamsFromProperties(talendEndpoint.getEndpointProperties(), args);
        return args.toArray(new String[args.size()]);
    }

    private String[] prepareHeaderArgs(Exchange exchange) {
        if (!this.propagateHeader || exchange == null) {
            return null;
        }
        ArrayList<String> args = new ArrayList<String>();
        TalendProducer.getParamsFromHeaders(exchange, args);
        return args.toArray(new String[args.size()]);
    }

    private static void getParamsFromProperties(Map<String, String> propertiesMap, Collection<String> args) {
        if (propertiesMap != null) {
            for (Map.Entry<String, String> entry : propertiesMap.entrySet()) {
                args.add("--context_param " + entry.getKey() + '=' + entry.getValue());
            }
        }
    }

    private static void getParamsFromHeaders(Exchange exchange, Collection<String> args) {
        Map headers = exchange.getIn().getHeaders();
        for (Map.Entry header : headers.entrySet()) {
            Object headerValue = header.getValue();
            if (headerValue == null) continue;
            String headerStringValue = (String)exchange.getContext().getTypeConverter().convertTo(String.class, exchange, headerValue);
            args.add("--context_param " + (String)header.getKey() + '=' + headerStringValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeTalendJob(Exchange exchange) throws Exception {
        TalendESBJobBean jobBean;
        TalendESBJobBean talendESBJobBean = jobBean = this.stickyJob ? this.jobInstance : this.createJobInstance();
        if (jobBean == null) {
            throw new IllegalStateException("Job instance not initialized for invocation. ");
        }
        Thread currentThread = Thread.currentThread();
        ClassLoader oldCtxClassLoader = currentThread.getContextClassLoader();
        try {
            currentThread.setContextClassLoader(jobBean.getJobClass().getClassLoader());
            if (this.stickyJob) {
                String[] args = this.prepareHeaderArgs(exchange);
                this.logJobInvocation(jobBean, args);
                jobBean.runPreparedJob(Collections.singletonMap("exchange", exchange), args);
            } else {
                String[] args = this.prepareArgs(exchange);
                this.logJobInvocation(jobBean, args);
                jobBean.runSingleUseJob(Collections.singletonMap("exchange", exchange), args);
            }
        }
        finally {
            currentThread.setContextClassLoader(oldCtxClassLoader);
        }
    }

    private TalendESBJobBean createJobInstance() throws Exception {
        TalendJob job = ((TalendEndpoint)this.getEndpoint()).getJobInstance();
        TalendESBJobBean jobBean = null;
        LOG.debug("Getting new job instance.");
        try {
            Field esbJobBeanField = job.getClass().getField("esbJobBean");
            jobBean = (TalendESBJobBean)esbJobBeanField.get(job);
        }
        catch (NoSuchFieldException e) {
            LOG.debug("Reflective retrieval of Job access bean failed, assuming old-style job. ", (Throwable)e);
        }
        return jobBean == null ? new JobWrapper(job) : jobBean;
    }

    private void logJobInvocation(TalendESBJobBean job, String[] args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking Talend job '" + job.getJobClass().getCanonicalName() + ".runJob(String[] args)' with args: " + (args == null ? "none" : Arrays.toString(args)));
        }
    }

    private static class JobWrapper
    implements TalendESBJobBean {
        private final TalendJob job;

        public JobWrapper(TalendJob job) {
            this.job = job;
        }

        public void prepareJob(String[] args) {
        }

        public void discardJob() {
        }

        public void runPreparedJob(Map<String, Object> exchangeData, String[] args) {
            this.setExchangeInJob((Exchange)exchangeData.get("exchange"));
            int success = this.job.runJobInTOS(args);
            if (success != 0) {
                this.signalJobFailure(args);
            }
        }

        public void runSingleUseJob(Map<String, Object> exchangeData, String[] args) {
            this.setExchangeInJob((Exchange)exchangeData.get("exchange"));
            int success = this.job.runJobInTOS(args);
            if (success != 0) {
                this.signalJobFailure(args);
            }
        }

        public Class<?> getJobClass() {
            return this.job.getClass();
        }

        private void setExchangeInJob(Exchange exchange) {
            try {
                Method setExchangeMethod = this.job.getClass().getMethod("setExchange", Exchange.class);
                LOG.debug("Pass the exchange from route to Job");
                ObjectHelper.invokeMethod((Method)setExchangeMethod, (Object)this.job, (Object[])new Object[]{exchange});
            }
            catch (NoSuchMethodException e) {
                LOG.debug("No setExchange(exchange) method found in Job, the message data will be ignored");
            }
        }

        private void signalJobFailure(String[] args) {
            throw new RuntimeCamelException("Execution of Talend job '" + this.job.getClass().getCanonicalName() + "' with args: " + (args == null ? "none" : Arrays.toString(args)) + "' failed, see stderr for details. ");
        }
    }
}

