/*
 * Decompiled with CFR 0.152.
 */
package org.talend.ci.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.talend.jobbuilder.model.BundleInfo;
import org.talend.utils.io.FilesUtils;

public class Utils {
    public static String formatUriStr(String path) throws URISyntaxException {
        if (!path.toLowerCase().startsWith("http")) {
            return new File(path).toURI().toString();
        }
        return path;
    }

    public static Properties getBuildProperties(String commandlineWorkspace) throws MojoFailureException {
        Properties buildProperties = new Properties();
        File buildPropertiesFile = new File(commandlineWorkspace, "build.properties");
        if (buildPropertiesFile.exists()) {
            try (FileReader reader = new FileReader(buildPropertiesFile);){
                buildProperties.load(reader);
            }
            catch (IOException e) {
                throw new MojoFailureException("Loading build.properties failed:", (Throwable)e);
            }
        }
        return buildProperties;
    }

    public static void storeBuildProperties(String commandlineWorkspace, Properties properties) throws MojoFailureException {
        if (properties == null) {
            properties = Utils.getBuildProperties(commandlineWorkspace);
        }
        File buildPropertiesFile = new File(commandlineWorkspace, "build.properties");
        try (FileWriter writer = new FileWriter(buildPropertiesFile);){
            properties.store(writer, "Update build.properties by CI-builder");
        }
        catch (IOException e) {
            throw new MojoFailureException("Writing build.properties failed:", (Throwable)e);
        }
    }

    public static void setupCredential(final String username, final String password) {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password.toCharArray());
            }
        });
    }

    protected static void refreshBundlesInfo() throws Exception {
        LinkedHashSet<BundleInfo> bundleList = new LinkedHashSet<BundleInfo>();
        String path = Utils.class.getClassLoader().getResource("p2installer/bundles.info").getPath();
        try (BufferedReader reader = new BufferedReader(new FileReader(new File(path)));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                BundleInfo bundleInfo = new BundleInfo(line);
                bundleList.add(bundleInfo);
            }
        }
        String updateSite = "D:\\Build\\Talend_Full_Studio_p2_repository-20190308_1937-V7.2.1SNAPSHOT\\plugins";
        File pluginsFolder = new File(updateSite);
        List<File> plugins = Arrays.asList(pluginsFolder.listFiles());
        Iterator iterator = bundleList.iterator();
        while (iterator.hasNext()) {
            BundleInfo bundleInfo = (BundleInfo)iterator.next();
            File lastestVersion = null;
            for (File plugin : plugins) {
                if (!plugin.getName().startsWith(bundleInfo.getBundleId() + "_")) continue;
                if (lastestVersion == null) {
                    lastestVersion = plugin;
                    continue;
                }
                if (plugin.getName().compareTo(lastestVersion.getName()) <= 0) continue;
                lastestVersion = plugin;
            }
            if (lastestVersion == null) {
                System.out.println("didn't find bundle:" + bundleInfo.getBundleId());
                iterator.remove();
                continue;
            }
            FilesUtils.copyFile(lastestVersion, new File("E:/installer/plugins/" + lastestVersion.getName()));
            String version = StringUtils.removeEnd((String)lastestVersion.getName(), (String)".jar");
            version = StringUtils.substringAfterLast((String)version, (String)"_");
            String oldVersion = bundleInfo.getBundleVersion();
            bundleInfo.setBundleVersion(version);
            bundleInfo.setBundleLocation(bundleInfo.getBundleLocation().replace(oldVersion, version));
        }
        BufferedWriter writer = new BufferedWriter(new FileWriter("E:/installer/configuration/org.eclipse.equinox.simpleconfigurator/bundles.info"));
        writer.write("#encoding=UTF-8\n");
        writer.write("#version=1\n");
        for (BundleInfo bundleInfo : bundleList) {
            writer.write(bundleInfo.toString() + "\n");
        }
        writer.flush();
        writer.close();
    }

    public static String getBase64Credentials(String url) {
        int index;
        String nameAndPwd = null;
        if (url.startsWith("https://")) {
            int index2 = url.indexOf("@");
            if (index2 > -1) {
                nameAndPwd = url.substring(8, index2);
            }
        } else if (url.startsWith("http://") && (index = url.indexOf("@")) > -1) {
            nameAndPwd = url.substring(7, index);
        }
        if (StringUtils.isEmpty(nameAndPwd)) {
            return null;
        }
        return Base64.encodeBase64String((byte[])nameAndPwd.getBytes());
    }

    public static String getBasicAuthCredentials(String url, String[] userAndPwd, Log log) {
        String credentials = Utils.getBase64Credentials(url);
        if (!StringUtils.isEmpty((String)credentials)) {
            return credentials;
        }
        String basicAuthClear = null;
        if (userAndPwd != null && userAndPwd.length == 2 && !StringUtils.isEmpty((String)userAndPwd[0]) && !StringUtils.isEmpty((String)userAndPwd[1])) {
            basicAuthClear = userAndPwd[0] + ":" + userAndPwd[1];
        }
        if (basicAuthClear == null) {
            return null;
        }
        return Base64.encodeBase64String((byte[])basicAuthClear.getBytes());
    }

    public static void copyFromJar(String source, final Path target) throws Exception {
        URI resource = Utils.class.getResource("").toURI();
        try (FileSystem fileSystem = FileSystems.newFileSystem(resource, Collections.emptyMap());){
            final Path jarPath = fileSystem.getPath(source, new String[0]);
            Files.walkFileTree(jarPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){
                private Path currentTarget;

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    this.currentTarget = target.resolve(jarPath.relativize(dir).toString());
                    Files.createDirectories(this.currentTarget, new FileAttribute[0]);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.copy(file, target.resolve(jarPath.relativize(file).toString()), StandardCopyOption.REPLACE_EXISTING);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

